<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SendDefinitionList StructType
 * Meta informations extracted from the WSDL
 * - type: tns:SendDefinitionList
 * @subpackage Structs
 */
class SendDefinitionList extends AudienceItem
{
    /**
     * The FilterDefinition
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\FilterDefinition
     */
    public $FilterDefinition;
    /**
     * The IsTestObject
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IsTestObject;
    /**
     * The SalesForceObjectID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SalesForceObjectID;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Parameters
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\Parameters
     */
    public $Parameters;
    /**
     * Constructor method for SendDefinitionList
     * @uses SendDefinitionList::setFilterDefinition()
     * @uses SendDefinitionList::setIsTestObject()
     * @uses SendDefinitionList::setSalesForceObjectID()
     * @uses SendDefinitionList::setName()
     * @uses SendDefinitionList::setParameters()
     * @param \App\Library\ExactTarget\StructType\FilterDefinition $filterDefinition
     * @param bool $isTestObject
     * @param string $salesForceObjectID
     * @param string $name
     * @param \App\Library\ExactTarget\StructType\Parameters $parameters
     */
    public function __construct(\App\Library\ExactTarget\StructType\FilterDefinition $filterDefinition = null, $isTestObject = null, $salesForceObjectID = null, $name = null, \App\Library\ExactTarget\StructType\Parameters $parameters = null)
    {
        $this
            ->setFilterDefinition($filterDefinition)
            ->setIsTestObject($isTestObject)
            ->setSalesForceObjectID($salesForceObjectID)
            ->setName($name)
            ->setParameters($parameters);
    }
    /**
     * Get FilterDefinition value
     * @return \App\Library\ExactTarget\StructType\FilterDefinition|null
     */
    public function getFilterDefinition()
    {
        return $this->FilterDefinition;
    }
    /**
     * Set FilterDefinition value
     * @param \App\Library\ExactTarget\StructType\FilterDefinition $filterDefinition
     * @return \App\Library\ExactTarget\StructType\SendDefinitionList
     */
    public function setFilterDefinition(\App\Library\ExactTarget\StructType\FilterDefinition $filterDefinition = null)
    {
        $this->FilterDefinition = $filterDefinition;
        return $this;
    }
    /**
     * Get IsTestObject value
     * @return bool|null
     */
    public function getIsTestObject()
    {
        return $this->IsTestObject;
    }
    /**
     * Set IsTestObject value
     * @param bool $isTestObject
     * @return \App\Library\ExactTarget\StructType\SendDefinitionList
     */
    public function setIsTestObject($isTestObject = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTestObject) && !is_bool($isTestObject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isTestObject)), __LINE__);
        }
        $this->IsTestObject = $isTestObject;
        return $this;
    }
    /**
     * Get SalesForceObjectID value
     * @return string|null
     */
    public function getSalesForceObjectID()
    {
        return $this->SalesForceObjectID;
    }
    /**
     * Set SalesForceObjectID value
     * @param string $salesForceObjectID
     * @return \App\Library\ExactTarget\StructType\SendDefinitionList
     */
    public function setSalesForceObjectID($salesForceObjectID = null)
    {
        // validation for constraint: string
        if (!is_null($salesForceObjectID) && !is_string($salesForceObjectID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($salesForceObjectID)), __LINE__);
        }
        $this->SalesForceObjectID = $salesForceObjectID;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \App\Library\ExactTarget\StructType\SendDefinitionList
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Parameters value
     * @return \App\Library\ExactTarget\StructType\Parameters|null
     */
    public function getParameters()
    {
        return $this->Parameters;
    }
    /**
     * Set Parameters value
     * @param \App\Library\ExactTarget\StructType\Parameters $parameters
     * @return \App\Library\ExactTarget\StructType\SendDefinitionList
     */
    public function setParameters(\App\Library\ExactTarget\StructType\Parameters $parameters = null)
    {
        $this->Parameters = $parameters;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\SendDefinitionList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
