<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SendClassification StructType
 * @subpackage Structs
 */
class SendClassification extends APIObject
{
    /**
     * The SendClassificationType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SendClassificationType;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The SenderProfile
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\SenderProfile
     */
    public $SenderProfile;
    /**
     * The DeliveryProfile
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\DeliveryProfile
     */
    public $DeliveryProfile;
    /**
     * The HonorPublicationListOptOutsForTransactionalSends
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $HonorPublicationListOptOutsForTransactionalSends;
    /**
     * The SendPriority
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SendPriority;
    /**
     * The ArchiveEmail
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $ArchiveEmail;
    /**
     * Constructor method for SendClassification
     * @uses SendClassification::setSendClassificationType()
     * @uses SendClassification::setName()
     * @uses SendClassification::setDescription()
     * @uses SendClassification::setSenderProfile()
     * @uses SendClassification::setDeliveryProfile()
     * @uses SendClassification::setHonorPublicationListOptOutsForTransactionalSends()
     * @uses SendClassification::setSendPriority()
     * @uses SendClassification::setArchiveEmail()
     * @param string $sendClassificationType
     * @param string $name
     * @param string $description
     * @param \App\Library\ExactTarget\StructType\SenderProfile $senderProfile
     * @param \App\Library\ExactTarget\StructType\DeliveryProfile $deliveryProfile
     * @param bool $honorPublicationListOptOutsForTransactionalSends
     * @param string $sendPriority
     * @param bool $archiveEmail
     */
    public function __construct($sendClassificationType = null, $name = null, $description = null, \App\Library\ExactTarget\StructType\SenderProfile $senderProfile = null, \App\Library\ExactTarget\StructType\DeliveryProfile $deliveryProfile = null, $honorPublicationListOptOutsForTransactionalSends = null, $sendPriority = null, $archiveEmail = null)
    {
        $this
            ->setSendClassificationType($sendClassificationType)
            ->setName($name)
            ->setDescription($description)
            ->setSenderProfile($senderProfile)
            ->setDeliveryProfile($deliveryProfile)
            ->setHonorPublicationListOptOutsForTransactionalSends($honorPublicationListOptOutsForTransactionalSends)
            ->setSendPriority($sendPriority)
            ->setArchiveEmail($archiveEmail);
    }
    /**
     * Get SendClassificationType value
     * @return string|null
     */
    public function getSendClassificationType()
    {
        return $this->SendClassificationType;
    }
    /**
     * Set SendClassificationType value
     * @uses \App\Library\ExactTarget\EnumType\SendClassificationTypeEnum::valueIsValid()
     * @uses \App\Library\ExactTarget\EnumType\SendClassificationTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sendClassificationType
     * @return \App\Library\ExactTarget\StructType\SendClassification
     */
    public function setSendClassificationType($sendClassificationType = null)
    {
        // validation for constraint: enumeration
        if (!\App\Library\ExactTarget\EnumType\SendClassificationTypeEnum::valueIsValid($sendClassificationType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $sendClassificationType, implode(', ', \App\Library\ExactTarget\EnumType\SendClassificationTypeEnum::getValidValues())), __LINE__);
        }
        $this->SendClassificationType = $sendClassificationType;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \App\Library\ExactTarget\StructType\SendClassification
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \App\Library\ExactTarget\StructType\SendClassification
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get SenderProfile value
     * @return \App\Library\ExactTarget\StructType\SenderProfile|null
     */
    public function getSenderProfile()
    {
        return $this->SenderProfile;
    }
    /**
     * Set SenderProfile value
     * @param \App\Library\ExactTarget\StructType\SenderProfile $senderProfile
     * @return \App\Library\ExactTarget\StructType\SendClassification
     */
    public function setSenderProfile(\App\Library\ExactTarget\StructType\SenderProfile $senderProfile = null)
    {
        $this->SenderProfile = $senderProfile;
        return $this;
    }
    /**
     * Get DeliveryProfile value
     * @return \App\Library\ExactTarget\StructType\DeliveryProfile|null
     */
    public function getDeliveryProfile()
    {
        return $this->DeliveryProfile;
    }
    /**
     * Set DeliveryProfile value
     * @param \App\Library\ExactTarget\StructType\DeliveryProfile $deliveryProfile
     * @return \App\Library\ExactTarget\StructType\SendClassification
     */
    public function setDeliveryProfile(\App\Library\ExactTarget\StructType\DeliveryProfile $deliveryProfile = null)
    {
        $this->DeliveryProfile = $deliveryProfile;
        return $this;
    }
    /**
     * Get HonorPublicationListOptOutsForTransactionalSends value
     * @return bool|null
     */
    public function getHonorPublicationListOptOutsForTransactionalSends()
    {
        return $this->HonorPublicationListOptOutsForTransactionalSends;
    }
    /**
     * Set HonorPublicationListOptOutsForTransactionalSends value
     * @param bool $honorPublicationListOptOutsForTransactionalSends
     * @return \App\Library\ExactTarget\StructType\SendClassification
     */
    public function setHonorPublicationListOptOutsForTransactionalSends($honorPublicationListOptOutsForTransactionalSends = null)
    {
        // validation for constraint: boolean
        if (!is_null($honorPublicationListOptOutsForTransactionalSends) && !is_bool($honorPublicationListOptOutsForTransactionalSends)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($honorPublicationListOptOutsForTransactionalSends)), __LINE__);
        }
        $this->HonorPublicationListOptOutsForTransactionalSends = $honorPublicationListOptOutsForTransactionalSends;
        return $this;
    }
    /**
     * Get SendPriority value
     * @return string|null
     */
    public function getSendPriority()
    {
        return $this->SendPriority;
    }
    /**
     * Set SendPriority value
     * @uses \App\Library\ExactTarget\EnumType\SendPriorityEnum::valueIsValid()
     * @uses \App\Library\ExactTarget\EnumType\SendPriorityEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sendPriority
     * @return \App\Library\ExactTarget\StructType\SendClassification
     */
    public function setSendPriority($sendPriority = null)
    {
        // validation for constraint: enumeration
        if (!\App\Library\ExactTarget\EnumType\SendPriorityEnum::valueIsValid($sendPriority)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $sendPriority, implode(', ', \App\Library\ExactTarget\EnumType\SendPriorityEnum::getValidValues())), __LINE__);
        }
        $this->SendPriority = $sendPriority;
        return $this;
    }
    /**
     * Get ArchiveEmail value
     * @return bool|null
     */
    public function getArchiveEmail()
    {
        return $this->ArchiveEmail;
    }
    /**
     * Set ArchiveEmail value
     * @param bool $archiveEmail
     * @return \App\Library\ExactTarget\StructType\SendClassification
     */
    public function setArchiveEmail($archiveEmail = null)
    {
        // validation for constraint: boolean
        if (!is_null($archiveEmail) && !is_bool($archiveEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($archiveEmail)), __LINE__);
        }
        $this->ArchiveEmail = $archiveEmail;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\SendClassification
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
