<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Send StructType
 * Meta informations extracted from the WSDL
 * - type: tns:Send
 * @subpackage Structs
 */
class Send extends APIObject
{
    /**
     * The Email
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\Email
     */
    public $Email;
    /**
     * The List
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\_List[]
     */
    public $List;
    /**
     * The SendDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SendDate;
    /**
     * The FromAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FromAddress;
    /**
     * The FromName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FromName;
    /**
     * The Duplicates
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Duplicates;
    /**
     * The InvalidAddresses
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $InvalidAddresses;
    /**
     * The ExistingUndeliverables
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $ExistingUndeliverables;
    /**
     * The ExistingUnsubscribes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $ExistingUnsubscribes;
    /**
     * The HardBounces
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $HardBounces;
    /**
     * The SoftBounces
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $SoftBounces;
    /**
     * The OtherBounces
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $OtherBounces;
    /**
     * The ForwardedEmails
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $ForwardedEmails;
    /**
     * The UniqueClicks
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $UniqueClicks;
    /**
     * The UniqueOpens
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $UniqueOpens;
    /**
     * The NumberSent
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumberSent;
    /**
     * The NumberDelivered
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumberDelivered;
    /**
     * The Unsubscribes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Unsubscribes;
    /**
     * The MissingAddresses
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $MissingAddresses;
    /**
     * The Subject
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Subject;
    /**
     * The PreviewURL
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PreviewURL;
    /**
     * The Links
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\Link[]
     */
    public $Links;
    /**
     * The Events
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\TrackingEvent[]
     */
    public $Events;
    /**
     * The SentDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SentDate;
    /**
     * The EmailName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EmailName;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * The IsMultipart
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IsMultipart;
    /**
     * The SendLimit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $SendLimit;
    /**
     * The SendWindowOpen
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SendWindowOpen;
    /**
     * The SendWindowClose
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SendWindowClose;
    /**
     * The IsAlwaysOn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IsAlwaysOn;
    /**
     * The Sources
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\Sources
     */
    public $Sources;
    /**
     * The NumberTargeted
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $NumberTargeted;
    /**
     * The NumberErrored
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $NumberErrored;
    /**
     * The NumberExcluded
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $NumberExcluded;
    /**
     * The Additional
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Additional;
    /**
     * The BccEmail
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BccEmail;
    /**
     * The EmailSendDefinition
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\EmailSendDefinition
     */
    public $EmailSendDefinition;
    /**
     * The SuppressionLists
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\SuppressionLists
     */
    public $SuppressionLists;
    /**
     * Constructor method for Send
     * @uses Send::setEmail()
     * @uses Send::setList()
     * @uses Send::setSendDate()
     * @uses Send::setFromAddress()
     * @uses Send::setFromName()
     * @uses Send::setDuplicates()
     * @uses Send::setInvalidAddresses()
     * @uses Send::setExistingUndeliverables()
     * @uses Send::setExistingUnsubscribes()
     * @uses Send::setHardBounces()
     * @uses Send::setSoftBounces()
     * @uses Send::setOtherBounces()
     * @uses Send::setForwardedEmails()
     * @uses Send::setUniqueClicks()
     * @uses Send::setUniqueOpens()
     * @uses Send::setNumberSent()
     * @uses Send::setNumberDelivered()
     * @uses Send::setUnsubscribes()
     * @uses Send::setMissingAddresses()
     * @uses Send::setSubject()
     * @uses Send::setPreviewURL()
     * @uses Send::setLinks()
     * @uses Send::setEvents()
     * @uses Send::setSentDate()
     * @uses Send::setEmailName()
     * @uses Send::setStatus()
     * @uses Send::setIsMultipart()
     * @uses Send::setSendLimit()
     * @uses Send::setSendWindowOpen()
     * @uses Send::setSendWindowClose()
     * @uses Send::setIsAlwaysOn()
     * @uses Send::setSources()
     * @uses Send::setNumberTargeted()
     * @uses Send::setNumberErrored()
     * @uses Send::setNumberExcluded()
     * @uses Send::setAdditional()
     * @uses Send::setBccEmail()
     * @uses Send::setEmailSendDefinition()
     * @uses Send::setSuppressionLists()
     * @param \App\Library\ExactTarget\StructType\Email $email
     * @param \App\Library\ExactTarget\StructType\_List[] $list
     * @param string $sendDate
     * @param string $fromAddress
     * @param string $fromName
     * @param int $duplicates
     * @param int $invalidAddresses
     * @param int $existingUndeliverables
     * @param int $existingUnsubscribes
     * @param int $hardBounces
     * @param int $softBounces
     * @param int $otherBounces
     * @param int $forwardedEmails
     * @param int $uniqueClicks
     * @param int $uniqueOpens
     * @param int $numberSent
     * @param int $numberDelivered
     * @param int $unsubscribes
     * @param int $missingAddresses
     * @param string $subject
     * @param string $previewURL
     * @param \App\Library\ExactTarget\StructType\Link[] $links
     * @param \App\Library\ExactTarget\StructType\TrackingEvent[] $events
     * @param string $sentDate
     * @param string $emailName
     * @param string $status
     * @param bool $isMultipart
     * @param int $sendLimit
     * @param string $sendWindowOpen
     * @param string $sendWindowClose
     * @param bool $isAlwaysOn
     * @param \App\Library\ExactTarget\StructType\Sources $sources
     * @param int $numberTargeted
     * @param int $numberErrored
     * @param int $numberExcluded
     * @param string $additional
     * @param string $bccEmail
     * @param \App\Library\ExactTarget\StructType\EmailSendDefinition $emailSendDefinition
     * @param \App\Library\ExactTarget\StructType\SuppressionLists $suppressionLists
     */
    public function __construct(\App\Library\ExactTarget\StructType\Email $email = null, array $list = array(), $sendDate = null, $fromAddress = null, $fromName = null, $duplicates = null, $invalidAddresses = null, $existingUndeliverables = null, $existingUnsubscribes = null, $hardBounces = null, $softBounces = null, $otherBounces = null, $forwardedEmails = null, $uniqueClicks = null, $uniqueOpens = null, $numberSent = null, $numberDelivered = null, $unsubscribes = null, $missingAddresses = null, $subject = null, $previewURL = null, array $links = array(), array $events = array(), $sentDate = null, $emailName = null, $status = null, $isMultipart = null, $sendLimit = null, $sendWindowOpen = null, $sendWindowClose = null, $isAlwaysOn = null, \App\Library\ExactTarget\StructType\Sources $sources = null, $numberTargeted = null, $numberErrored = null, $numberExcluded = null, $additional = null, $bccEmail = null, \App\Library\ExactTarget\StructType\EmailSendDefinition $emailSendDefinition = null, \App\Library\ExactTarget\StructType\SuppressionLists $suppressionLists = null)
    {
        $this
            ->setEmail($email)
            ->setList($list)
            ->setSendDate($sendDate)
            ->setFromAddress($fromAddress)
            ->setFromName($fromName)
            ->setDuplicates($duplicates)
            ->setInvalidAddresses($invalidAddresses)
            ->setExistingUndeliverables($existingUndeliverables)
            ->setExistingUnsubscribes($existingUnsubscribes)
            ->setHardBounces($hardBounces)
            ->setSoftBounces($softBounces)
            ->setOtherBounces($otherBounces)
            ->setForwardedEmails($forwardedEmails)
            ->setUniqueClicks($uniqueClicks)
            ->setUniqueOpens($uniqueOpens)
            ->setNumberSent($numberSent)
            ->setNumberDelivered($numberDelivered)
            ->setUnsubscribes($unsubscribes)
            ->setMissingAddresses($missingAddresses)
            ->setSubject($subject)
            ->setPreviewURL($previewURL)
            ->setLinks($links)
            ->setEvents($events)
            ->setSentDate($sentDate)
            ->setEmailName($emailName)
            ->setStatus($status)
            ->setIsMultipart($isMultipart)
            ->setSendLimit($sendLimit)
            ->setSendWindowOpen($sendWindowOpen)
            ->setSendWindowClose($sendWindowClose)
            ->setIsAlwaysOn($isAlwaysOn)
            ->setSources($sources)
            ->setNumberTargeted($numberTargeted)
            ->setNumberErrored($numberErrored)
            ->setNumberExcluded($numberExcluded)
            ->setAdditional($additional)
            ->setBccEmail($bccEmail)
            ->setEmailSendDefinition($emailSendDefinition)
            ->setSuppressionLists($suppressionLists);
    }
    /**
     * Get Email value
     * @return \App\Library\ExactTarget\StructType\Email|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param \App\Library\ExactTarget\StructType\Email $email
     * @return \App\Library\ExactTarget\StructType\Send
     */
    public function setEmail(\App\Library\ExactTarget\StructType\Email $email = null)
    {
        $this->Email = $email;
        return $this;
    }
    /**
     * Get List value
     * @return \App\Library\ExactTarget\StructType\_List[]|null
     */
    public function getList()
    {
        return $this->List;
    }
    /**
     * Set List value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\_List[] $list
     * @return \App\Library\ExactTarget\StructType\Send
     */
    public function setList(array $list = array())
    {
        foreach ($list as $sendListItem) {
            // validation for constraint: itemType
            if (!$sendListItem instanceof \App\Library\ExactTarget\StructType\_List) {
                throw new \InvalidArgumentException(sprintf('The List property can only contain items of \App\Library\ExactTarget\StructType\_List, "%s" given', is_object($sendListItem) ? get_class($sendListItem) : gettype($sendListItem)), __LINE__);
            }
        }
        $this->List = $list;
        return $this;
    }
    /**
     * Add item to List value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\_List $item
     * @return \App\Library\ExactTarget\StructType\Send
     */
    public function addToList(\App\Library\ExactTarget\StructType\_List $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Library\ExactTarget\StructType\_List) {
            throw new \InvalidArgumentException(sprintf('The List property can only contain items of \App\Library\ExactTarget\StructType\_List, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->List[] = $item;
        return $this;
    }
    /**
     * Get SendDate value
     * @return string|null
     */
    public function getSendDate()
    {
        return $this->SendDate;
    }
    /**
     * Set SendDate value
     * @param string $sendDate
     * @return \App\Library\ExactTarget\StructType\Send
     */
    public function setSendDate($sendDate = null)
    {
        // validation for constraint: string
        if (!is_null($sendDate) && !is_string($sendDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sendDate)), __LINE__);
        }
        $this->SendDate = $sendDate;
        return $this;
    }
    /**
     * Get FromAddress value
     * @return string|null
     */
    public function getFromAddress()
    {
        return $this->FromAddress;
    }
    /**
     * Set FromAddress value
     * @param string $fromAddress
     * @return \App\Library\ExactTarget\StructType\Send
     */
    public function setFromAddress($fromAddress = null)
    {
        // validation for constraint: string
        if (!is_null($fromAddress) && !is_string($fromAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fromAddress)), __LINE__);
        }
        $this->FromAddress = $fromAddress;
        return $this;
    }
    /**
     * Get FromName value
     * @return string|null
     */
    public function getFromName()
    {
        return $this->FromName;
    }
    /**
     * Set FromName value
     * @param string $fromName
     * @return \App\Library\ExactTarget\StructType\Send
     */
    public function setFromName($fromName = null)
    {
        // validation for constraint: string
        if (!is_null($fromName) && !is_string($fromName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fromName)), __LINE__);
        }
        $this->FromName = $fromName;
        return $this;
    }
    /**
     * Get Duplicates value
     * @return int|null
     */
    public function getDuplicates()
    {
        return $this->Duplicates;
    }
    /**
     * Set Duplicates value
     * @param int $duplicates
     * @return \App\Library\ExactTarget\StructType\Send
     */
    public function setDuplicates($duplicates = null)
    {
        // validation for constraint: int
        if (!is_null($duplicates) && !is_numeric($duplicates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($duplicates)), __LINE__);
        }
        $this->Duplicates = $duplicates;
        return $this;
    }
    /**
     * Get InvalidAddresses value
     * @return int|null
     */
    public function getInvalidAddresses()
    {
        return $this->InvalidAddresses;
    }
    /**
     * Set InvalidAddresses value
     * @param int $invalidAddresses
     * @return \App\Library\ExactTarget\StructType\Send
     */
    public function setInvalidAddresses($invalidAddresses = null)
    {
        // validation for constraint: int
        if (!is_null($invalidAddresses) && !is_numeric($invalidAddresses)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($invalidAddresses)), __LINE__);
        }
        $this->InvalidAddresses = $invalidAddresses;
        return $this;
    }
    /**
     * Get ExistingUndeliverables value
     * @return int|null
     */
    public function getExistingUndeliverables()
    {
        return $this->ExistingUndeliverables;
    }
    /**
     * Set ExistingUndeliverables value
     * @param int $existingUndeliverables
     * @return \App\Library\ExactTarget\StructType\Send
     */
    public function setExistingUndeliverables($existingUndeliverables = null)
    {
        // validation for constraint: int
        if (!is_null($existingUndeliverables) && !is_numeric($existingUndeliverables)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($existingUndeliverables)), __LINE__);
        }
        $this->ExistingUndeliverables = $existingUndeliverables;
        return $this;
    }
    /**
     * Get ExistingUnsubscribes value
     * @return int|null
     */
    public function getExistingUnsubscribes()
    {
        return $this->ExistingUnsubscribes;
    }
    /**
     * Set ExistingUnsubscribes value
     * @param int $existingUnsubscribes
     * @return \App\Library\ExactTarget\StructType\Send
     */
    public function setExistingUnsubscribes($existingUnsubscribes = null)
    {
        // validation for constraint: int
        if (!is_null($existingUnsubscribes) && !is_numeric($existingUnsubscribes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($existingUnsubscribes)), __LINE__);
        }
        $this->ExistingUnsubscribes = $existingUnsubscribes;
        return $this;
    }
    /**
     * Get HardBounces value
     * @return int|null
     */
    public function getHardBounces()
    {
        return $this->HardBounces;
    }
    /**
     * Set HardBounces value
     * @param int $hardBounces
     * @return \App\Library\ExactTarget\StructType\Send
     */
    public function setHardBounces($hardBounces = null)
    {
        // validation for constraint: int
        if (!is_null($hardBounces) && !is_numeric($hardBounces)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($hardBounces)), __LINE__);
        }
        $this->HardBounces = $hardBounces;
        return $this;
    }
    /**
     * Get SoftBounces value
     * @return int|null
     */
    public function getSoftBounces()
    {
        return $this->SoftBounces;
    }
    /**
     * Set SoftBounces value
     * @param int $softBounces
     * @return \App\Library\ExactTarget\StructType\Send
     */
    public function setSoftBounces($softBounces = null)
    {
        // validation for constraint: int
        if (!is_null($softBounces) && !is_numeric($softBounces)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($softBounces)), __LINE__);
        }
        $this->SoftBounces = $softBounces;
        return $this;
    }
    /**
     * Get OtherBounces value
     * @return int|null
     */
    public function getOtherBounces()
    {
        return $this->OtherBounces;
    }
    /**
     * Set OtherBounces value
     * @param int $otherBounces
     * @return \App\Library\ExactTarget\StructType\Send
     */
    public function setOtherBounces($otherBounces = null)
    {
        // validation for constraint: int
        if (!is_null($otherBounces) && !is_numeric($otherBounces)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($otherBounces)), __LINE__);
        }
        $this->OtherBounces = $otherBounces;
        return $this;
    }
    /**
     * Get ForwardedEmails value
     * @return int|null
     */
    public function getForwardedEmails()
    {
        return $this->ForwardedEmails;
    }
    /**
     * Set ForwardedEmails value
     * @param int $forwardedEmails
     * @return \App\Library\ExactTarget\StructType\Send
     */
    public function setForwardedEmails($forwardedEmails = null)
    {
        // validation for constraint: int
        if (!is_null($forwardedEmails) && !is_numeric($forwardedEmails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($forwardedEmails)), __LINE__);
        }
        $this->ForwardedEmails = $forwardedEmails;
        return $this;
    }
    /**
     * Get UniqueClicks value
     * @return int|null
     */
    public function getUniqueClicks()
    {
        return $this->UniqueClicks;
    }
    /**
     * Set UniqueClicks value
     * @param int $uniqueClicks
     * @return \App\Library\ExactTarget\StructType\Send
     */
    public function setUniqueClicks($uniqueClicks = null)
    {
        // validation for constraint: int
        if (!is_null($uniqueClicks) && !is_numeric($uniqueClicks)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($uniqueClicks)), __LINE__);
        }
        $this->UniqueClicks = $uniqueClicks;
        return $this;
    }
    /**
     * Get UniqueOpens value
     * @return int|null
     */
    public function getUniqueOpens()
    {
        return $this->UniqueOpens;
    }
    /**
     * Set UniqueOpens value
     * @param int $uniqueOpens
     * @return \App\Library\ExactTarget\StructType\Send
     */
    public function setUniqueOpens($uniqueOpens = null)
    {
        // validation for constraint: int
        if (!is_null($uniqueOpens) && !is_numeric($uniqueOpens)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($uniqueOpens)), __LINE__);
        }
        $this->UniqueOpens = $uniqueOpens;
        return $this;
    }
    /**
     * Get NumberSent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumberSent()
    {
        return isset($this->NumberSent) ? $this->NumberSent : null;
    }
    /**
     * Set NumberSent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numberSent
     * @return \App\Library\ExactTarget\StructType\Send
     */
    public function setNumberSent($numberSent = null)
    {
        // validation for constraint: int
        if (!is_null($numberSent) && !is_numeric($numberSent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numberSent)), __LINE__);
        }
        if (is_null($numberSent) || (is_array($numberSent) && empty($numberSent))) {
            unset($this->NumberSent);
        } else {
            $this->NumberSent = $numberSent;
        }
        return $this;
    }
    /**
     * Get NumberDelivered value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumberDelivered()
    {
        return isset($this->NumberDelivered) ? $this->NumberDelivered : null;
    }
    /**
     * Set NumberDelivered value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numberDelivered
     * @return \App\Library\ExactTarget\StructType\Send
     */
    public function setNumberDelivered($numberDelivered = null)
    {
        // validation for constraint: int
        if (!is_null($numberDelivered) && !is_numeric($numberDelivered)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numberDelivered)), __LINE__);
        }
        if (is_null($numberDelivered) || (is_array($numberDelivered) && empty($numberDelivered))) {
            unset($this->NumberDelivered);
        } else {
            $this->NumberDelivered = $numberDelivered;
        }
        return $this;
    }
    /**
     * Get Unsubscribes value
     * @return int|null
     */
    public function getUnsubscribes()
    {
        return $this->Unsubscribes;
    }
    /**
     * Set Unsubscribes value
     * @param int $unsubscribes
     * @return \App\Library\ExactTarget\StructType\Send
     */
    public function setUnsubscribes($unsubscribes = null)
    {
        // validation for constraint: int
        if (!is_null($unsubscribes) && !is_numeric($unsubscribes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($unsubscribes)), __LINE__);
        }
        $this->Unsubscribes = $unsubscribes;
        return $this;
    }
    /**
     * Get MissingAddresses value
     * @return int|null
     */
    public function getMissingAddresses()
    {
        return $this->MissingAddresses;
    }
    /**
     * Set MissingAddresses value
     * @param int $missingAddresses
     * @return \App\Library\ExactTarget\StructType\Send
     */
    public function setMissingAddresses($missingAddresses = null)
    {
        // validation for constraint: int
        if (!is_null($missingAddresses) && !is_numeric($missingAddresses)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($missingAddresses)), __LINE__);
        }
        $this->MissingAddresses = $missingAddresses;
        return $this;
    }
    /**
     * Get Subject value
     * @return string|null
     */
    public function getSubject()
    {
        return $this->Subject;
    }
    /**
     * Set Subject value
     * @param string $subject
     * @return \App\Library\ExactTarget\StructType\Send
     */
    public function setSubject($subject = null)
    {
        // validation for constraint: string
        if (!is_null($subject) && !is_string($subject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subject)), __LINE__);
        }
        $this->Subject = $subject;
        return $this;
    }
    /**
     * Get PreviewURL value
     * @return string|null
     */
    public function getPreviewURL()
    {
        return $this->PreviewURL;
    }
    /**
     * Set PreviewURL value
     * @param string $previewURL
     * @return \App\Library\ExactTarget\StructType\Send
     */
    public function setPreviewURL($previewURL = null)
    {
        // validation for constraint: string
        if (!is_null($previewURL) && !is_string($previewURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($previewURL)), __LINE__);
        }
        $this->PreviewURL = $previewURL;
        return $this;
    }
    /**
     * Get Links value
     * @return \App\Library\ExactTarget\StructType\Link[]|null
     */
    public function getLinks()
    {
        return $this->Links;
    }
    /**
     * Set Links value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\Link[] $links
     * @return \App\Library\ExactTarget\StructType\Send
     */
    public function setLinks(array $links = array())
    {
        foreach ($links as $sendLinksItem) {
            // validation for constraint: itemType
            if (!$sendLinksItem instanceof \App\Library\ExactTarget\StructType\Link) {
                throw new \InvalidArgumentException(sprintf('The Links property can only contain items of \App\Library\ExactTarget\StructType\Link, "%s" given', is_object($sendLinksItem) ? get_class($sendLinksItem) : gettype($sendLinksItem)), __LINE__);
            }
        }
        $this->Links = $links;
        return $this;
    }
    /**
     * Add item to Links value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\Link $item
     * @return \App\Library\ExactTarget\StructType\Send
     */
    public function addToLinks(\App\Library\ExactTarget\StructType\Link $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Library\ExactTarget\StructType\Link) {
            throw new \InvalidArgumentException(sprintf('The Links property can only contain items of \App\Library\ExactTarget\StructType\Link, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Links[] = $item;
        return $this;
    }
    /**
     * Get Events value
     * @return \App\Library\ExactTarget\StructType\TrackingEvent[]|null
     */
    public function getEvents()
    {
        return $this->Events;
    }
    /**
     * Set Events value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\TrackingEvent[] $events
     * @return \App\Library\ExactTarget\StructType\Send
     */
    public function setEvents(array $events = array())
    {
        foreach ($events as $sendEventsItem) {
            // validation for constraint: itemType
            if (!$sendEventsItem instanceof \App\Library\ExactTarget\StructType\TrackingEvent) {
                throw new \InvalidArgumentException(sprintf('The Events property can only contain items of \App\Library\ExactTarget\StructType\TrackingEvent, "%s" given', is_object($sendEventsItem) ? get_class($sendEventsItem) : gettype($sendEventsItem)), __LINE__);
            }
        }
        $this->Events = $events;
        return $this;
    }
    /**
     * Add item to Events value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\TrackingEvent $item
     * @return \App\Library\ExactTarget\StructType\Send
     */
    public function addToEvents(\App\Library\ExactTarget\StructType\TrackingEvent $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Library\ExactTarget\StructType\TrackingEvent) {
            throw new \InvalidArgumentException(sprintf('The Events property can only contain items of \App\Library\ExactTarget\StructType\TrackingEvent, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Events[] = $item;
        return $this;
    }
    /**
     * Get SentDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSentDate()
    {
        return isset($this->SentDate) ? $this->SentDate : null;
    }
    /**
     * Set SentDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sentDate
     * @return \App\Library\ExactTarget\StructType\Send
     */
    public function setSentDate($sentDate = null)
    {
        // validation for constraint: string
        if (!is_null($sentDate) && !is_string($sentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sentDate)), __LINE__);
        }
        if (is_null($sentDate) || (is_array($sentDate) && empty($sentDate))) {
            unset($this->SentDate);
        } else {
            $this->SentDate = $sentDate;
        }
        return $this;
    }
    /**
     * Get EmailName value
     * @return string|null
     */
    public function getEmailName()
    {
        return $this->EmailName;
    }
    /**
     * Set EmailName value
     * @param string $emailName
     * @return \App\Library\ExactTarget\StructType\Send
     */
    public function setEmailName($emailName = null)
    {
        // validation for constraint: string
        if (!is_null($emailName) && !is_string($emailName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($emailName)), __LINE__);
        }
        $this->EmailName = $emailName;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \App\Library\ExactTarget\StructType\Send
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get IsMultipart value
     * @return bool|null
     */
    public function getIsMultipart()
    {
        return $this->IsMultipart;
    }
    /**
     * Set IsMultipart value
     * @param bool $isMultipart
     * @return \App\Library\ExactTarget\StructType\Send
     */
    public function setIsMultipart($isMultipart = null)
    {
        // validation for constraint: boolean
        if (!is_null($isMultipart) && !is_bool($isMultipart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isMultipart)), __LINE__);
        }
        $this->IsMultipart = $isMultipart;
        return $this;
    }
    /**
     * Get SendLimit value
     * @return int|null
     */
    public function getSendLimit()
    {
        return $this->SendLimit;
    }
    /**
     * Set SendLimit value
     * @param int $sendLimit
     * @return \App\Library\ExactTarget\StructType\Send
     */
    public function setSendLimit($sendLimit = null)
    {
        // validation for constraint: int
        if (!is_null($sendLimit) && !is_numeric($sendLimit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sendLimit)), __LINE__);
        }
        $this->SendLimit = $sendLimit;
        return $this;
    }
    /**
     * Get SendWindowOpen value
     * @return string|null
     */
    public function getSendWindowOpen()
    {
        return $this->SendWindowOpen;
    }
    /**
     * Set SendWindowOpen value
     * @param string $sendWindowOpen
     * @return \App\Library\ExactTarget\StructType\Send
     */
    public function setSendWindowOpen($sendWindowOpen = null)
    {
        // validation for constraint: string
        if (!is_null($sendWindowOpen) && !is_string($sendWindowOpen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sendWindowOpen)), __LINE__);
        }
        $this->SendWindowOpen = $sendWindowOpen;
        return $this;
    }
    /**
     * Get SendWindowClose value
     * @return string|null
     */
    public function getSendWindowClose()
    {
        return $this->SendWindowClose;
    }
    /**
     * Set SendWindowClose value
     * @param string $sendWindowClose
     * @return \App\Library\ExactTarget\StructType\Send
     */
    public function setSendWindowClose($sendWindowClose = null)
    {
        // validation for constraint: string
        if (!is_null($sendWindowClose) && !is_string($sendWindowClose)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sendWindowClose)), __LINE__);
        }
        $this->SendWindowClose = $sendWindowClose;
        return $this;
    }
    /**
     * Get IsAlwaysOn value
     * @return bool|null
     */
    public function getIsAlwaysOn()
    {
        return $this->IsAlwaysOn;
    }
    /**
     * Set IsAlwaysOn value
     * @param bool $isAlwaysOn
     * @return \App\Library\ExactTarget\StructType\Send
     */
    public function setIsAlwaysOn($isAlwaysOn = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAlwaysOn) && !is_bool($isAlwaysOn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isAlwaysOn)), __LINE__);
        }
        $this->IsAlwaysOn = $isAlwaysOn;
        return $this;
    }
    /**
     * Get Sources value
     * @return \App\Library\ExactTarget\StructType\Sources|null
     */
    public function getSources()
    {
        return $this->Sources;
    }
    /**
     * Set Sources value
     * @param \App\Library\ExactTarget\StructType\Sources $sources
     * @return \App\Library\ExactTarget\StructType\Send
     */
    public function setSources(\App\Library\ExactTarget\StructType\Sources $sources = null)
    {
        $this->Sources = $sources;
        return $this;
    }
    /**
     * Get NumberTargeted value
     * @return int|null
     */
    public function getNumberTargeted()
    {
        return $this->NumberTargeted;
    }
    /**
     * Set NumberTargeted value
     * @param int $numberTargeted
     * @return \App\Library\ExactTarget\StructType\Send
     */
    public function setNumberTargeted($numberTargeted = null)
    {
        // validation for constraint: int
        if (!is_null($numberTargeted) && !is_numeric($numberTargeted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numberTargeted)), __LINE__);
        }
        $this->NumberTargeted = $numberTargeted;
        return $this;
    }
    /**
     * Get NumberErrored value
     * @return int|null
     */
    public function getNumberErrored()
    {
        return $this->NumberErrored;
    }
    /**
     * Set NumberErrored value
     * @param int $numberErrored
     * @return \App\Library\ExactTarget\StructType\Send
     */
    public function setNumberErrored($numberErrored = null)
    {
        // validation for constraint: int
        if (!is_null($numberErrored) && !is_numeric($numberErrored)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numberErrored)), __LINE__);
        }
        $this->NumberErrored = $numberErrored;
        return $this;
    }
    /**
     * Get NumberExcluded value
     * @return int|null
     */
    public function getNumberExcluded()
    {
        return $this->NumberExcluded;
    }
    /**
     * Set NumberExcluded value
     * @param int $numberExcluded
     * @return \App\Library\ExactTarget\StructType\Send
     */
    public function setNumberExcluded($numberExcluded = null)
    {
        // validation for constraint: int
        if (!is_null($numberExcluded) && !is_numeric($numberExcluded)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numberExcluded)), __LINE__);
        }
        $this->NumberExcluded = $numberExcluded;
        return $this;
    }
    /**
     * Get Additional value
     * @return string|null
     */
    public function getAdditional()
    {
        return $this->Additional;
    }
    /**
     * Set Additional value
     * @param string $additional
     * @return \App\Library\ExactTarget\StructType\Send
     */
    public function setAdditional($additional = null)
    {
        // validation for constraint: string
        if (!is_null($additional) && !is_string($additional)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($additional)), __LINE__);
        }
        $this->Additional = $additional;
        return $this;
    }
    /**
     * Get BccEmail value
     * @return string|null
     */
    public function getBccEmail()
    {
        return $this->BccEmail;
    }
    /**
     * Set BccEmail value
     * @param string $bccEmail
     * @return \App\Library\ExactTarget\StructType\Send
     */
    public function setBccEmail($bccEmail = null)
    {
        // validation for constraint: string
        if (!is_null($bccEmail) && !is_string($bccEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bccEmail)), __LINE__);
        }
        $this->BccEmail = $bccEmail;
        return $this;
    }
    /**
     * Get EmailSendDefinition value
     * @return \App\Library\ExactTarget\StructType\EmailSendDefinition|null
     */
    public function getEmailSendDefinition()
    {
        return $this->EmailSendDefinition;
    }
    /**
     * Set EmailSendDefinition value
     * @param \App\Library\ExactTarget\StructType\EmailSendDefinition $emailSendDefinition
     * @return \App\Library\ExactTarget\StructType\Send
     */
    public function setEmailSendDefinition(\App\Library\ExactTarget\StructType\EmailSendDefinition $emailSendDefinition = null)
    {
        $this->EmailSendDefinition = $emailSendDefinition;
        return $this;
    }
    /**
     * Get SuppressionLists value
     * @return \App\Library\ExactTarget\StructType\SuppressionLists|null
     */
    public function getSuppressionLists()
    {
        return $this->SuppressionLists;
    }
    /**
     * Set SuppressionLists value
     * @param \App\Library\ExactTarget\StructType\SuppressionLists $suppressionLists
     * @return \App\Library\ExactTarget\StructType\Send
     */
    public function setSuppressionLists(\App\Library\ExactTarget\StructType\SuppressionLists $suppressionLists = null)
    {
        $this->SuppressionLists = $suppressionLists;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\Send
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
