<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ScheduleResponseMsg StructType
 * @subpackage Structs
 */
class ScheduleResponseMsg extends AbstractStructBase
{
    /**
     * The OverallStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OverallStatus;
    /**
     * The OverallStatusMessage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OverallStatusMessage;
    /**
     * The Results
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\Results
     */
    public $Results;
    /**
     * The RequestID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RequestID;
    /**
     * Constructor method for ScheduleResponseMsg
     * @uses ScheduleResponseMsg::setOverallStatus()
     * @uses ScheduleResponseMsg::setOverallStatusMessage()
     * @uses ScheduleResponseMsg::setResults()
     * @uses ScheduleResponseMsg::setRequestID()
     * @param string $overallStatus
     * @param string $overallStatusMessage
     * @param \App\Library\ExactTarget\StructType\Results $results
     * @param string $requestID
     */
    public function __construct($overallStatus = null, $overallStatusMessage = null, \App\Library\ExactTarget\StructType\Results $results = null, $requestID = null)
    {
        $this
            ->setOverallStatus($overallStatus)
            ->setOverallStatusMessage($overallStatusMessage)
            ->setResults($results)
            ->setRequestID($requestID);
    }
    /**
     * Get OverallStatus value
     * @return string
     */
    public function getOverallStatus()
    {
        return $this->OverallStatus;
    }
    /**
     * Set OverallStatus value
     * @param string $overallStatus
     * @return \App\Library\ExactTarget\StructType\ScheduleResponseMsg
     */
    public function setOverallStatus($overallStatus = null)
    {
        // validation for constraint: string
        if (!is_null($overallStatus) && !is_string($overallStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($overallStatus)), __LINE__);
        }
        $this->OverallStatus = $overallStatus;
        return $this;
    }
    /**
     * Get OverallStatusMessage value
     * @return string
     */
    public function getOverallStatusMessage()
    {
        return $this->OverallStatusMessage;
    }
    /**
     * Set OverallStatusMessage value
     * @param string $overallStatusMessage
     * @return \App\Library\ExactTarget\StructType\ScheduleResponseMsg
     */
    public function setOverallStatusMessage($overallStatusMessage = null)
    {
        // validation for constraint: string
        if (!is_null($overallStatusMessage) && !is_string($overallStatusMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($overallStatusMessage)), __LINE__);
        }
        $this->OverallStatusMessage = $overallStatusMessage;
        return $this;
    }
    /**
     * Get Results value
     * @return \App\Library\ExactTarget\StructType\Results|null
     */
    public function getResults()
    {
        return $this->Results;
    }
    /**
     * Set Results value
     * @param \App\Library\ExactTarget\StructType\Results $results
     * @return \App\Library\ExactTarget\StructType\ScheduleResponseMsg
     */
    public function setResults(\App\Library\ExactTarget\StructType\Results $results = null)
    {
        $this->Results = $results;
        return $this;
    }
    /**
     * Get RequestID value
     * @return string|null
     */
    public function getRequestID()
    {
        return $this->RequestID;
    }
    /**
     * Set RequestID value
     * @param string $requestID
     * @return \App\Library\ExactTarget\StructType\ScheduleResponseMsg
     */
    public function setRequestID($requestID = null)
    {
        // validation for constraint: string
        if (!is_null($requestID) && !is_string($requestID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestID)), __LINE__);
        }
        $this->RequestID = $requestID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\ScheduleResponseMsg
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
