<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SaveOption StructType
 * @subpackage Structs
 */
class SaveOption extends AbstractStructBase
{
    /**
     * The PropertyName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PropertyName;
    /**
     * The SaveAction
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SaveAction;
    /**
     * Constructor method for SaveOption
     * @uses SaveOption::setPropertyName()
     * @uses SaveOption::setSaveAction()
     * @param string $propertyName
     * @param string $saveAction
     */
    public function __construct($propertyName = null, $saveAction = null)
    {
        $this
            ->setPropertyName($propertyName)
            ->setSaveAction($saveAction);
    }
    /**
     * Get PropertyName value
     * @return string
     */
    public function getPropertyName()
    {
        return $this->PropertyName;
    }
    /**
     * Set PropertyName value
     * @param string $propertyName
     * @return \App\Library\ExactTarget\StructType\SaveOption
     */
    public function setPropertyName($propertyName = null)
    {
        // validation for constraint: string
        if (!is_null($propertyName) && !is_string($propertyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($propertyName)), __LINE__);
        }
        $this->PropertyName = $propertyName;
        return $this;
    }
    /**
     * Get SaveAction value
     * @return string
     */
    public function getSaveAction()
    {
        return $this->SaveAction;
    }
    /**
     * Set SaveAction value
     * @uses \App\Library\ExactTarget\EnumType\SaveAction::valueIsValid()
     * @uses \App\Library\ExactTarget\EnumType\SaveAction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $saveAction
     * @return \App\Library\ExactTarget\StructType\SaveOption
     */
    public function setSaveAction($saveAction = null)
    {
        // validation for constraint: enumeration
        if (!\App\Library\ExactTarget\EnumType\SaveAction::valueIsValid($saveAction)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $saveAction, implode(', ', \App\Library\ExactTarget\EnumType\SaveAction::getValidValues())), __LINE__);
        }
        $this->SaveAction = $saveAction;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\SaveOption
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
