<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SMSTriggeredSend StructType
 * @subpackage Structs
 */
class SMSTriggeredSend extends APIObject
{
    /**
     * The SMSTriggeredSendDefinition
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\SMSTriggeredSendDefinition
     */
    public $SMSTriggeredSendDefinition;
    /**
     * The Subscriber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\Subscriber
     */
    public $Subscriber;
    /**
     * The Message
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Message;
    /**
     * The Number
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Number;
    /**
     * The FromAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FromAddress;
    /**
     * The SmsSendId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SmsSendId;
    /**
     * Constructor method for SMSTriggeredSend
     * @uses SMSTriggeredSend::setSMSTriggeredSendDefinition()
     * @uses SMSTriggeredSend::setSubscriber()
     * @uses SMSTriggeredSend::setMessage()
     * @uses SMSTriggeredSend::setNumber()
     * @uses SMSTriggeredSend::setFromAddress()
     * @uses SMSTriggeredSend::setSmsSendId()
     * @param \App\Library\ExactTarget\StructType\SMSTriggeredSendDefinition $sMSTriggeredSendDefinition
     * @param \App\Library\ExactTarget\StructType\Subscriber $subscriber
     * @param string $message
     * @param string $number
     * @param string $fromAddress
     * @param string $smsSendId
     */
    public function __construct(\App\Library\ExactTarget\StructType\SMSTriggeredSendDefinition $sMSTriggeredSendDefinition = null, \App\Library\ExactTarget\StructType\Subscriber $subscriber = null, $message = null, $number = null, $fromAddress = null, $smsSendId = null)
    {
        $this
            ->setSMSTriggeredSendDefinition($sMSTriggeredSendDefinition)
            ->setSubscriber($subscriber)
            ->setMessage($message)
            ->setNumber($number)
            ->setFromAddress($fromAddress)
            ->setSmsSendId($smsSendId);
    }
    /**
     * Get SMSTriggeredSendDefinition value
     * @return \App\Library\ExactTarget\StructType\SMSTriggeredSendDefinition|null
     */
    public function getSMSTriggeredSendDefinition()
    {
        return $this->SMSTriggeredSendDefinition;
    }
    /**
     * Set SMSTriggeredSendDefinition value
     * @param \App\Library\ExactTarget\StructType\SMSTriggeredSendDefinition $sMSTriggeredSendDefinition
     * @return \App\Library\ExactTarget\StructType\SMSTriggeredSend
     */
    public function setSMSTriggeredSendDefinition(\App\Library\ExactTarget\StructType\SMSTriggeredSendDefinition $sMSTriggeredSendDefinition = null)
    {
        $this->SMSTriggeredSendDefinition = $sMSTriggeredSendDefinition;
        return $this;
    }
    /**
     * Get Subscriber value
     * @return \App\Library\ExactTarget\StructType\Subscriber|null
     */
    public function getSubscriber()
    {
        return $this->Subscriber;
    }
    /**
     * Set Subscriber value
     * @param \App\Library\ExactTarget\StructType\Subscriber $subscriber
     * @return \App\Library\ExactTarget\StructType\SMSTriggeredSend
     */
    public function setSubscriber(\App\Library\ExactTarget\StructType\Subscriber $subscriber = null)
    {
        $this->Subscriber = $subscriber;
        return $this;
    }
    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \App\Library\ExactTarget\StructType\SMSTriggeredSend
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($message)), __LINE__);
        }
        $this->Message = $message;
        return $this;
    }
    /**
     * Get Number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param string $number
     * @return \App\Library\ExactTarget\StructType\SMSTriggeredSend
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($number)), __LINE__);
        }
        $this->Number = $number;
        return $this;
    }
    /**
     * Get FromAddress value
     * @return string|null
     */
    public function getFromAddress()
    {
        return $this->FromAddress;
    }
    /**
     * Set FromAddress value
     * @param string $fromAddress
     * @return \App\Library\ExactTarget\StructType\SMSTriggeredSend
     */
    public function setFromAddress($fromAddress = null)
    {
        // validation for constraint: string
        if (!is_null($fromAddress) && !is_string($fromAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fromAddress)), __LINE__);
        }
        $this->FromAddress = $fromAddress;
        return $this;
    }
    /**
     * Get SmsSendId value
     * @return string|null
     */
    public function getSmsSendId()
    {
        return $this->SmsSendId;
    }
    /**
     * Set SmsSendId value
     * @param string $smsSendId
     * @return \App\Library\ExactTarget\StructType\SMSTriggeredSend
     */
    public function setSmsSendId($smsSendId = null)
    {
        // validation for constraint: string
        if (!is_null($smsSendId) && !is_string($smsSendId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($smsSendId)), __LINE__);
        }
        $this->SmsSendId = $smsSendId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\SMSTriggeredSend
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
