<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SMSSharedKeyword StructType
 * @subpackage Structs
 */
class SMSSharedKeyword extends APIObject
{
    /**
     * The ShortCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ShortCode;
    /**
     * The SharedKeyword
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SharedKeyword;
    /**
     * The RequestDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RequestDate;
    /**
     * The EffectiveDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EffectiveDate;
    /**
     * The ExpireDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExpireDate;
    /**
     * The ReturnToPoolDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReturnToPoolDate;
    /**
     * The CountryCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CountryCode;
    /**
     * Constructor method for SMSSharedKeyword
     * @uses SMSSharedKeyword::setShortCode()
     * @uses SMSSharedKeyword::setSharedKeyword()
     * @uses SMSSharedKeyword::setRequestDate()
     * @uses SMSSharedKeyword::setEffectiveDate()
     * @uses SMSSharedKeyword::setExpireDate()
     * @uses SMSSharedKeyword::setReturnToPoolDate()
     * @uses SMSSharedKeyword::setCountryCode()
     * @param string $shortCode
     * @param string $sharedKeyword
     * @param string $requestDate
     * @param string $effectiveDate
     * @param string $expireDate
     * @param string $returnToPoolDate
     * @param string $countryCode
     */
    public function __construct($shortCode = null, $sharedKeyword = null, $requestDate = null, $effectiveDate = null, $expireDate = null, $returnToPoolDate = null, $countryCode = null)
    {
        $this
            ->setShortCode($shortCode)
            ->setSharedKeyword($sharedKeyword)
            ->setRequestDate($requestDate)
            ->setEffectiveDate($effectiveDate)
            ->setExpireDate($expireDate)
            ->setReturnToPoolDate($returnToPoolDate)
            ->setCountryCode($countryCode);
    }
    /**
     * Get ShortCode value
     * @return string
     */
    public function getShortCode()
    {
        return $this->ShortCode;
    }
    /**
     * Set ShortCode value
     * @param string $shortCode
     * @return \App\Library\ExactTarget\StructType\SMSSharedKeyword
     */
    public function setShortCode($shortCode = null)
    {
        // validation for constraint: string
        if (!is_null($shortCode) && !is_string($shortCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shortCode)), __LINE__);
        }
        $this->ShortCode = $shortCode;
        return $this;
    }
    /**
     * Get SharedKeyword value
     * @return string
     */
    public function getSharedKeyword()
    {
        return $this->SharedKeyword;
    }
    /**
     * Set SharedKeyword value
     * @param string $sharedKeyword
     * @return \App\Library\ExactTarget\StructType\SMSSharedKeyword
     */
    public function setSharedKeyword($sharedKeyword = null)
    {
        // validation for constraint: string
        if (!is_null($sharedKeyword) && !is_string($sharedKeyword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sharedKeyword)), __LINE__);
        }
        $this->SharedKeyword = $sharedKeyword;
        return $this;
    }
    /**
     * Get RequestDate value
     * @return string|null
     */
    public function getRequestDate()
    {
        return $this->RequestDate;
    }
    /**
     * Set RequestDate value
     * @param string $requestDate
     * @return \App\Library\ExactTarget\StructType\SMSSharedKeyword
     */
    public function setRequestDate($requestDate = null)
    {
        // validation for constraint: string
        if (!is_null($requestDate) && !is_string($requestDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestDate)), __LINE__);
        }
        $this->RequestDate = $requestDate;
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \App\Library\ExactTarget\StructType\SMSSharedKeyword
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($effectiveDate)), __LINE__);
        }
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get ExpireDate value
     * @return string|null
     */
    public function getExpireDate()
    {
        return $this->ExpireDate;
    }
    /**
     * Set ExpireDate value
     * @param string $expireDate
     * @return \App\Library\ExactTarget\StructType\SMSSharedKeyword
     */
    public function setExpireDate($expireDate = null)
    {
        // validation for constraint: string
        if (!is_null($expireDate) && !is_string($expireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expireDate)), __LINE__);
        }
        $this->ExpireDate = $expireDate;
        return $this;
    }
    /**
     * Get ReturnToPoolDate value
     * @return string|null
     */
    public function getReturnToPoolDate()
    {
        return $this->ReturnToPoolDate;
    }
    /**
     * Set ReturnToPoolDate value
     * @param string $returnToPoolDate
     * @return \App\Library\ExactTarget\StructType\SMSSharedKeyword
     */
    public function setReturnToPoolDate($returnToPoolDate = null)
    {
        // validation for constraint: string
        if (!is_null($returnToPoolDate) && !is_string($returnToPoolDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($returnToPoolDate)), __LINE__);
        }
        $this->ReturnToPoolDate = $returnToPoolDate;
        return $this;
    }
    /**
     * Get CountryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->CountryCode;
    }
    /**
     * Set CountryCode value
     * @param string $countryCode
     * @return \App\Library\ExactTarget\StructType\SMSSharedKeyword
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($countryCode)), __LINE__);
        }
        $this->CountryCode = $countryCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\SMSSharedKeyword
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
