<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SMSMTEvent StructType
 * @subpackage Structs
 */
class SMSMTEvent extends APIObject
{
    /**
     * The SMSTriggeredSend
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\SMSTriggeredSend
     */
    public $SMSTriggeredSend;
    /**
     * The Subscriber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\Subscriber
     */
    public $Subscriber;
    /**
     * The MOCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MOCode;
    /**
     * The EventDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EventDate;
    /**
     * The Carrier
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Carrier;
    /**
     * Constructor method for SMSMTEvent
     * @uses SMSMTEvent::setSMSTriggeredSend()
     * @uses SMSMTEvent::setSubscriber()
     * @uses SMSMTEvent::setMOCode()
     * @uses SMSMTEvent::setEventDate()
     * @uses SMSMTEvent::setCarrier()
     * @param \App\Library\ExactTarget\StructType\SMSTriggeredSend $sMSTriggeredSend
     * @param \App\Library\ExactTarget\StructType\Subscriber $subscriber
     * @param string $mOCode
     * @param string $eventDate
     * @param string $carrier
     */
    public function __construct(\App\Library\ExactTarget\StructType\SMSTriggeredSend $sMSTriggeredSend = null, \App\Library\ExactTarget\StructType\Subscriber $subscriber = null, $mOCode = null, $eventDate = null, $carrier = null)
    {
        $this
            ->setSMSTriggeredSend($sMSTriggeredSend)
            ->setSubscriber($subscriber)
            ->setMOCode($mOCode)
            ->setEventDate($eventDate)
            ->setCarrier($carrier);
    }
    /**
     * Get SMSTriggeredSend value
     * @return \App\Library\ExactTarget\StructType\SMSTriggeredSend|null
     */
    public function getSMSTriggeredSend()
    {
        return $this->SMSTriggeredSend;
    }
    /**
     * Set SMSTriggeredSend value
     * @param \App\Library\ExactTarget\StructType\SMSTriggeredSend $sMSTriggeredSend
     * @return \App\Library\ExactTarget\StructType\SMSMTEvent
     */
    public function setSMSTriggeredSend(\App\Library\ExactTarget\StructType\SMSTriggeredSend $sMSTriggeredSend = null)
    {
        $this->SMSTriggeredSend = $sMSTriggeredSend;
        return $this;
    }
    /**
     * Get Subscriber value
     * @return \App\Library\ExactTarget\StructType\Subscriber|null
     */
    public function getSubscriber()
    {
        return $this->Subscriber;
    }
    /**
     * Set Subscriber value
     * @param \App\Library\ExactTarget\StructType\Subscriber $subscriber
     * @return \App\Library\ExactTarget\StructType\SMSMTEvent
     */
    public function setSubscriber(\App\Library\ExactTarget\StructType\Subscriber $subscriber = null)
    {
        $this->Subscriber = $subscriber;
        return $this;
    }
    /**
     * Get MOCode value
     * @return string|null
     */
    public function getMOCode()
    {
        return $this->MOCode;
    }
    /**
     * Set MOCode value
     * @param string $mOCode
     * @return \App\Library\ExactTarget\StructType\SMSMTEvent
     */
    public function setMOCode($mOCode = null)
    {
        // validation for constraint: string
        if (!is_null($mOCode) && !is_string($mOCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mOCode)), __LINE__);
        }
        $this->MOCode = $mOCode;
        return $this;
    }
    /**
     * Get EventDate value
     * @return string|null
     */
    public function getEventDate()
    {
        return $this->EventDate;
    }
    /**
     * Set EventDate value
     * @param string $eventDate
     * @return \App\Library\ExactTarget\StructType\SMSMTEvent
     */
    public function setEventDate($eventDate = null)
    {
        // validation for constraint: string
        if (!is_null($eventDate) && !is_string($eventDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eventDate)), __LINE__);
        }
        $this->EventDate = $eventDate;
        return $this;
    }
    /**
     * Get Carrier value
     * @return string|null
     */
    public function getCarrier()
    {
        return $this->Carrier;
    }
    /**
     * Set Carrier value
     * @param string $carrier
     * @return \App\Library\ExactTarget\StructType\SMSMTEvent
     */
    public function setCarrier($carrier = null)
    {
        // validation for constraint: string
        if (!is_null($carrier) && !is_string($carrier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($carrier)), __LINE__);
        }
        $this->Carrier = $carrier;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\SMSMTEvent
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
