<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Roles StructType
 * @subpackage Structs
 */
class Roles extends AbstractStructBase
{
    /**
     * The Role
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\Role[]
     */
    public $Role;
    /**
     * Constructor method for Roles
     * @uses Roles::setRole()
     * @param \App\Library\ExactTarget\StructType\Role[] $role
     */
    public function __construct(array $role = array())
    {
        $this
            ->setRole($role);
    }
    /**
     * Get Role value
     * @return \App\Library\ExactTarget\StructType\Role[]|null
     */
    public function getRole()
    {
        return $this->Role;
    }
    /**
     * Set Role value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\Role[] $role
     * @return \App\Library\ExactTarget\StructType\Roles
     */
    public function setRole(array $role = array())
    {
        foreach ($role as $rolesRoleItem) {
            // validation for constraint: itemType
            if (!$rolesRoleItem instanceof \App\Library\ExactTarget\StructType\Role) {
                throw new \InvalidArgumentException(sprintf('The Role property can only contain items of \App\Library\ExactTarget\StructType\Role, "%s" given', is_object($rolesRoleItem) ? get_class($rolesRoleItem) : gettype($rolesRoleItem)), __LINE__);
            }
        }
        $this->Role = $role;
        return $this;
    }
    /**
     * Add item to Role value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\Role $item
     * @return \App\Library\ExactTarget\StructType\Roles
     */
    public function addToRole(\App\Library\ExactTarget\StructType\Role $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Library\ExactTarget\StructType\Role) {
            throw new \InvalidArgumentException(sprintf('The Role property can only contain items of \App\Library\ExactTarget\StructType\Role, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Role[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\Roles
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
