<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RetrieveRequest StructType
 * @subpackage Structs
 */
class RetrieveRequest extends AbstractStructBase
{
    /**
     * The ObjectType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ObjectType;
    /**
     * The ClientIDs
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\ClientID[]
     */
    public $ClientIDs;
    /**
     * The Properties
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Properties;
    /**
     * The Filter
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\FilterPart
     */
    public $Filter;
    /**
     * The RespondTo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\AsyncResponse[]
     */
    public $RespondTo;
    /**
     * The PartnerProperties
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\APIProperty[]
     */
    public $PartnerProperties;
    /**
     * The ContinueRequest
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContinueRequest;
    /**
     * The QueryAllAccounts
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $QueryAllAccounts;
    /**
     * The RetrieveAllSinceLastBatch
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $RetrieveAllSinceLastBatch;
    /**
     * The RepeatLastResult
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $RepeatLastResult;
    /**
     * The Retrieves
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\Retrieves
     */
    public $Retrieves;
    /**
     * The Options
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\RetrieveOptions
     */
    public $Options;
    /**
     * Constructor method for RetrieveRequest
     * @uses RetrieveRequest::setObjectType()
     * @uses RetrieveRequest::setClientIDs()
     * @uses RetrieveRequest::setProperties()
     * @uses RetrieveRequest::setFilter()
     * @uses RetrieveRequest::setRespondTo()
     * @uses RetrieveRequest::setPartnerProperties()
     * @uses RetrieveRequest::setContinueRequest()
     * @uses RetrieveRequest::setQueryAllAccounts()
     * @uses RetrieveRequest::setRetrieveAllSinceLastBatch()
     * @uses RetrieveRequest::setRepeatLastResult()
     * @uses RetrieveRequest::setRetrieves()
     * @uses RetrieveRequest::setOptions()
     * @param string $objectType
     * @param \App\Library\ExactTarget\StructType\ClientID[] $clientIDs
     * @param string[] $properties
     * @param \App\Library\ExactTarget\StructType\FilterPart $filter
     * @param \App\Library\ExactTarget\StructType\AsyncResponse[] $respondTo
     * @param \App\Library\ExactTarget\StructType\APIProperty[] $partnerProperties
     * @param string $continueRequest
     * @param bool $queryAllAccounts
     * @param bool $retrieveAllSinceLastBatch
     * @param bool $repeatLastResult
     * @param \App\Library\ExactTarget\StructType\Retrieves $retrieves
     * @param \App\Library\ExactTarget\StructType\RetrieveOptions $options
     */
    public function __construct($objectType = null, array $clientIDs = array(), array $properties = array(), \App\Library\ExactTarget\StructType\FilterPart $filter = null, array $respondTo = array(), array $partnerProperties = array(), $continueRequest = null, $queryAllAccounts = null, $retrieveAllSinceLastBatch = null, $repeatLastResult = null, \App\Library\ExactTarget\StructType\Retrieves $retrieves = null, \App\Library\ExactTarget\StructType\RetrieveOptions $options = null)
    {
        $this
            ->setObjectType($objectType)
            ->setClientIDs($clientIDs)
            ->setProperties($properties)
            ->setFilter($filter)
            ->setRespondTo($respondTo)
            ->setPartnerProperties($partnerProperties)
            ->setContinueRequest($continueRequest)
            ->setQueryAllAccounts($queryAllAccounts)
            ->setRetrieveAllSinceLastBatch($retrieveAllSinceLastBatch)
            ->setRepeatLastResult($repeatLastResult)
            ->setRetrieves($retrieves)
            ->setOptions($options);
    }
    /**
     * Get ObjectType value
     * @return string
     */
    public function getObjectType()
    {
        return $this->ObjectType;
    }
    /**
     * Set ObjectType value
     * @param string $objectType
     * @return \App\Library\ExactTarget\StructType\RetrieveRequest
     */
    public function setObjectType($objectType = null)
    {
        // validation for constraint: string
        if (!is_null($objectType) && !is_string($objectType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($objectType)), __LINE__);
        }
        $this->ObjectType = $objectType;
        return $this;
    }
    /**
     * Get ClientIDs value
     * @return \App\Library\ExactTarget\StructType\ClientID[]|null
     */
    public function getClientIDs()
    {
        return $this->ClientIDs;
    }
    /**
     * Set ClientIDs value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\ClientID[] $clientIDs
     * @return \App\Library\ExactTarget\StructType\RetrieveRequest
     */
    public function setClientIDs(array $clientIDs = array())
    {
        foreach ($clientIDs as $retrieveRequestClientIDsItem) {
            // validation for constraint: itemType
            if (!$retrieveRequestClientIDsItem instanceof \App\Library\ExactTarget\StructType\ClientID) {
                throw new \InvalidArgumentException(sprintf('The ClientIDs property can only contain items of \App\Library\ExactTarget\StructType\ClientID, "%s" given', is_object($retrieveRequestClientIDsItem) ? get_class($retrieveRequestClientIDsItem) : gettype($retrieveRequestClientIDsItem)), __LINE__);
            }
        }
        $this->ClientIDs = $clientIDs;
        return $this;
    }
    /**
     * Add item to ClientIDs value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\ClientID $item
     * @return \App\Library\ExactTarget\StructType\RetrieveRequest
     */
    public function addToClientIDs(\App\Library\ExactTarget\StructType\ClientID $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Library\ExactTarget\StructType\ClientID) {
            throw new \InvalidArgumentException(sprintf('The ClientIDs property can only contain items of \App\Library\ExactTarget\StructType\ClientID, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ClientIDs[] = $item;
        return $this;
    }
    /**
     * Get Properties value
     * @return string[]|null
     */
    public function getProperties()
    {
        return $this->Properties;
    }
    /**
     * Set Properties value
     * @throws \InvalidArgumentException
     * @param string[] $properties
     * @return \App\Library\ExactTarget\StructType\RetrieveRequest
     */
    public function setProperties(array $properties = array())
    {
        foreach ($properties as $retrieveRequestPropertiesItem) {
            // validation for constraint: itemType
            if (!is_string($retrieveRequestPropertiesItem)) {
                throw new \InvalidArgumentException(sprintf('The Properties property can only contain items of string, "%s" given', is_object($retrieveRequestPropertiesItem) ? get_class($retrieveRequestPropertiesItem) : gettype($retrieveRequestPropertiesItem)), __LINE__);
            }
        }
        $this->Properties = $properties;
        return $this;
    }
    /**
     * Add item to Properties value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \App\Library\ExactTarget\StructType\RetrieveRequest
     */
    public function addToProperties($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The Properties property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Properties[] = $item;
        return $this;
    }
    /**
     * Get Filter value
     * @return \App\Library\ExactTarget\StructType\FilterPart|null
     */
    public function getFilter()
    {
        return $this->Filter;
    }
    /**
     * Set Filter value
     * @param \App\Library\ExactTarget\StructType\FilterPart $filter
     * @return \App\Library\ExactTarget\StructType\RetrieveRequest
     */
    public function setFilter(\App\Library\ExactTarget\StructType\FilterPart $filter = null)
    {
        $this->Filter = $filter;
        return $this;
    }
    /**
     * Get RespondTo value
     * @return \App\Library\ExactTarget\StructType\AsyncResponse[]|null
     */
    public function getRespondTo()
    {
        return $this->RespondTo;
    }
    /**
     * Set RespondTo value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\AsyncResponse[] $respondTo
     * @return \App\Library\ExactTarget\StructType\RetrieveRequest
     */
    public function setRespondTo(array $respondTo = array())
    {
        foreach ($respondTo as $retrieveRequestRespondToItem) {
            // validation for constraint: itemType
            if (!$retrieveRequestRespondToItem instanceof \App\Library\ExactTarget\StructType\AsyncResponse) {
                throw new \InvalidArgumentException(sprintf('The RespondTo property can only contain items of \App\Library\ExactTarget\StructType\AsyncResponse, "%s" given', is_object($retrieveRequestRespondToItem) ? get_class($retrieveRequestRespondToItem) : gettype($retrieveRequestRespondToItem)), __LINE__);
            }
        }
        $this->RespondTo = $respondTo;
        return $this;
    }
    /**
     * Add item to RespondTo value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\AsyncResponse $item
     * @return \App\Library\ExactTarget\StructType\RetrieveRequest
     */
    public function addToRespondTo(\App\Library\ExactTarget\StructType\AsyncResponse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Library\ExactTarget\StructType\AsyncResponse) {
            throw new \InvalidArgumentException(sprintf('The RespondTo property can only contain items of \App\Library\ExactTarget\StructType\AsyncResponse, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RespondTo[] = $item;
        return $this;
    }
    /**
     * Get PartnerProperties value
     * @return \App\Library\ExactTarget\StructType\APIProperty[]|null
     */
    public function getPartnerProperties()
    {
        return $this->PartnerProperties;
    }
    /**
     * Set PartnerProperties value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\APIProperty[] $partnerProperties
     * @return \App\Library\ExactTarget\StructType\RetrieveRequest
     */
    public function setPartnerProperties(array $partnerProperties = array())
    {
        foreach ($partnerProperties as $retrieveRequestPartnerPropertiesItem) {
            // validation for constraint: itemType
            if (!$retrieveRequestPartnerPropertiesItem instanceof \App\Library\ExactTarget\StructType\APIProperty) {
                throw new \InvalidArgumentException(sprintf('The PartnerProperties property can only contain items of \App\Library\ExactTarget\StructType\APIProperty, "%s" given', is_object($retrieveRequestPartnerPropertiesItem) ? get_class($retrieveRequestPartnerPropertiesItem) : gettype($retrieveRequestPartnerPropertiesItem)), __LINE__);
            }
        }
        $this->PartnerProperties = $partnerProperties;
        return $this;
    }
    /**
     * Add item to PartnerProperties value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\APIProperty $item
     * @return \App\Library\ExactTarget\StructType\RetrieveRequest
     */
    public function addToPartnerProperties(\App\Library\ExactTarget\StructType\APIProperty $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Library\ExactTarget\StructType\APIProperty) {
            throw new \InvalidArgumentException(sprintf('The PartnerProperties property can only contain items of \App\Library\ExactTarget\StructType\APIProperty, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PartnerProperties[] = $item;
        return $this;
    }
    /**
     * Get ContinueRequest value
     * @return string|null
     */
    public function getContinueRequest()
    {
        return $this->ContinueRequest;
    }
    /**
     * Set ContinueRequest value
     * @param string $continueRequest
     * @return \App\Library\ExactTarget\StructType\RetrieveRequest
     */
    public function setContinueRequest($continueRequest = null)
    {
        // validation for constraint: string
        if (!is_null($continueRequest) && !is_string($continueRequest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($continueRequest)), __LINE__);
        }
        $this->ContinueRequest = $continueRequest;
        return $this;
    }
    /**
     * Get QueryAllAccounts value
     * @return bool|null
     */
    public function getQueryAllAccounts()
    {
        return $this->QueryAllAccounts;
    }
    /**
     * Set QueryAllAccounts value
     * @param bool $queryAllAccounts
     * @return \App\Library\ExactTarget\StructType\RetrieveRequest
     */
    public function setQueryAllAccounts($queryAllAccounts = null)
    {
        // validation for constraint: boolean
        if (!is_null($queryAllAccounts) && !is_bool($queryAllAccounts)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($queryAllAccounts)), __LINE__);
        }
        $this->QueryAllAccounts = $queryAllAccounts;
        return $this;
    }
    /**
     * Get RetrieveAllSinceLastBatch value
     * @return bool|null
     */
    public function getRetrieveAllSinceLastBatch()
    {
        return $this->RetrieveAllSinceLastBatch;
    }
    /**
     * Set RetrieveAllSinceLastBatch value
     * @param bool $retrieveAllSinceLastBatch
     * @return \App\Library\ExactTarget\StructType\RetrieveRequest
     */
    public function setRetrieveAllSinceLastBatch($retrieveAllSinceLastBatch = null)
    {
        // validation for constraint: boolean
        if (!is_null($retrieveAllSinceLastBatch) && !is_bool($retrieveAllSinceLastBatch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($retrieveAllSinceLastBatch)), __LINE__);
        }
        $this->RetrieveAllSinceLastBatch = $retrieveAllSinceLastBatch;
        return $this;
    }
    /**
     * Get RepeatLastResult value
     * @return bool|null
     */
    public function getRepeatLastResult()
    {
        return $this->RepeatLastResult;
    }
    /**
     * Set RepeatLastResult value
     * @param bool $repeatLastResult
     * @return \App\Library\ExactTarget\StructType\RetrieveRequest
     */
    public function setRepeatLastResult($repeatLastResult = null)
    {
        // validation for constraint: boolean
        if (!is_null($repeatLastResult) && !is_bool($repeatLastResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($repeatLastResult)), __LINE__);
        }
        $this->RepeatLastResult = $repeatLastResult;
        return $this;
    }
    /**
     * Get Retrieves value
     * @return \App\Library\ExactTarget\StructType\Retrieves|null
     */
    public function getRetrieves()
    {
        return $this->Retrieves;
    }
    /**
     * Set Retrieves value
     * @param \App\Library\ExactTarget\StructType\Retrieves $retrieves
     * @return \App\Library\ExactTarget\StructType\RetrieveRequest
     */
    public function setRetrieves(\App\Library\ExactTarget\StructType\Retrieves $retrieves = null)
    {
        $this->Retrieves = $retrieves;
        return $this;
    }
    /**
     * Get Options value
     * @return \App\Library\ExactTarget\StructType\RetrieveOptions|null
     */
    public function getOptions()
    {
        return $this->Options;
    }
    /**
     * Set Options value
     * @param \App\Library\ExactTarget\StructType\RetrieveOptions $options
     * @return \App\Library\ExactTarget\StructType\RetrieveRequest
     */
    public function setOptions(\App\Library\ExactTarget\StructType\RetrieveOptions $options = null)
    {
        $this->Options = $options;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\RetrieveRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
