<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResultMessage StructType
 * @subpackage Structs
 */
class ResultMessage extends APIObject
{
    /**
     * The RequestID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RequestID;
    /**
     * The ConversationID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ConversationID;
    /**
     * The OverallStatusCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $OverallStatusCode;
    /**
     * The StatusCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $StatusCode;
    /**
     * The StatusMessage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $StatusMessage;
    /**
     * The ErrorCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ErrorCode;
    /**
     * The RequestType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RequestType;
    /**
     * The ResultType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ResultType;
    /**
     * The ResultDetailXML
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ResultDetailXML;
    /**
     * The SequenceCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SequenceCode;
    /**
     * The CallsInConversation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CallsInConversation;
    /**
     * Constructor method for ResultMessage
     * @uses ResultMessage::setRequestID()
     * @uses ResultMessage::setConversationID()
     * @uses ResultMessage::setOverallStatusCode()
     * @uses ResultMessage::setStatusCode()
     * @uses ResultMessage::setStatusMessage()
     * @uses ResultMessage::setErrorCode()
     * @uses ResultMessage::setRequestType()
     * @uses ResultMessage::setResultType()
     * @uses ResultMessage::setResultDetailXML()
     * @uses ResultMessage::setSequenceCode()
     * @uses ResultMessage::setCallsInConversation()
     * @param string $requestID
     * @param string $conversationID
     * @param string $overallStatusCode
     * @param string $statusCode
     * @param string $statusMessage
     * @param int $errorCode
     * @param string $requestType
     * @param string $resultType
     * @param string $resultDetailXML
     * @param int $sequenceCode
     * @param int $callsInConversation
     */
    public function __construct($requestID = null, $conversationID = null, $overallStatusCode = null, $statusCode = null, $statusMessage = null, $errorCode = null, $requestType = null, $resultType = null, $resultDetailXML = null, $sequenceCode = null, $callsInConversation = null)
    {
        $this
            ->setRequestID($requestID)
            ->setConversationID($conversationID)
            ->setOverallStatusCode($overallStatusCode)
            ->setStatusCode($statusCode)
            ->setStatusMessage($statusMessage)
            ->setErrorCode($errorCode)
            ->setRequestType($requestType)
            ->setResultType($resultType)
            ->setResultDetailXML($resultDetailXML)
            ->setSequenceCode($sequenceCode)
            ->setCallsInConversation($callsInConversation);
    }
    /**
     * Get RequestID value
     * @return string|null
     */
    public function getRequestID()
    {
        return $this->RequestID;
    }
    /**
     * Set RequestID value
     * @param string $requestID
     * @return \App\Library\ExactTarget\StructType\ResultMessage
     */
    public function setRequestID($requestID = null)
    {
        // validation for constraint: string
        if (!is_null($requestID) && !is_string($requestID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestID)), __LINE__);
        }
        $this->RequestID = $requestID;
        return $this;
    }
    /**
     * Get ConversationID value
     * @return string|null
     */
    public function getConversationID()
    {
        return $this->ConversationID;
    }
    /**
     * Set ConversationID value
     * @param string $conversationID
     * @return \App\Library\ExactTarget\StructType\ResultMessage
     */
    public function setConversationID($conversationID = null)
    {
        // validation for constraint: string
        if (!is_null($conversationID) && !is_string($conversationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($conversationID)), __LINE__);
        }
        $this->ConversationID = $conversationID;
        return $this;
    }
    /**
     * Get OverallStatusCode value
     * @return string|null
     */
    public function getOverallStatusCode()
    {
        return $this->OverallStatusCode;
    }
    /**
     * Set OverallStatusCode value
     * @param string $overallStatusCode
     * @return \App\Library\ExactTarget\StructType\ResultMessage
     */
    public function setOverallStatusCode($overallStatusCode = null)
    {
        // validation for constraint: string
        if (!is_null($overallStatusCode) && !is_string($overallStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($overallStatusCode)), __LINE__);
        }
        $this->OverallStatusCode = $overallStatusCode;
        return $this;
    }
    /**
     * Get StatusCode value
     * @return string|null
     */
    public function getStatusCode()
    {
        return $this->StatusCode;
    }
    /**
     * Set StatusCode value
     * @param string $statusCode
     * @return \App\Library\ExactTarget\StructType\ResultMessage
     */
    public function setStatusCode($statusCode = null)
    {
        // validation for constraint: string
        if (!is_null($statusCode) && !is_string($statusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($statusCode)), __LINE__);
        }
        $this->StatusCode = $statusCode;
        return $this;
    }
    /**
     * Get StatusMessage value
     * @return string|null
     */
    public function getStatusMessage()
    {
        return $this->StatusMessage;
    }
    /**
     * Set StatusMessage value
     * @param string $statusMessage
     * @return \App\Library\ExactTarget\StructType\ResultMessage
     */
    public function setStatusMessage($statusMessage = null)
    {
        // validation for constraint: string
        if (!is_null($statusMessage) && !is_string($statusMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($statusMessage)), __LINE__);
        }
        $this->StatusMessage = $statusMessage;
        return $this;
    }
    /**
     * Get ErrorCode value
     * @return int|null
     */
    public function getErrorCode()
    {
        return $this->ErrorCode;
    }
    /**
     * Set ErrorCode value
     * @param int $errorCode
     * @return \App\Library\ExactTarget\StructType\ResultMessage
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: int
        if (!is_null($errorCode) && !is_numeric($errorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($errorCode)), __LINE__);
        }
        $this->ErrorCode = $errorCode;
        return $this;
    }
    /**
     * Get RequestType value
     * @return string|null
     */
    public function getRequestType()
    {
        return $this->RequestType;
    }
    /**
     * Set RequestType value
     * @uses \App\Library\ExactTarget\EnumType\RequestType::valueIsValid()
     * @uses \App\Library\ExactTarget\EnumType\RequestType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $requestType
     * @return \App\Library\ExactTarget\StructType\ResultMessage
     */
    public function setRequestType($requestType = null)
    {
        // validation for constraint: enumeration
        if (!\App\Library\ExactTarget\EnumType\RequestType::valueIsValid($requestType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $requestType, implode(', ', \App\Library\ExactTarget\EnumType\RequestType::getValidValues())), __LINE__);
        }
        $this->RequestType = $requestType;
        return $this;
    }
    /**
     * Get ResultType value
     * @return string|null
     */
    public function getResultType()
    {
        return $this->ResultType;
    }
    /**
     * Set ResultType value
     * @param string $resultType
     * @return \App\Library\ExactTarget\StructType\ResultMessage
     */
    public function setResultType($resultType = null)
    {
        // validation for constraint: string
        if (!is_null($resultType) && !is_string($resultType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($resultType)), __LINE__);
        }
        $this->ResultType = $resultType;
        return $this;
    }
    /**
     * Get ResultDetailXML value
     * @return string|null
     */
    public function getResultDetailXML()
    {
        return $this->ResultDetailXML;
    }
    /**
     * Set ResultDetailXML value
     * @param string $resultDetailXML
     * @return \App\Library\ExactTarget\StructType\ResultMessage
     */
    public function setResultDetailXML($resultDetailXML = null)
    {
        // validation for constraint: string
        if (!is_null($resultDetailXML) && !is_string($resultDetailXML)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($resultDetailXML)), __LINE__);
        }
        $this->ResultDetailXML = $resultDetailXML;
        return $this;
    }
    /**
     * Get SequenceCode value
     * @return int|null
     */
    public function getSequenceCode()
    {
        return $this->SequenceCode;
    }
    /**
     * Set SequenceCode value
     * @param int $sequenceCode
     * @return \App\Library\ExactTarget\StructType\ResultMessage
     */
    public function setSequenceCode($sequenceCode = null)
    {
        // validation for constraint: int
        if (!is_null($sequenceCode) && !is_numeric($sequenceCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sequenceCode)), __LINE__);
        }
        $this->SequenceCode = $sequenceCode;
        return $this;
    }
    /**
     * Get CallsInConversation value
     * @return int|null
     */
    public function getCallsInConversation()
    {
        return $this->CallsInConversation;
    }
    /**
     * Set CallsInConversation value
     * @param int $callsInConversation
     * @return \App\Library\ExactTarget\StructType\ResultMessage
     */
    public function setCallsInConversation($callsInConversation = null)
    {
        // validation for constraint: int
        if (!is_null($callsInConversation) && !is_numeric($callsInConversation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($callsInConversation)), __LINE__);
        }
        $this->CallsInConversation = $callsInConversation;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\ResultMessage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
