<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReplyMailManagementConfiguration StructType
 * @subpackage Structs
 */
class ReplyMailManagementConfiguration extends APIObject
{
    /**
     * The EmailDisplayName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EmailDisplayName;
    /**
     * The ReplySubdomain
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReplySubdomain;
    /**
     * The EmailReplyAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EmailReplyAddress;
    /**
     * The DNSRedirectComplete
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $DNSRedirectComplete;
    /**
     * The DeleteAutoReplies
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $DeleteAutoReplies;
    /**
     * The SupportUnsubscribes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $SupportUnsubscribes;
    /**
     * The SupportUnsubKeyword
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $SupportUnsubKeyword;
    /**
     * The SupportUnsubscribeKeyword
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $SupportUnsubscribeKeyword;
    /**
     * The SupportRemoveKeyword
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $SupportRemoveKeyword;
    /**
     * The SupportOptOutKeyword
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $SupportOptOutKeyword;
    /**
     * The SupportLeaveKeyword
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $SupportLeaveKeyword;
    /**
     * The SupportMisspelledKeywords
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $SupportMisspelledKeywords;
    /**
     * The SendAutoReplies
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $SendAutoReplies;
    /**
     * The AutoReplySubject
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AutoReplySubject;
    /**
     * The AutoReplyBody
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AutoReplyBody;
    /**
     * The ForwardingAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ForwardingAddress;
    /**
     * Constructor method for ReplyMailManagementConfiguration
     * @uses ReplyMailManagementConfiguration::setEmailDisplayName()
     * @uses ReplyMailManagementConfiguration::setReplySubdomain()
     * @uses ReplyMailManagementConfiguration::setEmailReplyAddress()
     * @uses ReplyMailManagementConfiguration::setDNSRedirectComplete()
     * @uses ReplyMailManagementConfiguration::setDeleteAutoReplies()
     * @uses ReplyMailManagementConfiguration::setSupportUnsubscribes()
     * @uses ReplyMailManagementConfiguration::setSupportUnsubKeyword()
     * @uses ReplyMailManagementConfiguration::setSupportUnsubscribeKeyword()
     * @uses ReplyMailManagementConfiguration::setSupportRemoveKeyword()
     * @uses ReplyMailManagementConfiguration::setSupportOptOutKeyword()
     * @uses ReplyMailManagementConfiguration::setSupportLeaveKeyword()
     * @uses ReplyMailManagementConfiguration::setSupportMisspelledKeywords()
     * @uses ReplyMailManagementConfiguration::setSendAutoReplies()
     * @uses ReplyMailManagementConfiguration::setAutoReplySubject()
     * @uses ReplyMailManagementConfiguration::setAutoReplyBody()
     * @uses ReplyMailManagementConfiguration::setForwardingAddress()
     * @param string $emailDisplayName
     * @param string $replySubdomain
     * @param string $emailReplyAddress
     * @param bool $dNSRedirectComplete
     * @param bool $deleteAutoReplies
     * @param bool $supportUnsubscribes
     * @param bool $supportUnsubKeyword
     * @param bool $supportUnsubscribeKeyword
     * @param bool $supportRemoveKeyword
     * @param bool $supportOptOutKeyword
     * @param bool $supportLeaveKeyword
     * @param bool $supportMisspelledKeywords
     * @param bool $sendAutoReplies
     * @param string $autoReplySubject
     * @param string $autoReplyBody
     * @param string $forwardingAddress
     */
    public function __construct($emailDisplayName = null, $replySubdomain = null, $emailReplyAddress = null, $dNSRedirectComplete = null, $deleteAutoReplies = null, $supportUnsubscribes = null, $supportUnsubKeyword = null, $supportUnsubscribeKeyword = null, $supportRemoveKeyword = null, $supportOptOutKeyword = null, $supportLeaveKeyword = null, $supportMisspelledKeywords = null, $sendAutoReplies = null, $autoReplySubject = null, $autoReplyBody = null, $forwardingAddress = null)
    {
        $this
            ->setEmailDisplayName($emailDisplayName)
            ->setReplySubdomain($replySubdomain)
            ->setEmailReplyAddress($emailReplyAddress)
            ->setDNSRedirectComplete($dNSRedirectComplete)
            ->setDeleteAutoReplies($deleteAutoReplies)
            ->setSupportUnsubscribes($supportUnsubscribes)
            ->setSupportUnsubKeyword($supportUnsubKeyword)
            ->setSupportUnsubscribeKeyword($supportUnsubscribeKeyword)
            ->setSupportRemoveKeyword($supportRemoveKeyword)
            ->setSupportOptOutKeyword($supportOptOutKeyword)
            ->setSupportLeaveKeyword($supportLeaveKeyword)
            ->setSupportMisspelledKeywords($supportMisspelledKeywords)
            ->setSendAutoReplies($sendAutoReplies)
            ->setAutoReplySubject($autoReplySubject)
            ->setAutoReplyBody($autoReplyBody)
            ->setForwardingAddress($forwardingAddress);
    }
    /**
     * Get EmailDisplayName value
     * @return string|null
     */
    public function getEmailDisplayName()
    {
        return $this->EmailDisplayName;
    }
    /**
     * Set EmailDisplayName value
     * @param string $emailDisplayName
     * @return \App\Library\ExactTarget\StructType\ReplyMailManagementConfiguration
     */
    public function setEmailDisplayName($emailDisplayName = null)
    {
        // validation for constraint: string
        if (!is_null($emailDisplayName) && !is_string($emailDisplayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($emailDisplayName)), __LINE__);
        }
        $this->EmailDisplayName = $emailDisplayName;
        return $this;
    }
    /**
     * Get ReplySubdomain value
     * @return string|null
     */
    public function getReplySubdomain()
    {
        return $this->ReplySubdomain;
    }
    /**
     * Set ReplySubdomain value
     * @param string $replySubdomain
     * @return \App\Library\ExactTarget\StructType\ReplyMailManagementConfiguration
     */
    public function setReplySubdomain($replySubdomain = null)
    {
        // validation for constraint: string
        if (!is_null($replySubdomain) && !is_string($replySubdomain)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($replySubdomain)), __LINE__);
        }
        $this->ReplySubdomain = $replySubdomain;
        return $this;
    }
    /**
     * Get EmailReplyAddress value
     * @return string|null
     */
    public function getEmailReplyAddress()
    {
        return $this->EmailReplyAddress;
    }
    /**
     * Set EmailReplyAddress value
     * @param string $emailReplyAddress
     * @return \App\Library\ExactTarget\StructType\ReplyMailManagementConfiguration
     */
    public function setEmailReplyAddress($emailReplyAddress = null)
    {
        // validation for constraint: string
        if (!is_null($emailReplyAddress) && !is_string($emailReplyAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($emailReplyAddress)), __LINE__);
        }
        $this->EmailReplyAddress = $emailReplyAddress;
        return $this;
    }
    /**
     * Get DNSRedirectComplete value
     * @return bool|null
     */
    public function getDNSRedirectComplete()
    {
        return $this->DNSRedirectComplete;
    }
    /**
     * Set DNSRedirectComplete value
     * @param bool $dNSRedirectComplete
     * @return \App\Library\ExactTarget\StructType\ReplyMailManagementConfiguration
     */
    public function setDNSRedirectComplete($dNSRedirectComplete = null)
    {
        // validation for constraint: boolean
        if (!is_null($dNSRedirectComplete) && !is_bool($dNSRedirectComplete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($dNSRedirectComplete)), __LINE__);
        }
        $this->DNSRedirectComplete = $dNSRedirectComplete;
        return $this;
    }
    /**
     * Get DeleteAutoReplies value
     * @return bool|null
     */
    public function getDeleteAutoReplies()
    {
        return $this->DeleteAutoReplies;
    }
    /**
     * Set DeleteAutoReplies value
     * @param bool $deleteAutoReplies
     * @return \App\Library\ExactTarget\StructType\ReplyMailManagementConfiguration
     */
    public function setDeleteAutoReplies($deleteAutoReplies = null)
    {
        // validation for constraint: boolean
        if (!is_null($deleteAutoReplies) && !is_bool($deleteAutoReplies)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($deleteAutoReplies)), __LINE__);
        }
        $this->DeleteAutoReplies = $deleteAutoReplies;
        return $this;
    }
    /**
     * Get SupportUnsubscribes value
     * @return bool|null
     */
    public function getSupportUnsubscribes()
    {
        return $this->SupportUnsubscribes;
    }
    /**
     * Set SupportUnsubscribes value
     * @param bool $supportUnsubscribes
     * @return \App\Library\ExactTarget\StructType\ReplyMailManagementConfiguration
     */
    public function setSupportUnsubscribes($supportUnsubscribes = null)
    {
        // validation for constraint: boolean
        if (!is_null($supportUnsubscribes) && !is_bool($supportUnsubscribes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($supportUnsubscribes)), __LINE__);
        }
        $this->SupportUnsubscribes = $supportUnsubscribes;
        return $this;
    }
    /**
     * Get SupportUnsubKeyword value
     * @return bool|null
     */
    public function getSupportUnsubKeyword()
    {
        return $this->SupportUnsubKeyword;
    }
    /**
     * Set SupportUnsubKeyword value
     * @param bool $supportUnsubKeyword
     * @return \App\Library\ExactTarget\StructType\ReplyMailManagementConfiguration
     */
    public function setSupportUnsubKeyword($supportUnsubKeyword = null)
    {
        // validation for constraint: boolean
        if (!is_null($supportUnsubKeyword) && !is_bool($supportUnsubKeyword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($supportUnsubKeyword)), __LINE__);
        }
        $this->SupportUnsubKeyword = $supportUnsubKeyword;
        return $this;
    }
    /**
     * Get SupportUnsubscribeKeyword value
     * @return bool|null
     */
    public function getSupportUnsubscribeKeyword()
    {
        return $this->SupportUnsubscribeKeyword;
    }
    /**
     * Set SupportUnsubscribeKeyword value
     * @param bool $supportUnsubscribeKeyword
     * @return \App\Library\ExactTarget\StructType\ReplyMailManagementConfiguration
     */
    public function setSupportUnsubscribeKeyword($supportUnsubscribeKeyword = null)
    {
        // validation for constraint: boolean
        if (!is_null($supportUnsubscribeKeyword) && !is_bool($supportUnsubscribeKeyword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($supportUnsubscribeKeyword)), __LINE__);
        }
        $this->SupportUnsubscribeKeyword = $supportUnsubscribeKeyword;
        return $this;
    }
    /**
     * Get SupportRemoveKeyword value
     * @return bool|null
     */
    public function getSupportRemoveKeyword()
    {
        return $this->SupportRemoveKeyword;
    }
    /**
     * Set SupportRemoveKeyword value
     * @param bool $supportRemoveKeyword
     * @return \App\Library\ExactTarget\StructType\ReplyMailManagementConfiguration
     */
    public function setSupportRemoveKeyword($supportRemoveKeyword = null)
    {
        // validation for constraint: boolean
        if (!is_null($supportRemoveKeyword) && !is_bool($supportRemoveKeyword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($supportRemoveKeyword)), __LINE__);
        }
        $this->SupportRemoveKeyword = $supportRemoveKeyword;
        return $this;
    }
    /**
     * Get SupportOptOutKeyword value
     * @return bool|null
     */
    public function getSupportOptOutKeyword()
    {
        return $this->SupportOptOutKeyword;
    }
    /**
     * Set SupportOptOutKeyword value
     * @param bool $supportOptOutKeyword
     * @return \App\Library\ExactTarget\StructType\ReplyMailManagementConfiguration
     */
    public function setSupportOptOutKeyword($supportOptOutKeyword = null)
    {
        // validation for constraint: boolean
        if (!is_null($supportOptOutKeyword) && !is_bool($supportOptOutKeyword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($supportOptOutKeyword)), __LINE__);
        }
        $this->SupportOptOutKeyword = $supportOptOutKeyword;
        return $this;
    }
    /**
     * Get SupportLeaveKeyword value
     * @return bool|null
     */
    public function getSupportLeaveKeyword()
    {
        return $this->SupportLeaveKeyword;
    }
    /**
     * Set SupportLeaveKeyword value
     * @param bool $supportLeaveKeyword
     * @return \App\Library\ExactTarget\StructType\ReplyMailManagementConfiguration
     */
    public function setSupportLeaveKeyword($supportLeaveKeyword = null)
    {
        // validation for constraint: boolean
        if (!is_null($supportLeaveKeyword) && !is_bool($supportLeaveKeyword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($supportLeaveKeyword)), __LINE__);
        }
        $this->SupportLeaveKeyword = $supportLeaveKeyword;
        return $this;
    }
    /**
     * Get SupportMisspelledKeywords value
     * @return bool|null
     */
    public function getSupportMisspelledKeywords()
    {
        return $this->SupportMisspelledKeywords;
    }
    /**
     * Set SupportMisspelledKeywords value
     * @param bool $supportMisspelledKeywords
     * @return \App\Library\ExactTarget\StructType\ReplyMailManagementConfiguration
     */
    public function setSupportMisspelledKeywords($supportMisspelledKeywords = null)
    {
        // validation for constraint: boolean
        if (!is_null($supportMisspelledKeywords) && !is_bool($supportMisspelledKeywords)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($supportMisspelledKeywords)), __LINE__);
        }
        $this->SupportMisspelledKeywords = $supportMisspelledKeywords;
        return $this;
    }
    /**
     * Get SendAutoReplies value
     * @return bool|null
     */
    public function getSendAutoReplies()
    {
        return $this->SendAutoReplies;
    }
    /**
     * Set SendAutoReplies value
     * @param bool $sendAutoReplies
     * @return \App\Library\ExactTarget\StructType\ReplyMailManagementConfiguration
     */
    public function setSendAutoReplies($sendAutoReplies = null)
    {
        // validation for constraint: boolean
        if (!is_null($sendAutoReplies) && !is_bool($sendAutoReplies)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($sendAutoReplies)), __LINE__);
        }
        $this->SendAutoReplies = $sendAutoReplies;
        return $this;
    }
    /**
     * Get AutoReplySubject value
     * @return string|null
     */
    public function getAutoReplySubject()
    {
        return $this->AutoReplySubject;
    }
    /**
     * Set AutoReplySubject value
     * @param string $autoReplySubject
     * @return \App\Library\ExactTarget\StructType\ReplyMailManagementConfiguration
     */
    public function setAutoReplySubject($autoReplySubject = null)
    {
        // validation for constraint: string
        if (!is_null($autoReplySubject) && !is_string($autoReplySubject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($autoReplySubject)), __LINE__);
        }
        $this->AutoReplySubject = $autoReplySubject;
        return $this;
    }
    /**
     * Get AutoReplyBody value
     * @return string|null
     */
    public function getAutoReplyBody()
    {
        return $this->AutoReplyBody;
    }
    /**
     * Set AutoReplyBody value
     * @param string $autoReplyBody
     * @return \App\Library\ExactTarget\StructType\ReplyMailManagementConfiguration
     */
    public function setAutoReplyBody($autoReplyBody = null)
    {
        // validation for constraint: string
        if (!is_null($autoReplyBody) && !is_string($autoReplyBody)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($autoReplyBody)), __LINE__);
        }
        $this->AutoReplyBody = $autoReplyBody;
        return $this;
    }
    /**
     * Get ForwardingAddress value
     * @return string|null
     */
    public function getForwardingAddress()
    {
        return $this->ForwardingAddress;
    }
    /**
     * Set ForwardingAddress value
     * @param string $forwardingAddress
     * @return \App\Library\ExactTarget\StructType\ReplyMailManagementConfiguration
     */
    public function setForwardingAddress($forwardingAddress = null)
    {
        // validation for constraint: string
        if (!is_null($forwardingAddress) && !is_string($forwardingAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($forwardingAddress)), __LINE__);
        }
        $this->ForwardingAddress = $forwardingAddress;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\ReplyMailManagementConfiguration
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
