<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for QueryDefinition StructType
 * @subpackage Structs
 */
class QueryDefinition extends InteractionDefinition
{
    /**
     * The QueryText
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $QueryText;
    /**
     * The TargetType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TargetType;
    /**
     * The DataExtensionTarget
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\InteractionBaseObject
     */
    public $DataExtensionTarget;
    /**
     * The TargetUpdateType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TargetUpdateType;
    /**
     * The FileSpec
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FileSpec;
    /**
     * The FileType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FileType;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * The CategoryID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $CategoryID;
    /**
     * Constructor method for QueryDefinition
     * @uses QueryDefinition::setQueryText()
     * @uses QueryDefinition::setTargetType()
     * @uses QueryDefinition::setDataExtensionTarget()
     * @uses QueryDefinition::setTargetUpdateType()
     * @uses QueryDefinition::setFileSpec()
     * @uses QueryDefinition::setFileType()
     * @uses QueryDefinition::setStatus()
     * @uses QueryDefinition::setCategoryID()
     * @param string $queryText
     * @param string $targetType
     * @param \App\Library\ExactTarget\StructType\InteractionBaseObject $dataExtensionTarget
     * @param string $targetUpdateType
     * @param string $fileSpec
     * @param string $fileType
     * @param string $status
     * @param int $categoryID
     */
    public function __construct($queryText = null, $targetType = null, \App\Library\ExactTarget\StructType\InteractionBaseObject $dataExtensionTarget = null, $targetUpdateType = null, $fileSpec = null, $fileType = null, $status = null, $categoryID = null)
    {
        $this
            ->setQueryText($queryText)
            ->setTargetType($targetType)
            ->setDataExtensionTarget($dataExtensionTarget)
            ->setTargetUpdateType($targetUpdateType)
            ->setFileSpec($fileSpec)
            ->setFileType($fileType)
            ->setStatus($status)
            ->setCategoryID($categoryID);
    }
    /**
     * Get QueryText value
     * @return string|null
     */
    public function getQueryText()
    {
        return $this->QueryText;
    }
    /**
     * Set QueryText value
     * @param string $queryText
     * @return \App\Library\ExactTarget\StructType\QueryDefinition
     */
    public function setQueryText($queryText = null)
    {
        // validation for constraint: string
        if (!is_null($queryText) && !is_string($queryText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($queryText)), __LINE__);
        }
        $this->QueryText = $queryText;
        return $this;
    }
    /**
     * Get TargetType value
     * @return string|null
     */
    public function getTargetType()
    {
        return $this->TargetType;
    }
    /**
     * Set TargetType value
     * @param string $targetType
     * @return \App\Library\ExactTarget\StructType\QueryDefinition
     */
    public function setTargetType($targetType = null)
    {
        // validation for constraint: string
        if (!is_null($targetType) && !is_string($targetType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($targetType)), __LINE__);
        }
        $this->TargetType = $targetType;
        return $this;
    }
    /**
     * Get DataExtensionTarget value
     * @return \App\Library\ExactTarget\StructType\InteractionBaseObject|null
     */
    public function getDataExtensionTarget()
    {
        return $this->DataExtensionTarget;
    }
    /**
     * Set DataExtensionTarget value
     * @param \App\Library\ExactTarget\StructType\InteractionBaseObject $dataExtensionTarget
     * @return \App\Library\ExactTarget\StructType\QueryDefinition
     */
    public function setDataExtensionTarget(\App\Library\ExactTarget\StructType\InteractionBaseObject $dataExtensionTarget = null)
    {
        $this->DataExtensionTarget = $dataExtensionTarget;
        return $this;
    }
    /**
     * Get TargetUpdateType value
     * @return string|null
     */
    public function getTargetUpdateType()
    {
        return $this->TargetUpdateType;
    }
    /**
     * Set TargetUpdateType value
     * @param string $targetUpdateType
     * @return \App\Library\ExactTarget\StructType\QueryDefinition
     */
    public function setTargetUpdateType($targetUpdateType = null)
    {
        // validation for constraint: string
        if (!is_null($targetUpdateType) && !is_string($targetUpdateType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($targetUpdateType)), __LINE__);
        }
        $this->TargetUpdateType = $targetUpdateType;
        return $this;
    }
    /**
     * Get FileSpec value
     * @return string|null
     */
    public function getFileSpec()
    {
        return $this->FileSpec;
    }
    /**
     * Set FileSpec value
     * @param string $fileSpec
     * @return \App\Library\ExactTarget\StructType\QueryDefinition
     */
    public function setFileSpec($fileSpec = null)
    {
        // validation for constraint: string
        if (!is_null($fileSpec) && !is_string($fileSpec)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fileSpec)), __LINE__);
        }
        $this->FileSpec = $fileSpec;
        return $this;
    }
    /**
     * Get FileType value
     * @return string|null
     */
    public function getFileType()
    {
        return $this->FileType;
    }
    /**
     * Set FileType value
     * @param string $fileType
     * @return \App\Library\ExactTarget\StructType\QueryDefinition
     */
    public function setFileType($fileType = null)
    {
        // validation for constraint: string
        if (!is_null($fileType) && !is_string($fileType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fileType)), __LINE__);
        }
        $this->FileType = $fileType;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \App\Library\ExactTarget\StructType\QueryDefinition
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get CategoryID value
     * @return int|null
     */
    public function getCategoryID()
    {
        return $this->CategoryID;
    }
    /**
     * Set CategoryID value
     * @param int $categoryID
     * @return \App\Library\ExactTarget\StructType\QueryDefinition
     */
    public function setCategoryID($categoryID = null)
    {
        // validation for constraint: int
        if (!is_null($categoryID) && !is_numeric($categoryID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($categoryID)), __LINE__);
        }
        $this->CategoryID = $categoryID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\QueryDefinition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
