<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Portfolio StructType
 * @subpackage Structs
 */
class Portfolio extends APIObject
{
    /**
     * The Source
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\ResourceSpecification
     */
    public $Source;
    /**
     * The CategoryID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $CategoryID;
    /**
     * The FileName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FileName;
    /**
     * The DisplayName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayName;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The TypeDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TypeDescription;
    /**
     * The IsUploaded
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IsUploaded;
    /**
     * The IsActive
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IsActive;
    /**
     * The FileSizeKB
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $FileSizeKB;
    /**
     * The ThumbSizeKB
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $ThumbSizeKB;
    /**
     * The FileWidthPX
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $FileWidthPX;
    /**
     * The FileHeightPX
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $FileHeightPX;
    /**
     * The FileURL
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FileURL;
    /**
     * The ThumbURL
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ThumbURL;
    /**
     * The CacheClearTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CacheClearTime;
    /**
     * The CategoryType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CategoryType;
    /**
     * Constructor method for Portfolio
     * @uses Portfolio::setSource()
     * @uses Portfolio::setCategoryID()
     * @uses Portfolio::setFileName()
     * @uses Portfolio::setDisplayName()
     * @uses Portfolio::setDescription()
     * @uses Portfolio::setTypeDescription()
     * @uses Portfolio::setIsUploaded()
     * @uses Portfolio::setIsActive()
     * @uses Portfolio::setFileSizeKB()
     * @uses Portfolio::setThumbSizeKB()
     * @uses Portfolio::setFileWidthPX()
     * @uses Portfolio::setFileHeightPX()
     * @uses Portfolio::setFileURL()
     * @uses Portfolio::setThumbURL()
     * @uses Portfolio::setCacheClearTime()
     * @uses Portfolio::setCategoryType()
     * @param \App\Library\ExactTarget\StructType\ResourceSpecification $source
     * @param int $categoryID
     * @param string $fileName
     * @param string $displayName
     * @param string $description
     * @param string $typeDescription
     * @param bool $isUploaded
     * @param bool $isActive
     * @param int $fileSizeKB
     * @param int $thumbSizeKB
     * @param int $fileWidthPX
     * @param int $fileHeightPX
     * @param string $fileURL
     * @param string $thumbURL
     * @param string $cacheClearTime
     * @param string $categoryType
     */
    public function __construct(\App\Library\ExactTarget\StructType\ResourceSpecification $source = null, $categoryID = null, $fileName = null, $displayName = null, $description = null, $typeDescription = null, $isUploaded = null, $isActive = null, $fileSizeKB = null, $thumbSizeKB = null, $fileWidthPX = null, $fileHeightPX = null, $fileURL = null, $thumbURL = null, $cacheClearTime = null, $categoryType = null)
    {
        $this
            ->setSource($source)
            ->setCategoryID($categoryID)
            ->setFileName($fileName)
            ->setDisplayName($displayName)
            ->setDescription($description)
            ->setTypeDescription($typeDescription)
            ->setIsUploaded($isUploaded)
            ->setIsActive($isActive)
            ->setFileSizeKB($fileSizeKB)
            ->setThumbSizeKB($thumbSizeKB)
            ->setFileWidthPX($fileWidthPX)
            ->setFileHeightPX($fileHeightPX)
            ->setFileURL($fileURL)
            ->setThumbURL($thumbURL)
            ->setCacheClearTime($cacheClearTime)
            ->setCategoryType($categoryType);
    }
    /**
     * Get Source value
     * @return \App\Library\ExactTarget\StructType\ResourceSpecification|null
     */
    public function getSource()
    {
        return $this->Source;
    }
    /**
     * Set Source value
     * @param \App\Library\ExactTarget\StructType\ResourceSpecification $source
     * @return \App\Library\ExactTarget\StructType\Portfolio
     */
    public function setSource(\App\Library\ExactTarget\StructType\ResourceSpecification $source = null)
    {
        $this->Source = $source;
        return $this;
    }
    /**
     * Get CategoryID value
     * @return int|null
     */
    public function getCategoryID()
    {
        return $this->CategoryID;
    }
    /**
     * Set CategoryID value
     * @param int $categoryID
     * @return \App\Library\ExactTarget\StructType\Portfolio
     */
    public function setCategoryID($categoryID = null)
    {
        // validation for constraint: int
        if (!is_null($categoryID) && !is_numeric($categoryID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($categoryID)), __LINE__);
        }
        $this->CategoryID = $categoryID;
        return $this;
    }
    /**
     * Get FileName value
     * @return string|null
     */
    public function getFileName()
    {
        return $this->FileName;
    }
    /**
     * Set FileName value
     * @param string $fileName
     * @return \App\Library\ExactTarget\StructType\Portfolio
     */
    public function setFileName($fileName = null)
    {
        // validation for constraint: string
        if (!is_null($fileName) && !is_string($fileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fileName)), __LINE__);
        }
        $this->FileName = $fileName;
        return $this;
    }
    /**
     * Get DisplayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->DisplayName;
    }
    /**
     * Set DisplayName value
     * @param string $displayName
     * @return \App\Library\ExactTarget\StructType\Portfolio
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($displayName)), __LINE__);
        }
        $this->DisplayName = $displayName;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \App\Library\ExactTarget\StructType\Portfolio
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get TypeDescription value
     * @return string|null
     */
    public function getTypeDescription()
    {
        return $this->TypeDescription;
    }
    /**
     * Set TypeDescription value
     * @param string $typeDescription
     * @return \App\Library\ExactTarget\StructType\Portfolio
     */
    public function setTypeDescription($typeDescription = null)
    {
        // validation for constraint: string
        if (!is_null($typeDescription) && !is_string($typeDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($typeDescription)), __LINE__);
        }
        $this->TypeDescription = $typeDescription;
        return $this;
    }
    /**
     * Get IsUploaded value
     * @return bool|null
     */
    public function getIsUploaded()
    {
        return $this->IsUploaded;
    }
    /**
     * Set IsUploaded value
     * @param bool $isUploaded
     * @return \App\Library\ExactTarget\StructType\Portfolio
     */
    public function setIsUploaded($isUploaded = null)
    {
        // validation for constraint: boolean
        if (!is_null($isUploaded) && !is_bool($isUploaded)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isUploaded)), __LINE__);
        }
        $this->IsUploaded = $isUploaded;
        return $this;
    }
    /**
     * Get IsActive value
     * @return bool|null
     */
    public function getIsActive()
    {
        return $this->IsActive;
    }
    /**
     * Set IsActive value
     * @param bool $isActive
     * @return \App\Library\ExactTarget\StructType\Portfolio
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isActive)), __LINE__);
        }
        $this->IsActive = $isActive;
        return $this;
    }
    /**
     * Get FileSizeKB value
     * @return int|null
     */
    public function getFileSizeKB()
    {
        return $this->FileSizeKB;
    }
    /**
     * Set FileSizeKB value
     * @param int $fileSizeKB
     * @return \App\Library\ExactTarget\StructType\Portfolio
     */
    public function setFileSizeKB($fileSizeKB = null)
    {
        // validation for constraint: int
        if (!is_null($fileSizeKB) && !is_numeric($fileSizeKB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($fileSizeKB)), __LINE__);
        }
        $this->FileSizeKB = $fileSizeKB;
        return $this;
    }
    /**
     * Get ThumbSizeKB value
     * @return int|null
     */
    public function getThumbSizeKB()
    {
        return $this->ThumbSizeKB;
    }
    /**
     * Set ThumbSizeKB value
     * @param int $thumbSizeKB
     * @return \App\Library\ExactTarget\StructType\Portfolio
     */
    public function setThumbSizeKB($thumbSizeKB = null)
    {
        // validation for constraint: int
        if (!is_null($thumbSizeKB) && !is_numeric($thumbSizeKB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($thumbSizeKB)), __LINE__);
        }
        $this->ThumbSizeKB = $thumbSizeKB;
        return $this;
    }
    /**
     * Get FileWidthPX value
     * @return int|null
     */
    public function getFileWidthPX()
    {
        return $this->FileWidthPX;
    }
    /**
     * Set FileWidthPX value
     * @param int $fileWidthPX
     * @return \App\Library\ExactTarget\StructType\Portfolio
     */
    public function setFileWidthPX($fileWidthPX = null)
    {
        // validation for constraint: int
        if (!is_null($fileWidthPX) && !is_numeric($fileWidthPX)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($fileWidthPX)), __LINE__);
        }
        $this->FileWidthPX = $fileWidthPX;
        return $this;
    }
    /**
     * Get FileHeightPX value
     * @return int|null
     */
    public function getFileHeightPX()
    {
        return $this->FileHeightPX;
    }
    /**
     * Set FileHeightPX value
     * @param int $fileHeightPX
     * @return \App\Library\ExactTarget\StructType\Portfolio
     */
    public function setFileHeightPX($fileHeightPX = null)
    {
        // validation for constraint: int
        if (!is_null($fileHeightPX) && !is_numeric($fileHeightPX)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($fileHeightPX)), __LINE__);
        }
        $this->FileHeightPX = $fileHeightPX;
        return $this;
    }
    /**
     * Get FileURL value
     * @return string|null
     */
    public function getFileURL()
    {
        return $this->FileURL;
    }
    /**
     * Set FileURL value
     * @param string $fileURL
     * @return \App\Library\ExactTarget\StructType\Portfolio
     */
    public function setFileURL($fileURL = null)
    {
        // validation for constraint: string
        if (!is_null($fileURL) && !is_string($fileURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fileURL)), __LINE__);
        }
        $this->FileURL = $fileURL;
        return $this;
    }
    /**
     * Get ThumbURL value
     * @return string|null
     */
    public function getThumbURL()
    {
        return $this->ThumbURL;
    }
    /**
     * Set ThumbURL value
     * @param string $thumbURL
     * @return \App\Library\ExactTarget\StructType\Portfolio
     */
    public function setThumbURL($thumbURL = null)
    {
        // validation for constraint: string
        if (!is_null($thumbURL) && !is_string($thumbURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($thumbURL)), __LINE__);
        }
        $this->ThumbURL = $thumbURL;
        return $this;
    }
    /**
     * Get CacheClearTime value
     * @return string|null
     */
    public function getCacheClearTime()
    {
        return $this->CacheClearTime;
    }
    /**
     * Set CacheClearTime value
     * @param string $cacheClearTime
     * @return \App\Library\ExactTarget\StructType\Portfolio
     */
    public function setCacheClearTime($cacheClearTime = null)
    {
        // validation for constraint: string
        if (!is_null($cacheClearTime) && !is_string($cacheClearTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cacheClearTime)), __LINE__);
        }
        $this->CacheClearTime = $cacheClearTime;
        return $this;
    }
    /**
     * Get CategoryType value
     * @return string|null
     */
    public function getCategoryType()
    {
        return $this->CategoryType;
    }
    /**
     * Set CategoryType value
     * @param string $categoryType
     * @return \App\Library\ExactTarget\StructType\Portfolio
     */
    public function setCategoryType($categoryType = null)
    {
        // validation for constraint: string
        if (!is_null($categoryType) && !is_string($categoryType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($categoryType)), __LINE__);
        }
        $this->CategoryType = $categoryType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\Portfolio
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
