<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PlatformApplicationPackage StructType
 * @subpackage Structs
 */
class PlatformApplicationPackage extends APIObject
{
    /**
     * The ResourceSpecification
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\ResourceSpecification
     */
    public $ResourceSpecification;
    /**
     * The SigningKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\PublicKeyManagement
     */
    public $SigningKey;
    /**
     * The IsUpgrade
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IsUpgrade;
    /**
     * The DeveloperVersion
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeveloperVersion;
    /**
     * Constructor method for PlatformApplicationPackage
     * @uses PlatformApplicationPackage::setResourceSpecification()
     * @uses PlatformApplicationPackage::setSigningKey()
     * @uses PlatformApplicationPackage::setIsUpgrade()
     * @uses PlatformApplicationPackage::setDeveloperVersion()
     * @param \App\Library\ExactTarget\StructType\ResourceSpecification $resourceSpecification
     * @param \App\Library\ExactTarget\StructType\PublicKeyManagement $signingKey
     * @param bool $isUpgrade
     * @param string $developerVersion
     */
    public function __construct(\App\Library\ExactTarget\StructType\ResourceSpecification $resourceSpecification = null, \App\Library\ExactTarget\StructType\PublicKeyManagement $signingKey = null, $isUpgrade = null, $developerVersion = null)
    {
        $this
            ->setResourceSpecification($resourceSpecification)
            ->setSigningKey($signingKey)
            ->setIsUpgrade($isUpgrade)
            ->setDeveloperVersion($developerVersion);
    }
    /**
     * Get ResourceSpecification value
     * @return \App\Library\ExactTarget\StructType\ResourceSpecification|null
     */
    public function getResourceSpecification()
    {
        return $this->ResourceSpecification;
    }
    /**
     * Set ResourceSpecification value
     * @param \App\Library\ExactTarget\StructType\ResourceSpecification $resourceSpecification
     * @return \App\Library\ExactTarget\StructType\PlatformApplicationPackage
     */
    public function setResourceSpecification(\App\Library\ExactTarget\StructType\ResourceSpecification $resourceSpecification = null)
    {
        $this->ResourceSpecification = $resourceSpecification;
        return $this;
    }
    /**
     * Get SigningKey value
     * @return \App\Library\ExactTarget\StructType\PublicKeyManagement|null
     */
    public function getSigningKey()
    {
        return $this->SigningKey;
    }
    /**
     * Set SigningKey value
     * @param \App\Library\ExactTarget\StructType\PublicKeyManagement $signingKey
     * @return \App\Library\ExactTarget\StructType\PlatformApplicationPackage
     */
    public function setSigningKey(\App\Library\ExactTarget\StructType\PublicKeyManagement $signingKey = null)
    {
        $this->SigningKey = $signingKey;
        return $this;
    }
    /**
     * Get IsUpgrade value
     * @return bool|null
     */
    public function getIsUpgrade()
    {
        return $this->IsUpgrade;
    }
    /**
     * Set IsUpgrade value
     * @param bool $isUpgrade
     * @return \App\Library\ExactTarget\StructType\PlatformApplicationPackage
     */
    public function setIsUpgrade($isUpgrade = null)
    {
        // validation for constraint: boolean
        if (!is_null($isUpgrade) && !is_bool($isUpgrade)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isUpgrade)), __LINE__);
        }
        $this->IsUpgrade = $isUpgrade;
        return $this;
    }
    /**
     * Get DeveloperVersion value
     * @return string|null
     */
    public function getDeveloperVersion()
    {
        return $this->DeveloperVersion;
    }
    /**
     * Set DeveloperVersion value
     * @param string $developerVersion
     * @return \App\Library\ExactTarget\StructType\PlatformApplicationPackage
     */
    public function setDeveloperVersion($developerVersion = null)
    {
        // validation for constraint: string
        if (!is_null($developerVersion) && !is_string($developerVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($developerVersion)), __LINE__);
        }
        $this->DeveloperVersion = $developerVersion;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\PlatformApplicationPackage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
