<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PicklistItem StructType
 * @subpackage Structs
 */
class PicklistItem extends AbstractStructBase
{
    /**
     * The IsDefaultValue
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsDefaultValue;
    /**
     * The Label
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Label;
    /**
     * The Value
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Value;
    /**
     * Constructor method for PicklistItem
     * @uses PicklistItem::setIsDefaultValue()
     * @uses PicklistItem::setLabel()
     * @uses PicklistItem::setValue()
     * @param bool $isDefaultValue
     * @param string $label
     * @param string $value
     */
    public function __construct($isDefaultValue = null, $label = null, $value = null)
    {
        $this
            ->setIsDefaultValue($isDefaultValue)
            ->setLabel($label)
            ->setValue($value);
    }
    /**
     * Get IsDefaultValue value
     * @return bool|null
     */
    public function getIsDefaultValue()
    {
        return $this->IsDefaultValue;
    }
    /**
     * Set IsDefaultValue value
     * @param bool $isDefaultValue
     * @return \App\Library\ExactTarget\StructType\PicklistItem
     */
    public function setIsDefaultValue($isDefaultValue = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDefaultValue) && !is_bool($isDefaultValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isDefaultValue)), __LINE__);
        }
        $this->IsDefaultValue = $isDefaultValue;
        return $this;
    }
    /**
     * Get Label value
     * @return string|null
     */
    public function getLabel()
    {
        return $this->Label;
    }
    /**
     * Set Label value
     * @param string $label
     * @return \App\Library\ExactTarget\StructType\PicklistItem
     */
    public function setLabel($label = null)
    {
        // validation for constraint: string
        if (!is_null($label) && !is_string($label)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($label)), __LINE__);
        }
        $this->Label = $label;
        return $this;
    }
    /**
     * Get Value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param string $value
     * @return \App\Library\ExactTarget\StructType\PicklistItem
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\PicklistItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
