<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Permissions StructType
 * @subpackage Structs
 */
class Permissions extends AbstractStructBase
{
    /**
     * The Permission
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\Permission[]
     */
    public $Permission;
    /**
     * Constructor method for Permissions
     * @uses Permissions::setPermission()
     * @param \App\Library\ExactTarget\StructType\Permission[] $permission
     */
    public function __construct(array $permission = array())
    {
        $this
            ->setPermission($permission);
    }
    /**
     * Get Permission value
     * @return \App\Library\ExactTarget\StructType\Permission[]|null
     */
    public function getPermission()
    {
        return $this->Permission;
    }
    /**
     * Set Permission value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\Permission[] $permission
     * @return \App\Library\ExactTarget\StructType\Permissions
     */
    public function setPermission(array $permission = array())
    {
        foreach ($permission as $permissionsPermissionItem) {
            // validation for constraint: itemType
            if (!$permissionsPermissionItem instanceof \App\Library\ExactTarget\StructType\Permission) {
                throw new \InvalidArgumentException(sprintf('The Permission property can only contain items of \App\Library\ExactTarget\StructType\Permission, "%s" given', is_object($permissionsPermissionItem) ? get_class($permissionsPermissionItem) : gettype($permissionsPermissionItem)), __LINE__);
            }
        }
        $this->Permission = $permission;
        return $this;
    }
    /**
     * Add item to Permission value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\Permission $item
     * @return \App\Library\ExactTarget\StructType\Permissions
     */
    public function addToPermission(\App\Library\ExactTarget\StructType\Permission $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Library\ExactTarget\StructType\Permission) {
            throw new \InvalidArgumentException(sprintf('The Permission property can only contain items of \App\Library\ExactTarget\StructType\Permission, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Permission[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\Permissions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
