<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PermissionSet StructType
 * @subpackage Structs
 */
class PermissionSet extends APIObject
{
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The IsAllowed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IsAllowed;
    /**
     * The IsDenied
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IsDenied;
    /**
     * The PermissionSets
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\PermissionSets
     */
    public $PermissionSets;
    /**
     * The Permissions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\Permissions
     */
    public $Permissions;
    /**
     * Constructor method for PermissionSet
     * @uses PermissionSet::setName()
     * @uses PermissionSet::setDescription()
     * @uses PermissionSet::setIsAllowed()
     * @uses PermissionSet::setIsDenied()
     * @uses PermissionSet::setPermissionSets()
     * @uses PermissionSet::setPermissions()
     * @param string $name
     * @param string $description
     * @param bool $isAllowed
     * @param bool $isDenied
     * @param \App\Library\ExactTarget\StructType\PermissionSets $permissionSets
     * @param \App\Library\ExactTarget\StructType\Permissions $permissions
     */
    public function __construct($name = null, $description = null, $isAllowed = null, $isDenied = null, \App\Library\ExactTarget\StructType\PermissionSets $permissionSets = null, \App\Library\ExactTarget\StructType\Permissions $permissions = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setIsAllowed($isAllowed)
            ->setIsDenied($isDenied)
            ->setPermissionSets($permissionSets)
            ->setPermissions($permissions);
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \App\Library\ExactTarget\StructType\PermissionSet
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \App\Library\ExactTarget\StructType\PermissionSet
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get IsAllowed value
     * @return bool|null
     */
    public function getIsAllowed()
    {
        return $this->IsAllowed;
    }
    /**
     * Set IsAllowed value
     * @param bool $isAllowed
     * @return \App\Library\ExactTarget\StructType\PermissionSet
     */
    public function setIsAllowed($isAllowed = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAllowed) && !is_bool($isAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isAllowed)), __LINE__);
        }
        $this->IsAllowed = $isAllowed;
        return $this;
    }
    /**
     * Get IsDenied value
     * @return bool|null
     */
    public function getIsDenied()
    {
        return $this->IsDenied;
    }
    /**
     * Set IsDenied value
     * @param bool $isDenied
     * @return \App\Library\ExactTarget\StructType\PermissionSet
     */
    public function setIsDenied($isDenied = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDenied) && !is_bool($isDenied)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isDenied)), __LINE__);
        }
        $this->IsDenied = $isDenied;
        return $this;
    }
    /**
     * Get PermissionSets value
     * @return \App\Library\ExactTarget\StructType\PermissionSets|null
     */
    public function getPermissionSets()
    {
        return $this->PermissionSets;
    }
    /**
     * Set PermissionSets value
     * @param \App\Library\ExactTarget\StructType\PermissionSets $permissionSets
     * @return \App\Library\ExactTarget\StructType\PermissionSet
     */
    public function setPermissionSets(\App\Library\ExactTarget\StructType\PermissionSets $permissionSets = null)
    {
        $this->PermissionSets = $permissionSets;
        return $this;
    }
    /**
     * Get Permissions value
     * @return \App\Library\ExactTarget\StructType\Permissions|null
     */
    public function getPermissions()
    {
        return $this->Permissions;
    }
    /**
     * Set Permissions value
     * @param \App\Library\ExactTarget\StructType\Permissions $permissions
     * @return \App\Library\ExactTarget\StructType\PermissionSet
     */
    public function setPermissions(\App\Library\ExactTarget\StructType\Permissions $permissions = null)
    {
        $this->Permissions = $permissions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\PermissionSet
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
