<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Permission StructType
 * @subpackage Structs
 */
class Permission extends APIObject
{
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The ObjectType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ObjectType;
    /**
     * The Operation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Operation;
    /**
     * The IsShareable
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IsShareable;
    /**
     * The IsAllowed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IsAllowed;
    /**
     * The IsDenied
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IsDenied;
    /**
     * Constructor method for Permission
     * @uses Permission::setName()
     * @uses Permission::setDescription()
     * @uses Permission::setObjectType()
     * @uses Permission::setOperation()
     * @uses Permission::setIsShareable()
     * @uses Permission::setIsAllowed()
     * @uses Permission::setIsDenied()
     * @param string $name
     * @param string $description
     * @param string $objectType
     * @param string $operation
     * @param bool $isShareable
     * @param bool $isAllowed
     * @param bool $isDenied
     */
    public function __construct($name = null, $description = null, $objectType = null, $operation = null, $isShareable = null, $isAllowed = null, $isDenied = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setObjectType($objectType)
            ->setOperation($operation)
            ->setIsShareable($isShareable)
            ->setIsAllowed($isAllowed)
            ->setIsDenied($isDenied);
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \App\Library\ExactTarget\StructType\Permission
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \App\Library\ExactTarget\StructType\Permission
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get ObjectType value
     * @return string|null
     */
    public function getObjectType()
    {
        return $this->ObjectType;
    }
    /**
     * Set ObjectType value
     * @param string $objectType
     * @return \App\Library\ExactTarget\StructType\Permission
     */
    public function setObjectType($objectType = null)
    {
        // validation for constraint: string
        if (!is_null($objectType) && !is_string($objectType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($objectType)), __LINE__);
        }
        $this->ObjectType = $objectType;
        return $this;
    }
    /**
     * Get Operation value
     * @return string|null
     */
    public function getOperation()
    {
        return $this->Operation;
    }
    /**
     * Set Operation value
     * @param string $operation
     * @return \App\Library\ExactTarget\StructType\Permission
     */
    public function setOperation($operation = null)
    {
        // validation for constraint: string
        if (!is_null($operation) && !is_string($operation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($operation)), __LINE__);
        }
        $this->Operation = $operation;
        return $this;
    }
    /**
     * Get IsShareable value
     * @return bool|null
     */
    public function getIsShareable()
    {
        return $this->IsShareable;
    }
    /**
     * Set IsShareable value
     * @param bool $isShareable
     * @return \App\Library\ExactTarget\StructType\Permission
     */
    public function setIsShareable($isShareable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isShareable) && !is_bool($isShareable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isShareable)), __LINE__);
        }
        $this->IsShareable = $isShareable;
        return $this;
    }
    /**
     * Get IsAllowed value
     * @return bool|null
     */
    public function getIsAllowed()
    {
        return $this->IsAllowed;
    }
    /**
     * Set IsAllowed value
     * @param bool $isAllowed
     * @return \App\Library\ExactTarget\StructType\Permission
     */
    public function setIsAllowed($isAllowed = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAllowed) && !is_bool($isAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isAllowed)), __LINE__);
        }
        $this->IsAllowed = $isAllowed;
        return $this;
    }
    /**
     * Get IsDenied value
     * @return bool|null
     */
    public function getIsDenied()
    {
        return $this->IsDenied;
    }
    /**
     * Set IsDenied value
     * @param bool $isDenied
     * @return \App\Library\ExactTarget\StructType\Permission
     */
    public function setIsDenied($isDenied = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDenied) && !is_bool($isDenied)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isDenied)), __LINE__);
        }
        $this->IsDenied = $isDenied;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\Permission
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
