<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Parameters StructType
 * @subpackage Structs
 */
class Parameters extends AbstractStructBase
{
    /**
     * The Parameter
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\APIProperty[]
     */
    public $Parameter;
    /**
     * Constructor method for Parameters
     * @uses Parameters::setParameter()
     * @param \App\Library\ExactTarget\StructType\APIProperty[] $parameter
     */
    public function __construct(array $parameter = array())
    {
        $this
            ->setParameter($parameter);
    }
    /**
     * Get Parameter value
     * @return \App\Library\ExactTarget\StructType\APIProperty[]|null
     */
    public function getParameter()
    {
        return $this->Parameter;
    }
    /**
     * Set Parameter value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\APIProperty[] $parameter
     * @return \App\Library\ExactTarget\StructType\Parameters
     */
    public function setParameter(array $parameter = array())
    {
        foreach ($parameter as $parametersParameterItem) {
            // validation for constraint: itemType
            if (!$parametersParameterItem instanceof \App\Library\ExactTarget\StructType\APIProperty) {
                throw new \InvalidArgumentException(sprintf('The Parameter property can only contain items of \App\Library\ExactTarget\StructType\APIProperty, "%s" given', is_object($parametersParameterItem) ? get_class($parametersParameterItem) : gettype($parametersParameterItem)), __LINE__);
            }
        }
        $this->Parameter = $parameter;
        return $this;
    }
    /**
     * Add item to Parameter value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\APIProperty $item
     * @return \App\Library\ExactTarget\StructType\Parameters
     */
    public function addToParameter(\App\Library\ExactTarget\StructType\APIProperty $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Library\ExactTarget\StructType\APIProperty) {
            throw new \InvalidArgumentException(sprintf('The Parameter property can only contain items of \App\Library\ExactTarget\StructType\APIProperty, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Parameter[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\Parameters
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
