<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Owner StructType
 * @subpackage Structs
 */
class Owner extends AbstractStructBase
{
    /**
     * The Client
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\ClientID
     */
    public $Client;
    /**
     * The FromName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FromName;
    /**
     * The FromAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FromAddress;
    /**
     * The User
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\AccountUser
     */
    public $User;
    /**
     * Constructor method for Owner
     * @uses Owner::setClient()
     * @uses Owner::setFromName()
     * @uses Owner::setFromAddress()
     * @uses Owner::setUser()
     * @param \App\Library\ExactTarget\StructType\ClientID $client
     * @param string $fromName
     * @param string $fromAddress
     * @param \App\Library\ExactTarget\StructType\AccountUser $user
     */
    public function __construct(\App\Library\ExactTarget\StructType\ClientID $client = null, $fromName = null, $fromAddress = null, \App\Library\ExactTarget\StructType\AccountUser $user = null)
    {
        $this
            ->setClient($client)
            ->setFromName($fromName)
            ->setFromAddress($fromAddress)
            ->setUser($user);
    }
    /**
     * Get Client value
     * @return \App\Library\ExactTarget\StructType\ClientID|null
     */
    public function getClient()
    {
        return $this->Client;
    }
    /**
     * Set Client value
     * @param \App\Library\ExactTarget\StructType\ClientID $client
     * @return \App\Library\ExactTarget\StructType\Owner
     */
    public function setClient(\App\Library\ExactTarget\StructType\ClientID $client = null)
    {
        $this->Client = $client;
        return $this;
    }
    /**
     * Get FromName value
     * @return string|null
     */
    public function getFromName()
    {
        return $this->FromName;
    }
    /**
     * Set FromName value
     * @param string $fromName
     * @return \App\Library\ExactTarget\StructType\Owner
     */
    public function setFromName($fromName = null)
    {
        // validation for constraint: string
        if (!is_null($fromName) && !is_string($fromName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fromName)), __LINE__);
        }
        $this->FromName = $fromName;
        return $this;
    }
    /**
     * Get FromAddress value
     * @return string|null
     */
    public function getFromAddress()
    {
        return $this->FromAddress;
    }
    /**
     * Set FromAddress value
     * @param string $fromAddress
     * @return \App\Library\ExactTarget\StructType\Owner
     */
    public function setFromAddress($fromAddress = null)
    {
        // validation for constraint: string
        if (!is_null($fromAddress) && !is_string($fromAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fromAddress)), __LINE__);
        }
        $this->FromAddress = $fromAddress;
        return $this;
    }
    /**
     * Get User value
     * @return \App\Library\ExactTarget\StructType\AccountUser|null
     */
    public function getUser()
    {
        return $this->User;
    }
    /**
     * Set User value
     * @param \App\Library\ExactTarget\StructType\AccountUser $user
     * @return \App\Library\ExactTarget\StructType\Owner
     */
    public function setUser(\App\Library\ExactTarget\StructType\AccountUser $user = null)
    {
        $this->User = $user;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\Owner
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
