<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Outages StructType
 * @subpackage Structs
 */
class Outages extends AbstractStructBase
{
    /**
     * The Outage
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\SystemOutage[]
     */
    public $Outage;
    /**
     * Constructor method for Outages
     * @uses Outages::setOutage()
     * @param \App\Library\ExactTarget\StructType\SystemOutage[] $outage
     */
    public function __construct(array $outage = array())
    {
        $this
            ->setOutage($outage);
    }
    /**
     * Get Outage value
     * @return \App\Library\ExactTarget\StructType\SystemOutage[]|null
     */
    public function getOutage()
    {
        return $this->Outage;
    }
    /**
     * Set Outage value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\SystemOutage[] $outage
     * @return \App\Library\ExactTarget\StructType\Outages
     */
    public function setOutage(array $outage = array())
    {
        foreach ($outage as $outagesOutageItem) {
            // validation for constraint: itemType
            if (!$outagesOutageItem instanceof \App\Library\ExactTarget\StructType\SystemOutage) {
                throw new \InvalidArgumentException(sprintf('The Outage property can only contain items of \App\Library\ExactTarget\StructType\SystemOutage, "%s" given', is_object($outagesOutageItem) ? get_class($outagesOutageItem) : gettype($outagesOutageItem)), __LINE__);
            }
        }
        $this->Outage = $outage;
        return $this;
    }
    /**
     * Add item to Outage value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\SystemOutage $item
     * @return \App\Library\ExactTarget\StructType\Outages
     */
    public function addToOutage(\App\Library\ExactTarget\StructType\SystemOutage $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Library\ExactTarget\StructType\SystemOutage) {
            throw new \InvalidArgumentException(sprintf('The Outage property can only contain items of \App\Library\ExactTarget\StructType\SystemOutage, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Outage[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\Outages
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
