<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Options StructType
 * @subpackage Structs
 */
abstract class Options extends AbstractStructBase
{
    /**
     * The Client
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\ClientID
     */
    public $Client;
    /**
     * The SendResponseTo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\AsyncResponse[]
     */
    public $SendResponseTo;
    /**
     * The SaveOptions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\SaveOptions
     */
    public $SaveOptions;
    /**
     * The Priority
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Priority;
    /**
     * The ConversationID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ConversationID;
    /**
     * The SequenceCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SequenceCode;
    /**
     * The CallsInConversation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CallsInConversation;
    /**
     * The ScheduledTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ScheduledTime;
    /**
     * The RequestType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RequestType;
    /**
     * The QueuePriority
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $QueuePriority;
    /**
     * Constructor method for Options
     * @uses Options::setClient()
     * @uses Options::setSendResponseTo()
     * @uses Options::setSaveOptions()
     * @uses Options::setPriority()
     * @uses Options::setConversationID()
     * @uses Options::setSequenceCode()
     * @uses Options::setCallsInConversation()
     * @uses Options::setScheduledTime()
     * @uses Options::setRequestType()
     * @uses Options::setQueuePriority()
     * @param \App\Library\ExactTarget\StructType\ClientID $client
     * @param \App\Library\ExactTarget\StructType\AsyncResponse[] $sendResponseTo
     * @param \App\Library\ExactTarget\StructType\SaveOptions $saveOptions
     * @param string $priority
     * @param string $conversationID
     * @param int $sequenceCode
     * @param int $callsInConversation
     * @param string $scheduledTime
     * @param string $requestType
     * @param string $queuePriority
     */
    public function __construct(\App\Library\ExactTarget\StructType\ClientID $client = null, array $sendResponseTo = array(), \App\Library\ExactTarget\StructType\SaveOptions $saveOptions = null, $priority = null, $conversationID = null, $sequenceCode = null, $callsInConversation = null, $scheduledTime = null, $requestType = null, $queuePriority = null)
    {
        $this
            ->setClient($client)
            ->setSendResponseTo($sendResponseTo)
            ->setSaveOptions($saveOptions)
            ->setPriority($priority)
            ->setConversationID($conversationID)
            ->setSequenceCode($sequenceCode)
            ->setCallsInConversation($callsInConversation)
            ->setScheduledTime($scheduledTime)
            ->setRequestType($requestType)
            ->setQueuePriority($queuePriority);
    }
    /**
     * Get Client value
     * @return \App\Library\ExactTarget\StructType\ClientID|null
     */
    public function getClient()
    {
        return $this->Client;
    }
    /**
     * Set Client value
     * @param \App\Library\ExactTarget\StructType\ClientID $client
     * @return \App\Library\ExactTarget\StructType\Options
     */
    public function setClient(\App\Library\ExactTarget\StructType\ClientID $client = null)
    {
        $this->Client = $client;
        return $this;
    }
    /**
     * Get SendResponseTo value
     * @return \App\Library\ExactTarget\StructType\AsyncResponse[]|null
     */
    public function getSendResponseTo()
    {
        return $this->SendResponseTo;
    }
    /**
     * Set SendResponseTo value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\AsyncResponse[] $sendResponseTo
     * @return \App\Library\ExactTarget\StructType\Options
     */
    public function setSendResponseTo(array $sendResponseTo = array())
    {
        foreach ($sendResponseTo as $optionsSendResponseToItem) {
            // validation for constraint: itemType
            if (!$optionsSendResponseToItem instanceof \App\Library\ExactTarget\StructType\AsyncResponse) {
                throw new \InvalidArgumentException(sprintf('The SendResponseTo property can only contain items of \App\Library\ExactTarget\StructType\AsyncResponse, "%s" given', is_object($optionsSendResponseToItem) ? get_class($optionsSendResponseToItem) : gettype($optionsSendResponseToItem)), __LINE__);
            }
        }
        $this->SendResponseTo = $sendResponseTo;
        return $this;
    }
    /**
     * Add item to SendResponseTo value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\AsyncResponse $item
     * @return \App\Library\ExactTarget\StructType\Options
     */
    public function addToSendResponseTo(\App\Library\ExactTarget\StructType\AsyncResponse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Library\ExactTarget\StructType\AsyncResponse) {
            throw new \InvalidArgumentException(sprintf('The SendResponseTo property can only contain items of \App\Library\ExactTarget\StructType\AsyncResponse, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SendResponseTo[] = $item;
        return $this;
    }
    /**
     * Get SaveOptions value
     * @return \App\Library\ExactTarget\StructType\SaveOptions|null
     */
    public function getSaveOptions()
    {
        return $this->SaveOptions;
    }
    /**
     * Set SaveOptions value
     * @param \App\Library\ExactTarget\StructType\SaveOptions $saveOptions
     * @return \App\Library\ExactTarget\StructType\Options
     */
    public function setSaveOptions(\App\Library\ExactTarget\StructType\SaveOptions $saveOptions = null)
    {
        $this->SaveOptions = $saveOptions;
        return $this;
    }
    /**
     * Get Priority value
     * @return string|null
     */
    public function getPriority()
    {
        return $this->Priority;
    }
    /**
     * Set Priority value
     * @param string $priority
     * @return \App\Library\ExactTarget\StructType\Options
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: string
        if (!is_null($priority) && !is_string($priority)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($priority)), __LINE__);
        }
        $this->Priority = $priority;
        return $this;
    }
    /**
     * Get ConversationID value
     * @return string|null
     */
    public function getConversationID()
    {
        return $this->ConversationID;
    }
    /**
     * Set ConversationID value
     * @param string $conversationID
     * @return \App\Library\ExactTarget\StructType\Options
     */
    public function setConversationID($conversationID = null)
    {
        // validation for constraint: string
        if (!is_null($conversationID) && !is_string($conversationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($conversationID)), __LINE__);
        }
        $this->ConversationID = $conversationID;
        return $this;
    }
    /**
     * Get SequenceCode value
     * @return int|null
     */
    public function getSequenceCode()
    {
        return $this->SequenceCode;
    }
    /**
     * Set SequenceCode value
     * @param int $sequenceCode
     * @return \App\Library\ExactTarget\StructType\Options
     */
    public function setSequenceCode($sequenceCode = null)
    {
        // validation for constraint: int
        if (!is_null($sequenceCode) && !is_numeric($sequenceCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sequenceCode)), __LINE__);
        }
        $this->SequenceCode = $sequenceCode;
        return $this;
    }
    /**
     * Get CallsInConversation value
     * @return int|null
     */
    public function getCallsInConversation()
    {
        return $this->CallsInConversation;
    }
    /**
     * Set CallsInConversation value
     * @param int $callsInConversation
     * @return \App\Library\ExactTarget\StructType\Options
     */
    public function setCallsInConversation($callsInConversation = null)
    {
        // validation for constraint: int
        if (!is_null($callsInConversation) && !is_numeric($callsInConversation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($callsInConversation)), __LINE__);
        }
        $this->CallsInConversation = $callsInConversation;
        return $this;
    }
    /**
     * Get ScheduledTime value
     * @return string|null
     */
    public function getScheduledTime()
    {
        return $this->ScheduledTime;
    }
    /**
     * Set ScheduledTime value
     * @param string $scheduledTime
     * @return \App\Library\ExactTarget\StructType\Options
     */
    public function setScheduledTime($scheduledTime = null)
    {
        // validation for constraint: string
        if (!is_null($scheduledTime) && !is_string($scheduledTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($scheduledTime)), __LINE__);
        }
        $this->ScheduledTime = $scheduledTime;
        return $this;
    }
    /**
     * Get RequestType value
     * @return string|null
     */
    public function getRequestType()
    {
        return $this->RequestType;
    }
    /**
     * Set RequestType value
     * @uses \App\Library\ExactTarget\EnumType\RequestType::valueIsValid()
     * @uses \App\Library\ExactTarget\EnumType\RequestType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $requestType
     * @return \App\Library\ExactTarget\StructType\Options
     */
    public function setRequestType($requestType = null)
    {
        // validation for constraint: enumeration
        if (!\App\Library\ExactTarget\EnumType\RequestType::valueIsValid($requestType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $requestType, implode(', ', \App\Library\ExactTarget\EnumType\RequestType::getValidValues())), __LINE__);
        }
        $this->RequestType = $requestType;
        return $this;
    }
    /**
     * Get QueuePriority value
     * @return string|null
     */
    public function getQueuePriority()
    {
        return $this->QueuePriority;
    }
    /**
     * Set QueuePriority value
     * @uses \App\Library\ExactTarget\EnumType\Priority::valueIsValid()
     * @uses \App\Library\ExactTarget\EnumType\Priority::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $queuePriority
     * @return \App\Library\ExactTarget\StructType\Options
     */
    public function setQueuePriority($queuePriority = null)
    {
        // validation for constraint: enumeration
        if (!\App\Library\ExactTarget\EnumType\Priority::valueIsValid($queuePriority)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $queuePriority, implode(', ', \App\Library\ExactTarget\EnumType\Priority::getValidValues())), __LINE__);
        }
        $this->QueuePriority = $queuePriority;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\Options
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
