<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ObjectDefinition StructType
 * @subpackage Structs
 */
class ObjectDefinition extends AbstractStructBase
{
    /**
     * The ObjectType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ObjectType;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The IsCreatable
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IsCreatable;
    /**
     * The IsUpdatable
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IsUpdatable;
    /**
     * The IsRetrievable
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IsRetrievable;
    /**
     * The IsQueryable
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IsQueryable;
    /**
     * The IsReference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IsReference;
    /**
     * The ReferencedType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReferencedType;
    /**
     * The IsPropertyCollection
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IsPropertyCollection;
    /**
     * The IsObjectCollection
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IsObjectCollection;
    /**
     * The Properties
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\PropertyDefinition[]
     */
    public $Properties;
    /**
     * The ExtendedProperties
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\ExtendedProperties
     */
    public $ExtendedProperties;
    /**
     * The ChildObjects
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\ObjectDefinition[]
     */
    public $ChildObjects;
    /**
     * Constructor method for ObjectDefinition
     * @uses ObjectDefinition::setObjectType()
     * @uses ObjectDefinition::setName()
     * @uses ObjectDefinition::setIsCreatable()
     * @uses ObjectDefinition::setIsUpdatable()
     * @uses ObjectDefinition::setIsRetrievable()
     * @uses ObjectDefinition::setIsQueryable()
     * @uses ObjectDefinition::setIsReference()
     * @uses ObjectDefinition::setReferencedType()
     * @uses ObjectDefinition::setIsPropertyCollection()
     * @uses ObjectDefinition::setIsObjectCollection()
     * @uses ObjectDefinition::setProperties()
     * @uses ObjectDefinition::setExtendedProperties()
     * @uses ObjectDefinition::setChildObjects()
     * @param string $objectType
     * @param string $name
     * @param bool $isCreatable
     * @param bool $isUpdatable
     * @param bool $isRetrievable
     * @param bool $isQueryable
     * @param bool $isReference
     * @param string $referencedType
     * @param string $isPropertyCollection
     * @param bool $isObjectCollection
     * @param \App\Library\ExactTarget\StructType\PropertyDefinition[] $properties
     * @param \App\Library\ExactTarget\StructType\ExtendedProperties $extendedProperties
     * @param \App\Library\ExactTarget\StructType\ObjectDefinition[] $childObjects
     */
    public function __construct($objectType = null, $name = null, $isCreatable = null, $isUpdatable = null, $isRetrievable = null, $isQueryable = null, $isReference = null, $referencedType = null, $isPropertyCollection = null, $isObjectCollection = null, array $properties = array(), \App\Library\ExactTarget\StructType\ExtendedProperties $extendedProperties = null, array $childObjects = array())
    {
        $this
            ->setObjectType($objectType)
            ->setName($name)
            ->setIsCreatable($isCreatable)
            ->setIsUpdatable($isUpdatable)
            ->setIsRetrievable($isRetrievable)
            ->setIsQueryable($isQueryable)
            ->setIsReference($isReference)
            ->setReferencedType($referencedType)
            ->setIsPropertyCollection($isPropertyCollection)
            ->setIsObjectCollection($isObjectCollection)
            ->setProperties($properties)
            ->setExtendedProperties($extendedProperties)
            ->setChildObjects($childObjects);
    }
    /**
     * Get ObjectType value
     * @return string|null
     */
    public function getObjectType()
    {
        return $this->ObjectType;
    }
    /**
     * Set ObjectType value
     * @param string $objectType
     * @return \App\Library\ExactTarget\StructType\ObjectDefinition
     */
    public function setObjectType($objectType = null)
    {
        // validation for constraint: string
        if (!is_null($objectType) && !is_string($objectType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($objectType)), __LINE__);
        }
        $this->ObjectType = $objectType;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \App\Library\ExactTarget\StructType\ObjectDefinition
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get IsCreatable value
     * @return bool|null
     */
    public function getIsCreatable()
    {
        return $this->IsCreatable;
    }
    /**
     * Set IsCreatable value
     * @param bool $isCreatable
     * @return \App\Library\ExactTarget\StructType\ObjectDefinition
     */
    public function setIsCreatable($isCreatable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCreatable) && !is_bool($isCreatable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isCreatable)), __LINE__);
        }
        $this->IsCreatable = $isCreatable;
        return $this;
    }
    /**
     * Get IsUpdatable value
     * @return bool|null
     */
    public function getIsUpdatable()
    {
        return $this->IsUpdatable;
    }
    /**
     * Set IsUpdatable value
     * @param bool $isUpdatable
     * @return \App\Library\ExactTarget\StructType\ObjectDefinition
     */
    public function setIsUpdatable($isUpdatable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isUpdatable) && !is_bool($isUpdatable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isUpdatable)), __LINE__);
        }
        $this->IsUpdatable = $isUpdatable;
        return $this;
    }
    /**
     * Get IsRetrievable value
     * @return bool|null
     */
    public function getIsRetrievable()
    {
        return $this->IsRetrievable;
    }
    /**
     * Set IsRetrievable value
     * @param bool $isRetrievable
     * @return \App\Library\ExactTarget\StructType\ObjectDefinition
     */
    public function setIsRetrievable($isRetrievable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRetrievable) && !is_bool($isRetrievable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isRetrievable)), __LINE__);
        }
        $this->IsRetrievable = $isRetrievable;
        return $this;
    }
    /**
     * Get IsQueryable value
     * @return bool|null
     */
    public function getIsQueryable()
    {
        return $this->IsQueryable;
    }
    /**
     * Set IsQueryable value
     * @param bool $isQueryable
     * @return \App\Library\ExactTarget\StructType\ObjectDefinition
     */
    public function setIsQueryable($isQueryable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isQueryable) && !is_bool($isQueryable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isQueryable)), __LINE__);
        }
        $this->IsQueryable = $isQueryable;
        return $this;
    }
    /**
     * Get IsReference value
     * @return bool|null
     */
    public function getIsReference()
    {
        return $this->IsReference;
    }
    /**
     * Set IsReference value
     * @param bool $isReference
     * @return \App\Library\ExactTarget\StructType\ObjectDefinition
     */
    public function setIsReference($isReference = null)
    {
        // validation for constraint: boolean
        if (!is_null($isReference) && !is_bool($isReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isReference)), __LINE__);
        }
        $this->IsReference = $isReference;
        return $this;
    }
    /**
     * Get ReferencedType value
     * @return string|null
     */
    public function getReferencedType()
    {
        return $this->ReferencedType;
    }
    /**
     * Set ReferencedType value
     * @param string $referencedType
     * @return \App\Library\ExactTarget\StructType\ObjectDefinition
     */
    public function setReferencedType($referencedType = null)
    {
        // validation for constraint: string
        if (!is_null($referencedType) && !is_string($referencedType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($referencedType)), __LINE__);
        }
        $this->ReferencedType = $referencedType;
        return $this;
    }
    /**
     * Get IsPropertyCollection value
     * @return string|null
     */
    public function getIsPropertyCollection()
    {
        return $this->IsPropertyCollection;
    }
    /**
     * Set IsPropertyCollection value
     * @param string $isPropertyCollection
     * @return \App\Library\ExactTarget\StructType\ObjectDefinition
     */
    public function setIsPropertyCollection($isPropertyCollection = null)
    {
        // validation for constraint: string
        if (!is_null($isPropertyCollection) && !is_string($isPropertyCollection)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($isPropertyCollection)), __LINE__);
        }
        $this->IsPropertyCollection = $isPropertyCollection;
        return $this;
    }
    /**
     * Get IsObjectCollection value
     * @return bool|null
     */
    public function getIsObjectCollection()
    {
        return $this->IsObjectCollection;
    }
    /**
     * Set IsObjectCollection value
     * @param bool $isObjectCollection
     * @return \App\Library\ExactTarget\StructType\ObjectDefinition
     */
    public function setIsObjectCollection($isObjectCollection = null)
    {
        // validation for constraint: boolean
        if (!is_null($isObjectCollection) && !is_bool($isObjectCollection)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isObjectCollection)), __LINE__);
        }
        $this->IsObjectCollection = $isObjectCollection;
        return $this;
    }
    /**
     * Get Properties value
     * @return \App\Library\ExactTarget\StructType\PropertyDefinition[]|null
     */
    public function getProperties()
    {
        return $this->Properties;
    }
    /**
     * Set Properties value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\PropertyDefinition[] $properties
     * @return \App\Library\ExactTarget\StructType\ObjectDefinition
     */
    public function setProperties(array $properties = array())
    {
        foreach ($properties as $objectDefinitionPropertiesItem) {
            // validation for constraint: itemType
            if (!$objectDefinitionPropertiesItem instanceof \App\Library\ExactTarget\StructType\PropertyDefinition) {
                throw new \InvalidArgumentException(sprintf('The Properties property can only contain items of \App\Library\ExactTarget\StructType\PropertyDefinition, "%s" given', is_object($objectDefinitionPropertiesItem) ? get_class($objectDefinitionPropertiesItem) : gettype($objectDefinitionPropertiesItem)), __LINE__);
            }
        }
        $this->Properties = $properties;
        return $this;
    }
    /**
     * Add item to Properties value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\PropertyDefinition $item
     * @return \App\Library\ExactTarget\StructType\ObjectDefinition
     */
    public function addToProperties(\App\Library\ExactTarget\StructType\PropertyDefinition $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Library\ExactTarget\StructType\PropertyDefinition) {
            throw new \InvalidArgumentException(sprintf('The Properties property can only contain items of \App\Library\ExactTarget\StructType\PropertyDefinition, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Properties[] = $item;
        return $this;
    }
    /**
     * Get ExtendedProperties value
     * @return \App\Library\ExactTarget\StructType\ExtendedProperties|null
     */
    public function getExtendedProperties()
    {
        return $this->ExtendedProperties;
    }
    /**
     * Set ExtendedProperties value
     * @param \App\Library\ExactTarget\StructType\ExtendedProperties $extendedProperties
     * @return \App\Library\ExactTarget\StructType\ObjectDefinition
     */
    public function setExtendedProperties(\App\Library\ExactTarget\StructType\ExtendedProperties $extendedProperties = null)
    {
        $this->ExtendedProperties = $extendedProperties;
        return $this;
    }
    /**
     * Get ChildObjects value
     * @return \App\Library\ExactTarget\StructType\ObjectDefinition[]|null
     */
    public function getChildObjects()
    {
        return $this->ChildObjects;
    }
    /**
     * Set ChildObjects value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\ObjectDefinition[] $childObjects
     * @return \App\Library\ExactTarget\StructType\ObjectDefinition
     */
    public function setChildObjects(array $childObjects = array())
    {
        foreach ($childObjects as $objectDefinitionChildObjectsItem) {
            // validation for constraint: itemType
            if (!$objectDefinitionChildObjectsItem instanceof \App\Library\ExactTarget\StructType\ObjectDefinition) {
                throw new \InvalidArgumentException(sprintf('The ChildObjects property can only contain items of \App\Library\ExactTarget\StructType\ObjectDefinition, "%s" given', is_object($objectDefinitionChildObjectsItem) ? get_class($objectDefinitionChildObjectsItem) : gettype($objectDefinitionChildObjectsItem)), __LINE__);
            }
        }
        $this->ChildObjects = $childObjects;
        return $this;
    }
    /**
     * Add item to ChildObjects value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\ObjectDefinition $item
     * @return \App\Library\ExactTarget\StructType\ObjectDefinition
     */
    public function addToChildObjects(\App\Library\ExactTarget\StructType\ObjectDefinition $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Library\ExactTarget\StructType\ObjectDefinition) {
            throw new \InvalidArgumentException(sprintf('The ChildObjects property can only contain items of \App\Library\ExactTarget\StructType\ObjectDefinition, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ChildObjects[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\ObjectDefinition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
