<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Notifications StructType
 * @subpackage Structs
 */
class Notifications extends AbstractStructBase
{
    /**
     * The Notification
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\AutomationNotification[]
     */
    public $Notification;
    /**
     * Constructor method for Notifications
     * @uses Notifications::setNotification()
     * @param \App\Library\ExactTarget\StructType\AutomationNotification[] $notification
     */
    public function __construct(array $notification = array())
    {
        $this
            ->setNotification($notification);
    }
    /**
     * Get Notification value
     * @return \App\Library\ExactTarget\StructType\AutomationNotification[]|null
     */
    public function getNotification()
    {
        return $this->Notification;
    }
    /**
     * Set Notification value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\AutomationNotification[] $notification
     * @return \App\Library\ExactTarget\StructType\Notifications
     */
    public function setNotification(array $notification = array())
    {
        foreach ($notification as $notificationsNotificationItem) {
            // validation for constraint: itemType
            if (!$notificationsNotificationItem instanceof \App\Library\ExactTarget\StructType\AutomationNotification) {
                throw new \InvalidArgumentException(sprintf('The Notification property can only contain items of \App\Library\ExactTarget\StructType\AutomationNotification, "%s" given', is_object($notificationsNotificationItem) ? get_class($notificationsNotificationItem) : gettype($notificationsNotificationItem)), __LINE__);
            }
        }
        $this->Notification = $notification;
        return $this;
    }
    /**
     * Add item to Notification value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\AutomationNotification $item
     * @return \App\Library\ExactTarget\StructType\Notifications
     */
    public function addToNotification(\App\Library\ExactTarget\StructType\AutomationNotification $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Library\ExactTarget\StructType\AutomationNotification) {
            throw new \InvalidArgumentException(sprintf('The Notification property can only contain items of \App\Library\ExactTarget\StructType\AutomationNotification, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Notification[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\Notifications
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
