<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MinutelyRecurrence StructType
 * Meta informations extracted from the WSDL
 * - type: tns:MinutelyRecurrence
 * @subpackage Structs
 */
class MinutelyRecurrence extends Recurrence
{
    /**
     * The MinutelyRecurrencePatternType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MinutelyRecurrencePatternType;
    /**
     * The MinuteInterval
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $MinuteInterval;
    /**
     * Constructor method for MinutelyRecurrence
     * @uses MinutelyRecurrence::setMinutelyRecurrencePatternType()
     * @uses MinutelyRecurrence::setMinuteInterval()
     * @param string $minutelyRecurrencePatternType
     * @param int $minuteInterval
     */
    public function __construct($minutelyRecurrencePatternType = null, $minuteInterval = null)
    {
        $this
            ->setMinutelyRecurrencePatternType($minutelyRecurrencePatternType)
            ->setMinuteInterval($minuteInterval);
    }
    /**
     * Get MinutelyRecurrencePatternType value
     * @return string|null
     */
    public function getMinutelyRecurrencePatternType()
    {
        return $this->MinutelyRecurrencePatternType;
    }
    /**
     * Set MinutelyRecurrencePatternType value
     * @uses \App\Library\ExactTarget\EnumType\MinutelyRecurrencePatternTypeEnum::valueIsValid()
     * @uses \App\Library\ExactTarget\EnumType\MinutelyRecurrencePatternTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $minutelyRecurrencePatternType
     * @return \App\Library\ExactTarget\StructType\MinutelyRecurrence
     */
    public function setMinutelyRecurrencePatternType($minutelyRecurrencePatternType = null)
    {
        // validation for constraint: enumeration
        if (!\App\Library\ExactTarget\EnumType\MinutelyRecurrencePatternTypeEnum::valueIsValid($minutelyRecurrencePatternType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $minutelyRecurrencePatternType, implode(', ', \App\Library\ExactTarget\EnumType\MinutelyRecurrencePatternTypeEnum::getValidValues())), __LINE__);
        }
        $this->MinutelyRecurrencePatternType = $minutelyRecurrencePatternType;
        return $this;
    }
    /**
     * Get MinuteInterval value
     * @return int|null
     */
    public function getMinuteInterval()
    {
        return $this->MinuteInterval;
    }
    /**
     * Set MinuteInterval value
     * @param int $minuteInterval
     * @return \App\Library\ExactTarget\StructType\MinutelyRecurrence
     */
    public function setMinuteInterval($minuteInterval = null)
    {
        // validation for constraint: int
        if (!is_null($minuteInterval) && !is_numeric($minuteInterval)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($minuteInterval)), __LINE__);
        }
        $this->MinuteInterval = $minuteInterval;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\MinutelyRecurrence
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
