<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ListSubscriber StructType
 * @subpackage Structs
 */
class ListSubscriber extends APIObject
{
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * The ListID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $ListID;
    /**
     * The SubscriberKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SubscriberKey;
    /**
     * Constructor method for ListSubscriber
     * @uses ListSubscriber::setStatus()
     * @uses ListSubscriber::setListID()
     * @uses ListSubscriber::setSubscriberKey()
     * @param string $status
     * @param int $listID
     * @param string $subscriberKey
     */
    public function __construct($status = null, $listID = null, $subscriberKey = null)
    {
        $this
            ->setStatus($status)
            ->setListID($listID)
            ->setSubscriberKey($subscriberKey);
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \App\Library\ExactTarget\EnumType\SubscriberStatus::valueIsValid()
     * @uses \App\Library\ExactTarget\EnumType\SubscriberStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \App\Library\ExactTarget\StructType\ListSubscriber
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\App\Library\ExactTarget\EnumType\SubscriberStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \App\Library\ExactTarget\EnumType\SubscriberStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get ListID value
     * @return int|null
     */
    public function getListID()
    {
        return $this->ListID;
    }
    /**
     * Set ListID value
     * @param int $listID
     * @return \App\Library\ExactTarget\StructType\ListSubscriber
     */
    public function setListID($listID = null)
    {
        // validation for constraint: int
        if (!is_null($listID) && !is_numeric($listID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($listID)), __LINE__);
        }
        $this->ListID = $listID;
        return $this;
    }
    /**
     * Get SubscriberKey value
     * @return string|null
     */
    public function getSubscriberKey()
    {
        return $this->SubscriberKey;
    }
    /**
     * Set SubscriberKey value
     * @param string $subscriberKey
     * @return \App\Library\ExactTarget\StructType\ListSubscriber
     */
    public function setSubscriberKey($subscriberKey = null)
    {
        // validation for constraint: string
        if (!is_null($subscriberKey) && !is_string($subscriberKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subscriberKey)), __LINE__);
        }
        $this->SubscriberKey = $subscriberKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\ListSubscriber
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
