<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ListAttributeRestrictedValue StructType
 * Meta informations extracted from the WSDL
 * - type: tns:ListAttributeRestrictedValue
 * @subpackage Structs
 */
class ListAttributeRestrictedValue extends APIObject
{
    /**
     * The ValueName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ValueName;
    /**
     * The IsDefault
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IsDefault;
    /**
     * The DisplayOrder
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $DisplayOrder;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * Constructor method for ListAttributeRestrictedValue
     * @uses ListAttributeRestrictedValue::setValueName()
     * @uses ListAttributeRestrictedValue::setIsDefault()
     * @uses ListAttributeRestrictedValue::setDisplayOrder()
     * @uses ListAttributeRestrictedValue::setDescription()
     * @param string $valueName
     * @param bool $isDefault
     * @param int $displayOrder
     * @param string $description
     */
    public function __construct($valueName = null, $isDefault = null, $displayOrder = null, $description = null)
    {
        $this
            ->setValueName($valueName)
            ->setIsDefault($isDefault)
            ->setDisplayOrder($displayOrder)
            ->setDescription($description);
    }
    /**
     * Get ValueName value
     * @return string
     */
    public function getValueName()
    {
        return $this->ValueName;
    }
    /**
     * Set ValueName value
     * @param string $valueName
     * @return \App\Library\ExactTarget\StructType\ListAttributeRestrictedValue
     */
    public function setValueName($valueName = null)
    {
        // validation for constraint: string
        if (!is_null($valueName) && !is_string($valueName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($valueName)), __LINE__);
        }
        $this->ValueName = $valueName;
        return $this;
    }
    /**
     * Get IsDefault value
     * @return bool|null
     */
    public function getIsDefault()
    {
        return $this->IsDefault;
    }
    /**
     * Set IsDefault value
     * @param bool $isDefault
     * @return \App\Library\ExactTarget\StructType\ListAttributeRestrictedValue
     */
    public function setIsDefault($isDefault = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDefault) && !is_bool($isDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isDefault)), __LINE__);
        }
        $this->IsDefault = $isDefault;
        return $this;
    }
    /**
     * Get DisplayOrder value
     * @return int|null
     */
    public function getDisplayOrder()
    {
        return $this->DisplayOrder;
    }
    /**
     * Set DisplayOrder value
     * @param int $displayOrder
     * @return \App\Library\ExactTarget\StructType\ListAttributeRestrictedValue
     */
    public function setDisplayOrder($displayOrder = null)
    {
        // validation for constraint: int
        if (!is_null($displayOrder) && !is_numeric($displayOrder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($displayOrder)), __LINE__);
        }
        $this->DisplayOrder = $displayOrder;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \App\Library\ExactTarget\StructType\ListAttributeRestrictedValue
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\ListAttributeRestrictedValue
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
