<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LinkSend StructType
 * @subpackage Structs
 */
class LinkSend extends APIObject
{
    /**
     * The SendID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $SendID;
    /**
     * The Link
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\Link
     */
    public $Link;
    /**
     * The IDLong
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $IDLong;
    /**
     * Constructor method for LinkSend
     * @uses LinkSend::setSendID()
     * @uses LinkSend::setLink()
     * @uses LinkSend::setIDLong()
     * @param int $sendID
     * @param \App\Library\ExactTarget\StructType\Link $link
     * @param int $iDLong
     */
    public function __construct($sendID = null, \App\Library\ExactTarget\StructType\Link $link = null, $iDLong = null)
    {
        $this
            ->setSendID($sendID)
            ->setLink($link)
            ->setIDLong($iDLong);
    }
    /**
     * Get SendID value
     * @return int|null
     */
    public function getSendID()
    {
        return $this->SendID;
    }
    /**
     * Set SendID value
     * @param int $sendID
     * @return \App\Library\ExactTarget\StructType\LinkSend
     */
    public function setSendID($sendID = null)
    {
        // validation for constraint: int
        if (!is_null($sendID) && !is_numeric($sendID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sendID)), __LINE__);
        }
        $this->SendID = $sendID;
        return $this;
    }
    /**
     * Get Link value
     * @return \App\Library\ExactTarget\StructType\Link|null
     */
    public function getLink()
    {
        return $this->Link;
    }
    /**
     * Set Link value
     * @param \App\Library\ExactTarget\StructType\Link $link
     * @return \App\Library\ExactTarget\StructType\LinkSend
     */
    public function setLink(\App\Library\ExactTarget\StructType\Link $link = null)
    {
        $this->Link = $link;
        return $this;
    }
    /**
     * Get IDLong value
     * @return int|null
     */
    public function getIDLong()
    {
        return $this->IDLong;
    }
    /**
     * Set IDLong value
     * @param int $iDLong
     * @return \App\Library\ExactTarget\StructType\LinkSend
     */
    public function setIDLong($iDLong = null)
    {
        // validation for constraint: int
        if (!is_null($iDLong) && !is_numeric($iDLong)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($iDLong)), __LINE__);
        }
        $this->IDLong = $iDLong;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\LinkSend
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
