<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Link StructType
 * @subpackage Structs
 */
class Link extends APIObject
{
    /**
     * The LastClicked
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LastClicked;
    /**
     * The Alias
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Alias;
    /**
     * The TotalClicks
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $TotalClicks;
    /**
     * The UniqueClicks
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $UniqueClicks;
    /**
     * The URL
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $URL;
    /**
     * The Subscribers
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\TrackingEvent[]
     */
    public $Subscribers;
    /**
     * The IDLong
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $IDLong;
    /**
     * Constructor method for Link
     * @uses Link::setLastClicked()
     * @uses Link::setAlias()
     * @uses Link::setTotalClicks()
     * @uses Link::setUniqueClicks()
     * @uses Link::setURL()
     * @uses Link::setSubscribers()
     * @uses Link::setIDLong()
     * @param string $lastClicked
     * @param string $alias
     * @param int $totalClicks
     * @param int $uniqueClicks
     * @param string $uRL
     * @param \App\Library\ExactTarget\StructType\TrackingEvent[] $subscribers
     * @param int $iDLong
     */
    public function __construct($lastClicked = null, $alias = null, $totalClicks = null, $uniqueClicks = null, $uRL = null, array $subscribers = array(), $iDLong = null)
    {
        $this
            ->setLastClicked($lastClicked)
            ->setAlias($alias)
            ->setTotalClicks($totalClicks)
            ->setUniqueClicks($uniqueClicks)
            ->setURL($uRL)
            ->setSubscribers($subscribers)
            ->setIDLong($iDLong);
    }
    /**
     * Get LastClicked value
     * @return string|null
     */
    public function getLastClicked()
    {
        return $this->LastClicked;
    }
    /**
     * Set LastClicked value
     * @param string $lastClicked
     * @return \App\Library\ExactTarget\StructType\Link
     */
    public function setLastClicked($lastClicked = null)
    {
        // validation for constraint: string
        if (!is_null($lastClicked) && !is_string($lastClicked)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastClicked)), __LINE__);
        }
        $this->LastClicked = $lastClicked;
        return $this;
    }
    /**
     * Get Alias value
     * @return string|null
     */
    public function getAlias()
    {
        return $this->Alias;
    }
    /**
     * Set Alias value
     * @param string $alias
     * @return \App\Library\ExactTarget\StructType\Link
     */
    public function setAlias($alias = null)
    {
        // validation for constraint: string
        if (!is_null($alias) && !is_string($alias)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($alias)), __LINE__);
        }
        $this->Alias = $alias;
        return $this;
    }
    /**
     * Get TotalClicks value
     * @return int|null
     */
    public function getTotalClicks()
    {
        return $this->TotalClicks;
    }
    /**
     * Set TotalClicks value
     * @param int $totalClicks
     * @return \App\Library\ExactTarget\StructType\Link
     */
    public function setTotalClicks($totalClicks = null)
    {
        // validation for constraint: int
        if (!is_null($totalClicks) && !is_numeric($totalClicks)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($totalClicks)), __LINE__);
        }
        $this->TotalClicks = $totalClicks;
        return $this;
    }
    /**
     * Get UniqueClicks value
     * @return int|null
     */
    public function getUniqueClicks()
    {
        return $this->UniqueClicks;
    }
    /**
     * Set UniqueClicks value
     * @param int $uniqueClicks
     * @return \App\Library\ExactTarget\StructType\Link
     */
    public function setUniqueClicks($uniqueClicks = null)
    {
        // validation for constraint: int
        if (!is_null($uniqueClicks) && !is_numeric($uniqueClicks)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($uniqueClicks)), __LINE__);
        }
        $this->UniqueClicks = $uniqueClicks;
        return $this;
    }
    /**
     * Get URL value
     * @return string|null
     */
    public function getURL()
    {
        return $this->URL;
    }
    /**
     * Set URL value
     * @param string $uRL
     * @return \App\Library\ExactTarget\StructType\Link
     */
    public function setURL($uRL = null)
    {
        // validation for constraint: string
        if (!is_null($uRL) && !is_string($uRL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uRL)), __LINE__);
        }
        $this->URL = $uRL;
        return $this;
    }
    /**
     * Get Subscribers value
     * @return \App\Library\ExactTarget\StructType\TrackingEvent[]|null
     */
    public function getSubscribers()
    {
        return $this->Subscribers;
    }
    /**
     * Set Subscribers value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\TrackingEvent[] $subscribers
     * @return \App\Library\ExactTarget\StructType\Link
     */
    public function setSubscribers(array $subscribers = array())
    {
        foreach ($subscribers as $linkSubscribersItem) {
            // validation for constraint: itemType
            if (!$linkSubscribersItem instanceof \App\Library\ExactTarget\StructType\TrackingEvent) {
                throw new \InvalidArgumentException(sprintf('The Subscribers property can only contain items of \App\Library\ExactTarget\StructType\TrackingEvent, "%s" given', is_object($linkSubscribersItem) ? get_class($linkSubscribersItem) : gettype($linkSubscribersItem)), __LINE__);
            }
        }
        $this->Subscribers = $subscribers;
        return $this;
    }
    /**
     * Add item to Subscribers value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\TrackingEvent $item
     * @return \App\Library\ExactTarget\StructType\Link
     */
    public function addToSubscribers(\App\Library\ExactTarget\StructType\TrackingEvent $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Library\ExactTarget\StructType\TrackingEvent) {
            throw new \InvalidArgumentException(sprintf('The Subscribers property can only contain items of \App\Library\ExactTarget\StructType\TrackingEvent, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Subscribers[] = $item;
        return $this;
    }
    /**
     * Get IDLong value
     * @return int|null
     */
    public function getIDLong()
    {
        return $this->IDLong;
    }
    /**
     * Set IDLong value
     * @param int $iDLong
     * @return \App\Library\ExactTarget\StructType\Link
     */
    public function setIDLong($iDLong = null)
    {
        // validation for constraint: int
        if (!is_null($iDLong) && !is_numeric($iDLong)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($iDLong)), __LINE__);
        }
        $this->IDLong = $iDLong;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\Link
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
