<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Layout StructType
 * @subpackage Structs
 */
class Layout extends APIObject
{
    /**
     * The LayoutName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LayoutName;
    /**
     * Constructor method for Layout
     * @uses Layout::setLayoutName()
     * @param string $layoutName
     */
    public function __construct($layoutName = null)
    {
        $this
            ->setLayoutName($layoutName);
    }
    /**
     * Get LayoutName value
     * @return string|null
     */
    public function getLayoutName()
    {
        return $this->LayoutName;
    }
    /**
     * Set LayoutName value
     * @param string $layoutName
     * @return \App\Library\ExactTarget\StructType\Layout
     */
    public function setLayoutName($layoutName = null)
    {
        // validation for constraint: string
        if (!is_null($layoutName) && !is_string($layoutName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($layoutName)), __LINE__);
        }
        $this->LayoutName = $layoutName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\Layout
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
