<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Items StructType
 * @subpackage Structs
 */
class Items extends AbstractStructBase
{
    /**
     * The Item
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\AttributeValueContainer[]
     */
    public $Item;
    /**
     * Constructor method for Items
     * @uses Items::setItem()
     * @param \App\Library\ExactTarget\StructType\AttributeValueContainer[] $item
     */
    public function __construct(array $item = array())
    {
        $this
            ->setItem($item);
    }
    /**
     * Get Item value
     * @return \App\Library\ExactTarget\StructType\AttributeValueContainer[]|null
     */
    public function getItem()
    {
        return $this->Item;
    }
    /**
     * Set Item value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\AttributeValueContainer[] $item
     * @return \App\Library\ExactTarget\StructType\Items
     */
    public function setItem(array $item = array())
    {
        foreach ($item as $itemsItemItem) {
            // validation for constraint: itemType
            if (!$itemsItemItem instanceof \App\Library\ExactTarget\StructType\AttributeValueContainer) {
                throw new \InvalidArgumentException(sprintf('The Item property can only contain items of \App\Library\ExactTarget\StructType\AttributeValueContainer, "%s" given', is_object($itemsItemItem) ? get_class($itemsItemItem) : gettype($itemsItemItem)), __LINE__);
            }
        }
        $this->Item = $item;
        return $this;
    }
    /**
     * Add item to Item value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\AttributeValueContainer $item
     * @return \App\Library\ExactTarget\StructType\Items
     */
    public function addToItem(\App\Library\ExactTarget\StructType\AttributeValueContainer $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Library\ExactTarget\StructType\AttributeValueContainer) {
            throw new \InvalidArgumentException(sprintf('The Item property can only contain items of \App\Library\ExactTarget\StructType\AttributeValueContainer, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Item[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\Items
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
