<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ImportResultsSummary StructType
 * @subpackage Structs
 */
class ImportResultsSummary extends APIObject
{
    /**
     * The ImportDefinitionCustomerKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ImportDefinitionCustomerKey;
    /**
     * The StartDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StartDate;
    /**
     * The EndDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EndDate;
    /**
     * The DestinationID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DestinationID;
    /**
     * The NumberSuccessful
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $NumberSuccessful;
    /**
     * The NumberDuplicated
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $NumberDuplicated;
    /**
     * The NumberErrors
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $NumberErrors;
    /**
     * The TotalRows
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $TotalRows;
    /**
     * The ImportType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ImportType;
    /**
     * The ImportStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ImportStatus;
    /**
     * The TaskResultID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $TaskResultID;
    /**
     * Constructor method for ImportResultsSummary
     * @uses ImportResultsSummary::setImportDefinitionCustomerKey()
     * @uses ImportResultsSummary::setStartDate()
     * @uses ImportResultsSummary::setEndDate()
     * @uses ImportResultsSummary::setDestinationID()
     * @uses ImportResultsSummary::setNumberSuccessful()
     * @uses ImportResultsSummary::setNumberDuplicated()
     * @uses ImportResultsSummary::setNumberErrors()
     * @uses ImportResultsSummary::setTotalRows()
     * @uses ImportResultsSummary::setImportType()
     * @uses ImportResultsSummary::setImportStatus()
     * @uses ImportResultsSummary::setTaskResultID()
     * @param string $importDefinitionCustomerKey
     * @param string $startDate
     * @param string $endDate
     * @param string $destinationID
     * @param int $numberSuccessful
     * @param int $numberDuplicated
     * @param int $numberErrors
     * @param int $totalRows
     * @param string $importType
     * @param string $importStatus
     * @param int $taskResultID
     */
    public function __construct($importDefinitionCustomerKey = null, $startDate = null, $endDate = null, $destinationID = null, $numberSuccessful = null, $numberDuplicated = null, $numberErrors = null, $totalRows = null, $importType = null, $importStatus = null, $taskResultID = null)
    {
        $this
            ->setImportDefinitionCustomerKey($importDefinitionCustomerKey)
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setDestinationID($destinationID)
            ->setNumberSuccessful($numberSuccessful)
            ->setNumberDuplicated($numberDuplicated)
            ->setNumberErrors($numberErrors)
            ->setTotalRows($totalRows)
            ->setImportType($importType)
            ->setImportStatus($importStatus)
            ->setTaskResultID($taskResultID);
    }
    /**
     * Get ImportDefinitionCustomerKey value
     * @return string|null
     */
    public function getImportDefinitionCustomerKey()
    {
        return $this->ImportDefinitionCustomerKey;
    }
    /**
     * Set ImportDefinitionCustomerKey value
     * @param string $importDefinitionCustomerKey
     * @return \App\Library\ExactTarget\StructType\ImportResultsSummary
     */
    public function setImportDefinitionCustomerKey($importDefinitionCustomerKey = null)
    {
        // validation for constraint: string
        if (!is_null($importDefinitionCustomerKey) && !is_string($importDefinitionCustomerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($importDefinitionCustomerKey)), __LINE__);
        }
        $this->ImportDefinitionCustomerKey = $importDefinitionCustomerKey;
        return $this;
    }
    /**
     * Get StartDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \App\Library\ExactTarget\StructType\ImportResultsSummary
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startDate)), __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get EndDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \App\Library\ExactTarget\StructType\ImportResultsSummary
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endDate)), __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Get DestinationID value
     * @return string|null
     */
    public function getDestinationID()
    {
        return $this->DestinationID;
    }
    /**
     * Set DestinationID value
     * @param string $destinationID
     * @return \App\Library\ExactTarget\StructType\ImportResultsSummary
     */
    public function setDestinationID($destinationID = null)
    {
        // validation for constraint: string
        if (!is_null($destinationID) && !is_string($destinationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($destinationID)), __LINE__);
        }
        $this->DestinationID = $destinationID;
        return $this;
    }
    /**
     * Get NumberSuccessful value
     * @return int|null
     */
    public function getNumberSuccessful()
    {
        return $this->NumberSuccessful;
    }
    /**
     * Set NumberSuccessful value
     * @param int $numberSuccessful
     * @return \App\Library\ExactTarget\StructType\ImportResultsSummary
     */
    public function setNumberSuccessful($numberSuccessful = null)
    {
        // validation for constraint: int
        if (!is_null($numberSuccessful) && !is_numeric($numberSuccessful)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numberSuccessful)), __LINE__);
        }
        $this->NumberSuccessful = $numberSuccessful;
        return $this;
    }
    /**
     * Get NumberDuplicated value
     * @return int|null
     */
    public function getNumberDuplicated()
    {
        return $this->NumberDuplicated;
    }
    /**
     * Set NumberDuplicated value
     * @param int $numberDuplicated
     * @return \App\Library\ExactTarget\StructType\ImportResultsSummary
     */
    public function setNumberDuplicated($numberDuplicated = null)
    {
        // validation for constraint: int
        if (!is_null($numberDuplicated) && !is_numeric($numberDuplicated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numberDuplicated)), __LINE__);
        }
        $this->NumberDuplicated = $numberDuplicated;
        return $this;
    }
    /**
     * Get NumberErrors value
     * @return int|null
     */
    public function getNumberErrors()
    {
        return $this->NumberErrors;
    }
    /**
     * Set NumberErrors value
     * @param int $numberErrors
     * @return \App\Library\ExactTarget\StructType\ImportResultsSummary
     */
    public function setNumberErrors($numberErrors = null)
    {
        // validation for constraint: int
        if (!is_null($numberErrors) && !is_numeric($numberErrors)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numberErrors)), __LINE__);
        }
        $this->NumberErrors = $numberErrors;
        return $this;
    }
    /**
     * Get TotalRows value
     * @return int|null
     */
    public function getTotalRows()
    {
        return $this->TotalRows;
    }
    /**
     * Set TotalRows value
     * @param int $totalRows
     * @return \App\Library\ExactTarget\StructType\ImportResultsSummary
     */
    public function setTotalRows($totalRows = null)
    {
        // validation for constraint: int
        if (!is_null($totalRows) && !is_numeric($totalRows)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($totalRows)), __LINE__);
        }
        $this->TotalRows = $totalRows;
        return $this;
    }
    /**
     * Get ImportType value
     * @return string|null
     */
    public function getImportType()
    {
        return $this->ImportType;
    }
    /**
     * Set ImportType value
     * @param string $importType
     * @return \App\Library\ExactTarget\StructType\ImportResultsSummary
     */
    public function setImportType($importType = null)
    {
        // validation for constraint: string
        if (!is_null($importType) && !is_string($importType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($importType)), __LINE__);
        }
        $this->ImportType = $importType;
        return $this;
    }
    /**
     * Get ImportStatus value
     * @return string|null
     */
    public function getImportStatus()
    {
        return $this->ImportStatus;
    }
    /**
     * Set ImportStatus value
     * @param string $importStatus
     * @return \App\Library\ExactTarget\StructType\ImportResultsSummary
     */
    public function setImportStatus($importStatus = null)
    {
        // validation for constraint: string
        if (!is_null($importStatus) && !is_string($importStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($importStatus)), __LINE__);
        }
        $this->ImportStatus = $importStatus;
        return $this;
    }
    /**
     * Get TaskResultID value
     * @return int|null
     */
    public function getTaskResultID()
    {
        return $this->TaskResultID;
    }
    /**
     * Set TaskResultID value
     * @param int $taskResultID
     * @return \App\Library\ExactTarget\StructType\ImportResultsSummary
     */
    public function setTaskResultID($taskResultID = null)
    {
        // validation for constraint: int
        if (!is_null($taskResultID) && !is_numeric($taskResultID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($taskResultID)), __LINE__);
        }
        $this->TaskResultID = $taskResultID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\ImportResultsSummary
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
