<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ImportFileDestination StructType
 * @subpackage Structs
 */
class ImportFileDestination extends APIObject
{
    /**
     * The TemplateCustomObject
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\DataExtension
     */
    public $TemplateCustomObject;
    /**
     * The FileTransferLocation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\FileTransferLocation
     */
    public $FileTransferLocation;
    /**
     * The FileSpec
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FileSpec;
    /**
     * The EncodingCodePage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $EncodingCodePage;
    /**
     * The HasColumnHeader
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $HasColumnHeader;
    /**
     * The FieldDelimiter
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FieldDelimiter;
    /**
     * The RowDelimiter
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RowDelimiter;
    /**
     * The NullValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NullValue;
    /**
     * The BooleanFormat
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BooleanFormat;
    /**
     * The DateTimeFormat
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DateTimeFormat;
    /**
     * The StringIdentifier
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StringIdentifier;
    /**
     * The EscapeSequence
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EscapeSequence;
    /**
     * Constructor method for ImportFileDestination
     * @uses ImportFileDestination::setTemplateCustomObject()
     * @uses ImportFileDestination::setFileTransferLocation()
     * @uses ImportFileDestination::setFileSpec()
     * @uses ImportFileDestination::setEncodingCodePage()
     * @uses ImportFileDestination::setHasColumnHeader()
     * @uses ImportFileDestination::setFieldDelimiter()
     * @uses ImportFileDestination::setRowDelimiter()
     * @uses ImportFileDestination::setNullValue()
     * @uses ImportFileDestination::setBooleanFormat()
     * @uses ImportFileDestination::setDateTimeFormat()
     * @uses ImportFileDestination::setStringIdentifier()
     * @uses ImportFileDestination::setEscapeSequence()
     * @param \App\Library\ExactTarget\StructType\DataExtension $templateCustomObject
     * @param \App\Library\ExactTarget\StructType\FileTransferLocation $fileTransferLocation
     * @param string $fileSpec
     * @param int $encodingCodePage
     * @param bool $hasColumnHeader
     * @param string $fieldDelimiter
     * @param string $rowDelimiter
     * @param string $nullValue
     * @param string $booleanFormat
     * @param string $dateTimeFormat
     * @param string $stringIdentifier
     * @param string $escapeSequence
     */
    public function __construct(\App\Library\ExactTarget\StructType\DataExtension $templateCustomObject = null, \App\Library\ExactTarget\StructType\FileTransferLocation $fileTransferLocation = null, $fileSpec = null, $encodingCodePage = null, $hasColumnHeader = null, $fieldDelimiter = null, $rowDelimiter = null, $nullValue = null, $booleanFormat = null, $dateTimeFormat = null, $stringIdentifier = null, $escapeSequence = null)
    {
        $this
            ->setTemplateCustomObject($templateCustomObject)
            ->setFileTransferLocation($fileTransferLocation)
            ->setFileSpec($fileSpec)
            ->setEncodingCodePage($encodingCodePage)
            ->setHasColumnHeader($hasColumnHeader)
            ->setFieldDelimiter($fieldDelimiter)
            ->setRowDelimiter($rowDelimiter)
            ->setNullValue($nullValue)
            ->setBooleanFormat($booleanFormat)
            ->setDateTimeFormat($dateTimeFormat)
            ->setStringIdentifier($stringIdentifier)
            ->setEscapeSequence($escapeSequence);
    }
    /**
     * Get TemplateCustomObject value
     * @return \App\Library\ExactTarget\StructType\DataExtension|null
     */
    public function getTemplateCustomObject()
    {
        return $this->TemplateCustomObject;
    }
    /**
     * Set TemplateCustomObject value
     * @param \App\Library\ExactTarget\StructType\DataExtension $templateCustomObject
     * @return \App\Library\ExactTarget\StructType\ImportFileDestination
     */
    public function setTemplateCustomObject(\App\Library\ExactTarget\StructType\DataExtension $templateCustomObject = null)
    {
        $this->TemplateCustomObject = $templateCustomObject;
        return $this;
    }
    /**
     * Get FileTransferLocation value
     * @return \App\Library\ExactTarget\StructType\FileTransferLocation|null
     */
    public function getFileTransferLocation()
    {
        return $this->FileTransferLocation;
    }
    /**
     * Set FileTransferLocation value
     * @param \App\Library\ExactTarget\StructType\FileTransferLocation $fileTransferLocation
     * @return \App\Library\ExactTarget\StructType\ImportFileDestination
     */
    public function setFileTransferLocation(\App\Library\ExactTarget\StructType\FileTransferLocation $fileTransferLocation = null)
    {
        $this->FileTransferLocation = $fileTransferLocation;
        return $this;
    }
    /**
     * Get FileSpec value
     * @return string|null
     */
    public function getFileSpec()
    {
        return $this->FileSpec;
    }
    /**
     * Set FileSpec value
     * @param string $fileSpec
     * @return \App\Library\ExactTarget\StructType\ImportFileDestination
     */
    public function setFileSpec($fileSpec = null)
    {
        // validation for constraint: string
        if (!is_null($fileSpec) && !is_string($fileSpec)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fileSpec)), __LINE__);
        }
        $this->FileSpec = $fileSpec;
        return $this;
    }
    /**
     * Get EncodingCodePage value
     * @return int|null
     */
    public function getEncodingCodePage()
    {
        return $this->EncodingCodePage;
    }
    /**
     * Set EncodingCodePage value
     * @param int $encodingCodePage
     * @return \App\Library\ExactTarget\StructType\ImportFileDestination
     */
    public function setEncodingCodePage($encodingCodePage = null)
    {
        // validation for constraint: int
        if (!is_null($encodingCodePage) && !is_numeric($encodingCodePage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($encodingCodePage)), __LINE__);
        }
        $this->EncodingCodePage = $encodingCodePage;
        return $this;
    }
    /**
     * Get HasColumnHeader value
     * @return bool|null
     */
    public function getHasColumnHeader()
    {
        return $this->HasColumnHeader;
    }
    /**
     * Set HasColumnHeader value
     * @param bool $hasColumnHeader
     * @return \App\Library\ExactTarget\StructType\ImportFileDestination
     */
    public function setHasColumnHeader($hasColumnHeader = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasColumnHeader) && !is_bool($hasColumnHeader)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($hasColumnHeader)), __LINE__);
        }
        $this->HasColumnHeader = $hasColumnHeader;
        return $this;
    }
    /**
     * Get FieldDelimiter value
     * @return string|null
     */
    public function getFieldDelimiter()
    {
        return $this->FieldDelimiter;
    }
    /**
     * Set FieldDelimiter value
     * @param string $fieldDelimiter
     * @return \App\Library\ExactTarget\StructType\ImportFileDestination
     */
    public function setFieldDelimiter($fieldDelimiter = null)
    {
        // validation for constraint: string
        if (!is_null($fieldDelimiter) && !is_string($fieldDelimiter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fieldDelimiter)), __LINE__);
        }
        $this->FieldDelimiter = $fieldDelimiter;
        return $this;
    }
    /**
     * Get RowDelimiter value
     * @return string|null
     */
    public function getRowDelimiter()
    {
        return $this->RowDelimiter;
    }
    /**
     * Set RowDelimiter value
     * @param string $rowDelimiter
     * @return \App\Library\ExactTarget\StructType\ImportFileDestination
     */
    public function setRowDelimiter($rowDelimiter = null)
    {
        // validation for constraint: string
        if (!is_null($rowDelimiter) && !is_string($rowDelimiter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rowDelimiter)), __LINE__);
        }
        $this->RowDelimiter = $rowDelimiter;
        return $this;
    }
    /**
     * Get NullValue value
     * @return string|null
     */
    public function getNullValue()
    {
        return $this->NullValue;
    }
    /**
     * Set NullValue value
     * @param string $nullValue
     * @return \App\Library\ExactTarget\StructType\ImportFileDestination
     */
    public function setNullValue($nullValue = null)
    {
        // validation for constraint: string
        if (!is_null($nullValue) && !is_string($nullValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nullValue)), __LINE__);
        }
        $this->NullValue = $nullValue;
        return $this;
    }
    /**
     * Get BooleanFormat value
     * @return string|null
     */
    public function getBooleanFormat()
    {
        return $this->BooleanFormat;
    }
    /**
     * Set BooleanFormat value
     * @param string $booleanFormat
     * @return \App\Library\ExactTarget\StructType\ImportFileDestination
     */
    public function setBooleanFormat($booleanFormat = null)
    {
        // validation for constraint: string
        if (!is_null($booleanFormat) && !is_string($booleanFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($booleanFormat)), __LINE__);
        }
        $this->BooleanFormat = $booleanFormat;
        return $this;
    }
    /**
     * Get DateTimeFormat value
     * @return string|null
     */
    public function getDateTimeFormat()
    {
        return $this->DateTimeFormat;
    }
    /**
     * Set DateTimeFormat value
     * @param string $dateTimeFormat
     * @return \App\Library\ExactTarget\StructType\ImportFileDestination
     */
    public function setDateTimeFormat($dateTimeFormat = null)
    {
        // validation for constraint: string
        if (!is_null($dateTimeFormat) && !is_string($dateTimeFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateTimeFormat)), __LINE__);
        }
        $this->DateTimeFormat = $dateTimeFormat;
        return $this;
    }
    /**
     * Get StringIdentifier value
     * @return string|null
     */
    public function getStringIdentifier()
    {
        return $this->StringIdentifier;
    }
    /**
     * Set StringIdentifier value
     * @param string $stringIdentifier
     * @return \App\Library\ExactTarget\StructType\ImportFileDestination
     */
    public function setStringIdentifier($stringIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($stringIdentifier) && !is_string($stringIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($stringIdentifier)), __LINE__);
        }
        $this->StringIdentifier = $stringIdentifier;
        return $this;
    }
    /**
     * Get EscapeSequence value
     * @return string|null
     */
    public function getEscapeSequence()
    {
        return $this->EscapeSequence;
    }
    /**
     * Set EscapeSequence value
     * @param string $escapeSequence
     * @return \App\Library\ExactTarget\StructType\ImportFileDestination
     */
    public function setEscapeSequence($escapeSequence = null)
    {
        // validation for constraint: string
        if (!is_null($escapeSequence) && !is_string($escapeSequence)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($escapeSequence)), __LINE__);
        }
        $this->EscapeSequence = $escapeSequence;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\ImportFileDestination
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
