<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FilterDefinition StructType
 * @subpackage Structs
 */
class FilterDefinition extends APIObject
{
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The DataSource
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\APIObject
     */
    public $DataSource;
    /**
     * The DataFilter
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\FilterPart
     */
    public $DataFilter;
    /**
     * The CategoryID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $CategoryID;
    /**
     * Constructor method for FilterDefinition
     * @uses FilterDefinition::setName()
     * @uses FilterDefinition::setDescription()
     * @uses FilterDefinition::setDataSource()
     * @uses FilterDefinition::setDataFilter()
     * @uses FilterDefinition::setCategoryID()
     * @param string $name
     * @param string $description
     * @param \App\Library\ExactTarget\StructType\APIObject $dataSource
     * @param \App\Library\ExactTarget\StructType\FilterPart $dataFilter
     * @param int $categoryID
     */
    public function __construct($name = null, $description = null, \App\Library\ExactTarget\StructType\APIObject $dataSource = null, \App\Library\ExactTarget\StructType\FilterPart $dataFilter = null, $categoryID = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setDataSource($dataSource)
            ->setDataFilter($dataFilter)
            ->setCategoryID($categoryID);
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \App\Library\ExactTarget\StructType\FilterDefinition
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \App\Library\ExactTarget\StructType\FilterDefinition
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get DataSource value
     * @return \App\Library\ExactTarget\StructType\APIObject|null
     */
    public function getDataSource()
    {
        return $this->DataSource;
    }
    /**
     * Set DataSource value
     * @param \App\Library\ExactTarget\StructType\APIObject $dataSource
     * @return \App\Library\ExactTarget\StructType\FilterDefinition
     */
    public function setDataSource(\App\Library\ExactTarget\StructType\APIObject $dataSource = null)
    {
        $this->DataSource = $dataSource;
        return $this;
    }
    /**
     * Get DataFilter value
     * @return \App\Library\ExactTarget\StructType\FilterPart|null
     */
    public function getDataFilter()
    {
        return $this->DataFilter;
    }
    /**
     * Set DataFilter value
     * @param \App\Library\ExactTarget\StructType\FilterPart $dataFilter
     * @return \App\Library\ExactTarget\StructType\FilterDefinition
     */
    public function setDataFilter(\App\Library\ExactTarget\StructType\FilterPart $dataFilter = null)
    {
        $this->DataFilter = $dataFilter;
        return $this;
    }
    /**
     * Get CategoryID value
     * @return int|null
     */
    public function getCategoryID()
    {
        return $this->CategoryID;
    }
    /**
     * Set CategoryID value
     * @param int $categoryID
     * @return \App\Library\ExactTarget\StructType\FilterDefinition
     */
    public function setCategoryID($categoryID = null)
    {
        // validation for constraint: int
        if (!is_null($categoryID) && !is_numeric($categoryID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($categoryID)), __LINE__);
        }
        $this->CategoryID = $categoryID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\FilterDefinition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
