<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Fields StructType
 * @subpackage Structs
 */
class Fields extends AbstractStructBase
{
    /**
     * The Field
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\DataExtensionField[]
     */
    public $Field;
    /**
     * Constructor method for Fields
     * @uses Fields::setField()
     * @param \App\Library\ExactTarget\StructType\DataExtensionField[] $field
     */
    public function __construct(array $field = array())
    {
        $this
            ->setField($field);
    }
    /**
     * Get Field value
     * @return \App\Library\ExactTarget\StructType\DataExtensionField[]|null
     */
    public function getField()
    {
        return $this->Field;
    }
    /**
     * Set Field value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\DataExtensionField[] $field
     * @return \App\Library\ExactTarget\StructType\Fields
     */
    public function setField(array $field = array())
    {
        foreach ($field as $fieldsFieldItem) {
            // validation for constraint: itemType
            if (!$fieldsFieldItem instanceof \App\Library\ExactTarget\StructType\DataExtensionField) {
                throw new \InvalidArgumentException(sprintf('The Field property can only contain items of \App\Library\ExactTarget\StructType\DataExtensionField, "%s" given', is_object($fieldsFieldItem) ? get_class($fieldsFieldItem) : gettype($fieldsFieldItem)), __LINE__);
            }
        }
        $this->Field = $field;
        return $this;
    }
    /**
     * Add item to Field value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\DataExtensionField $item
     * @return \App\Library\ExactTarget\StructType\Fields
     */
    public function addToField(\App\Library\ExactTarget\StructType\DataExtensionField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Library\ExactTarget\StructType\DataExtensionField) {
            throw new \InvalidArgumentException(sprintf('The Field property can only contain items of \App\Library\ExactTarget\StructType\DataExtensionField, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Field[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\Fields
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
