<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FieldMaps StructType
 * @subpackage Structs
 */
class FieldMaps extends AbstractStructBase
{
    /**
     * The FieldMap
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\FieldMap[]
     */
    public $FieldMap;
    /**
     * Constructor method for FieldMaps
     * @uses FieldMaps::setFieldMap()
     * @param \App\Library\ExactTarget\StructType\FieldMap[] $fieldMap
     */
    public function __construct(array $fieldMap = array())
    {
        $this
            ->setFieldMap($fieldMap);
    }
    /**
     * Get FieldMap value
     * @return \App\Library\ExactTarget\StructType\FieldMap[]|null
     */
    public function getFieldMap()
    {
        return $this->FieldMap;
    }
    /**
     * Set FieldMap value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\FieldMap[] $fieldMap
     * @return \App\Library\ExactTarget\StructType\FieldMaps
     */
    public function setFieldMap(array $fieldMap = array())
    {
        foreach ($fieldMap as $fieldMapsFieldMapItem) {
            // validation for constraint: itemType
            if (!$fieldMapsFieldMapItem instanceof \App\Library\ExactTarget\StructType\FieldMap) {
                throw new \InvalidArgumentException(sprintf('The FieldMap property can only contain items of \App\Library\ExactTarget\StructType\FieldMap, "%s" given', is_object($fieldMapsFieldMapItem) ? get_class($fieldMapsFieldMapItem) : gettype($fieldMapsFieldMapItem)), __LINE__);
            }
        }
        $this->FieldMap = $fieldMap;
        return $this;
    }
    /**
     * Add item to FieldMap value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\FieldMap $item
     * @return \App\Library\ExactTarget\StructType\FieldMaps
     */
    public function addToFieldMap(\App\Library\ExactTarget\StructType\FieldMap $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Library\ExactTarget\StructType\FieldMap) {
            throw new \InvalidArgumentException(sprintf('The FieldMap property can only contain items of \App\Library\ExactTarget\StructType\FieldMap, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->FieldMap[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\FieldMaps
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
