<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExtractRequest StructType
 * @subpackage Structs
 */
class ExtractRequest extends Request
{
    /**
     * The Client
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\ClientID
     */
    public $Client;
    /**
     * The ID
     * @var string
     */
    public $ID;
    /**
     * The Options
     * @var \App\Library\ExactTarget\StructType\ExtractOptions
     */
    public $Options;
    /**
     * The Parameters
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\Parameters
     */
    public $Parameters;
    /**
     * The Description
     * @var \App\Library\ExactTarget\StructType\ExtractDescription
     */
    public $Description;
    /**
     * The Definition
     * @var \App\Library\ExactTarget\StructType\ExtractDefinition
     */
    public $Definition;
    /**
     * Constructor method for ExtractRequest
     * @uses ExtractRequest::setClient()
     * @uses ExtractRequest::setID()
     * @uses ExtractRequest::setOptions()
     * @uses ExtractRequest::setParameters()
     * @uses ExtractRequest::setDescription()
     * @uses ExtractRequest::setDefinition()
     * @param \App\Library\ExactTarget\StructType\ClientID $client
     * @param string $iD
     * @param \App\Library\ExactTarget\StructType\ExtractOptions $options
     * @param \App\Library\ExactTarget\StructType\Parameters $parameters
     * @param \App\Library\ExactTarget\StructType\ExtractDescription $description
     * @param \App\Library\ExactTarget\StructType\ExtractDefinition $definition
     */
    public function __construct(\App\Library\ExactTarget\StructType\ClientID $client = null, $iD = null, \App\Library\ExactTarget\StructType\ExtractOptions $options = null, \App\Library\ExactTarget\StructType\Parameters $parameters = null, \App\Library\ExactTarget\StructType\ExtractDescription $description = null, \App\Library\ExactTarget\StructType\ExtractDefinition $definition = null)
    {
        $this
            ->setClient($client)
            ->setID($iD)
            ->setOptions($options)
            ->setParameters($parameters)
            ->setDescription($description)
            ->setDefinition($definition);
    }
    /**
     * Get Client value
     * @return \App\Library\ExactTarget\StructType\ClientID|null
     */
    public function getClient()
    {
        return $this->Client;
    }
    /**
     * Set Client value
     * @param \App\Library\ExactTarget\StructType\ClientID $client
     * @return \App\Library\ExactTarget\StructType\ExtractRequest
     */
    public function setClient(\App\Library\ExactTarget\StructType\ClientID $client = null)
    {
        $this->Client = $client;
        return $this;
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \App\Library\ExactTarget\StructType\ExtractRequest
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Options value
     * @return \App\Library\ExactTarget\StructType\ExtractOptions|null
     */
    public function getOptions()
    {
        return $this->Options;
    }
    /**
     * Set Options value
     * @param \App\Library\ExactTarget\StructType\ExtractOptions $options
     * @return \App\Library\ExactTarget\StructType\ExtractRequest
     */
    public function setOptions(\App\Library\ExactTarget\StructType\ExtractOptions $options = null)
    {
        $this->Options = $options;
        return $this;
    }
    /**
     * Get Parameters value
     * @return \App\Library\ExactTarget\StructType\Parameters|null
     */
    public function getParameters()
    {
        return $this->Parameters;
    }
    /**
     * Set Parameters value
     * @param \App\Library\ExactTarget\StructType\Parameters $parameters
     * @return \App\Library\ExactTarget\StructType\ExtractRequest
     */
    public function setParameters(\App\Library\ExactTarget\StructType\Parameters $parameters = null)
    {
        $this->Parameters = $parameters;
        return $this;
    }
    /**
     * Get Description value
     * @return \App\Library\ExactTarget\StructType\ExtractDescription|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param \App\Library\ExactTarget\StructType\ExtractDescription $description
     * @return \App\Library\ExactTarget\StructType\ExtractRequest
     */
    public function setDescription(\App\Library\ExactTarget\StructType\ExtractDescription $description = null)
    {
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Definition value
     * @return \App\Library\ExactTarget\StructType\ExtractDefinition|null
     */
    public function getDefinition()
    {
        return $this->Definition;
    }
    /**
     * Set Definition value
     * @param \App\Library\ExactTarget\StructType\ExtractDefinition $definition
     * @return \App\Library\ExactTarget\StructType\ExtractRequest
     */
    public function setDefinition(\App\Library\ExactTarget\StructType\ExtractDefinition $definition = null)
    {
        $this->Definition = $definition;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\ExtractRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
