<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExecuteResponse StructType
 * @subpackage Structs
 */
class ExecuteResponse extends AbstractStructBase
{
    /**
     * The StatusCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StatusCode;
    /**
     * The StatusMessage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StatusMessage;
    /**
     * The OrdinalID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $OrdinalID;
    /**
     * The Results
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\APIProperty[]
     */
    public $Results;
    /**
     * The ErrorCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $ErrorCode;
    /**
     * Constructor method for ExecuteResponse
     * @uses ExecuteResponse::setStatusCode()
     * @uses ExecuteResponse::setStatusMessage()
     * @uses ExecuteResponse::setOrdinalID()
     * @uses ExecuteResponse::setResults()
     * @uses ExecuteResponse::setErrorCode()
     * @param string $statusCode
     * @param string $statusMessage
     * @param int $ordinalID
     * @param \App\Library\ExactTarget\StructType\APIProperty[] $results
     * @param int $errorCode
     */
    public function __construct($statusCode = null, $statusMessage = null, $ordinalID = null, array $results = array(), $errorCode = null)
    {
        $this
            ->setStatusCode($statusCode)
            ->setStatusMessage($statusMessage)
            ->setOrdinalID($ordinalID)
            ->setResults($results)
            ->setErrorCode($errorCode);
    }
    /**
     * Get StatusCode value
     * @return string|null
     */
    public function getStatusCode()
    {
        return $this->StatusCode;
    }
    /**
     * Set StatusCode value
     * @param string $statusCode
     * @return \App\Library\ExactTarget\StructType\ExecuteResponse
     */
    public function setStatusCode($statusCode = null)
    {
        // validation for constraint: string
        if (!is_null($statusCode) && !is_string($statusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($statusCode)), __LINE__);
        }
        $this->StatusCode = $statusCode;
        return $this;
    }
    /**
     * Get StatusMessage value
     * @return string|null
     */
    public function getStatusMessage()
    {
        return $this->StatusMessage;
    }
    /**
     * Set StatusMessage value
     * @param string $statusMessage
     * @return \App\Library\ExactTarget\StructType\ExecuteResponse
     */
    public function setStatusMessage($statusMessage = null)
    {
        // validation for constraint: string
        if (!is_null($statusMessage) && !is_string($statusMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($statusMessage)), __LINE__);
        }
        $this->StatusMessage = $statusMessage;
        return $this;
    }
    /**
     * Get OrdinalID value
     * @return int|null
     */
    public function getOrdinalID()
    {
        return $this->OrdinalID;
    }
    /**
     * Set OrdinalID value
     * @param int $ordinalID
     * @return \App\Library\ExactTarget\StructType\ExecuteResponse
     */
    public function setOrdinalID($ordinalID = null)
    {
        // validation for constraint: int
        if (!is_null($ordinalID) && !is_numeric($ordinalID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ordinalID)), __LINE__);
        }
        $this->OrdinalID = $ordinalID;
        return $this;
    }
    /**
     * Get Results value
     * @return \App\Library\ExactTarget\StructType\APIProperty[]|null
     */
    public function getResults()
    {
        return $this->Results;
    }
    /**
     * Set Results value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\APIProperty[] $results
     * @return \App\Library\ExactTarget\StructType\ExecuteResponse
     */
    public function setResults(array $results = array())
    {
        foreach ($results as $executeResponseResultsItem) {
            // validation for constraint: itemType
            if (!$executeResponseResultsItem instanceof \App\Library\ExactTarget\StructType\APIProperty) {
                throw new \InvalidArgumentException(sprintf('The Results property can only contain items of \App\Library\ExactTarget\StructType\APIProperty, "%s" given', is_object($executeResponseResultsItem) ? get_class($executeResponseResultsItem) : gettype($executeResponseResultsItem)), __LINE__);
            }
        }
        $this->Results = $results;
        return $this;
    }
    /**
     * Add item to Results value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\APIProperty $item
     * @return \App\Library\ExactTarget\StructType\ExecuteResponse
     */
    public function addToResults(\App\Library\ExactTarget\StructType\APIProperty $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Library\ExactTarget\StructType\APIProperty) {
            throw new \InvalidArgumentException(sprintf('The Results property can only contain items of \App\Library\ExactTarget\StructType\APIProperty, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Results[] = $item;
        return $this;
    }
    /**
     * Get ErrorCode value
     * @return int|null
     */
    public function getErrorCode()
    {
        return $this->ErrorCode;
    }
    /**
     * Set ErrorCode value
     * @param int $errorCode
     * @return \App\Library\ExactTarget\StructType\ExecuteResponse
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: int
        if (!is_null($errorCode) && !is_numeric($errorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($errorCode)), __LINE__);
        }
        $this->ErrorCode = $errorCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\ExecuteResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
