<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExecuteRequest StructType
 * @subpackage Structs
 */
class ExecuteRequest extends AbstractStructBase
{
    /**
     * The Client
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\ClientID
     */
    public $Client;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Parameters
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\APIProperty[]
     */
    public $Parameters;
    /**
     * Constructor method for ExecuteRequest
     * @uses ExecuteRequest::setClient()
     * @uses ExecuteRequest::setName()
     * @uses ExecuteRequest::setParameters()
     * @param \App\Library\ExactTarget\StructType\ClientID $client
     * @param string $name
     * @param \App\Library\ExactTarget\StructType\APIProperty[] $parameters
     */
    public function __construct(\App\Library\ExactTarget\StructType\ClientID $client = null, $name = null, array $parameters = array())
    {
        $this
            ->setClient($client)
            ->setName($name)
            ->setParameters($parameters);
    }
    /**
     * Get Client value
     * @return \App\Library\ExactTarget\StructType\ClientID|null
     */
    public function getClient()
    {
        return $this->Client;
    }
    /**
     * Set Client value
     * @param \App\Library\ExactTarget\StructType\ClientID $client
     * @return \App\Library\ExactTarget\StructType\ExecuteRequest
     */
    public function setClient(\App\Library\ExactTarget\StructType\ClientID $client = null)
    {
        $this->Client = $client;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \App\Library\ExactTarget\StructType\ExecuteRequest
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Parameters value
     * @return \App\Library\ExactTarget\StructType\APIProperty[]|null
     */
    public function getParameters()
    {
        return $this->Parameters;
    }
    /**
     * Set Parameters value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\APIProperty[] $parameters
     * @return \App\Library\ExactTarget\StructType\ExecuteRequest
     */
    public function setParameters(array $parameters = array())
    {
        foreach ($parameters as $executeRequestParametersItem) {
            // validation for constraint: itemType
            if (!$executeRequestParametersItem instanceof \App\Library\ExactTarget\StructType\APIProperty) {
                throw new \InvalidArgumentException(sprintf('The Parameters property can only contain items of \App\Library\ExactTarget\StructType\APIProperty, "%s" given', is_object($executeRequestParametersItem) ? get_class($executeRequestParametersItem) : gettype($executeRequestParametersItem)), __LINE__);
            }
        }
        $this->Parameters = $parameters;
        return $this;
    }
    /**
     * Add item to Parameters value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\APIProperty $item
     * @return \App\Library\ExactTarget\StructType\ExecuteRequest
     */
    public function addToParameters(\App\Library\ExactTarget\StructType\APIProperty $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Library\ExactTarget\StructType\APIProperty) {
            throw new \InvalidArgumentException(sprintf('The Parameters property can only contain items of \App\Library\ExactTarget\StructType\APIProperty, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Parameters[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\ExecuteRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
