<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Email StructType
 * @subpackage Structs
 */
class Email extends APIObject
{
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Folder
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Folder;
    /**
     * The CategoryID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $CategoryID;
    /**
     * The HTMLBody
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $HTMLBody;
    /**
     * The TextBody
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TextBody;
    /**
     * The ContentAreas
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\ContentArea[]
     */
    public $ContentAreas;
    /**
     * The Subject
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Subject;
    /**
     * The IsActive
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IsActive;
    /**
     * The IsHTMLPaste
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IsHTMLPaste;
    /**
     * The ClonedFromID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $ClonedFromID;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * The EmailType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EmailType;
    /**
     * The CharacterSet
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CharacterSet;
    /**
     * The HasDynamicSubjectLine
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $HasDynamicSubjectLine;
    /**
     * The ContentCheckStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContentCheckStatus;
    /**
     * The SyncTextWithHTML
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $SyncTextWithHTML;
    /**
     * The PreHeader
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PreHeader;
    /**
     * The IsApproved
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IsApproved;
    /**
     * The __AdditionalEmailAttribute1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $__AdditionalEmailAttribute1;
    /**
     * The __AdditionalEmailAttribute2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $__AdditionalEmailAttribute2;
    /**
     * The __AdditionalEmailAttribute3
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $__AdditionalEmailAttribute3;
    /**
     * The __AdditionalEmailAttribute4
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $__AdditionalEmailAttribute4;
    /**
     * The __AdditionalEmailAttribute5
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $__AdditionalEmailAttribute5;
    /**
     * Constructor method for Email
     * @uses Email::setName()
     * @uses Email::setFolder()
     * @uses Email::setCategoryID()
     * @uses Email::setHTMLBody()
     * @uses Email::setTextBody()
     * @uses Email::setContentAreas()
     * @uses Email::setSubject()
     * @uses Email::setIsActive()
     * @uses Email::setIsHTMLPaste()
     * @uses Email::setClonedFromID()
     * @uses Email::setStatus()
     * @uses Email::setEmailType()
     * @uses Email::setCharacterSet()
     * @uses Email::setHasDynamicSubjectLine()
     * @uses Email::setContentCheckStatus()
     * @uses Email::setSyncTextWithHTML()
     * @uses Email::setPreHeader()
     * @uses Email::setIsApproved()
     * @uses Email::set__AdditionalEmailAttribute1()
     * @uses Email::set__AdditionalEmailAttribute2()
     * @uses Email::set__AdditionalEmailAttribute3()
     * @uses Email::set__AdditionalEmailAttribute4()
     * @uses Email::set__AdditionalEmailAttribute5()
     * @param string $name
     * @param string $folder
     * @param int $categoryID
     * @param string $hTMLBody
     * @param string $textBody
     * @param \App\Library\ExactTarget\StructType\ContentArea[] $contentAreas
     * @param string $subject
     * @param bool $isActive
     * @param bool $isHTMLPaste
     * @param int $clonedFromID
     * @param string $status
     * @param string $emailType
     * @param string $characterSet
     * @param bool $hasDynamicSubjectLine
     * @param string $contentCheckStatus
     * @param bool $syncTextWithHTML
     * @param string $preHeader
     * @param bool $isApproved
     * @param string $__AdditionalEmailAttribute1
     * @param string $__AdditionalEmailAttribute2
     * @param string $__AdditionalEmailAttribute3
     * @param string $__AdditionalEmailAttribute4
     * @param string $__AdditionalEmailAttribute5
     */
    public function __construct($name = null, $folder = null, $categoryID = null, $hTMLBody = null, $textBody = null, array $contentAreas = array(), $subject = null, $isActive = null, $isHTMLPaste = null, $clonedFromID = null, $status = null, $emailType = null, $characterSet = null, $hasDynamicSubjectLine = null, $contentCheckStatus = null, $syncTextWithHTML = null, $preHeader = null, $isApproved = null, $__AdditionalEmailAttribute1 = null, $__AdditionalEmailAttribute2 = null, $__AdditionalEmailAttribute3 = null, $__AdditionalEmailAttribute4 = null, $__AdditionalEmailAttribute5 = null)
    {
        $this
            ->setName($name)
            ->setFolder($folder)
            ->setCategoryID($categoryID)
            ->setHTMLBody($hTMLBody)
            ->setTextBody($textBody)
            ->setContentAreas($contentAreas)
            ->setSubject($subject)
            ->setIsActive($isActive)
            ->setIsHTMLPaste($isHTMLPaste)
            ->setClonedFromID($clonedFromID)
            ->setStatus($status)
            ->setEmailType($emailType)
            ->setCharacterSet($characterSet)
            ->setHasDynamicSubjectLine($hasDynamicSubjectLine)
            ->setContentCheckStatus($contentCheckStatus)
            ->setSyncTextWithHTML($syncTextWithHTML)
            ->setPreHeader($preHeader)
            ->setIsApproved($isApproved)
            ->set__AdditionalEmailAttribute1($__AdditionalEmailAttribute1)
            ->set__AdditionalEmailAttribute2($__AdditionalEmailAttribute2)
            ->set__AdditionalEmailAttribute3($__AdditionalEmailAttribute3)
            ->set__AdditionalEmailAttribute4($__AdditionalEmailAttribute4)
            ->set__AdditionalEmailAttribute5($__AdditionalEmailAttribute5);
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \App\Library\ExactTarget\StructType\Email
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Folder value
     * @return string|null
     */
    public function getFolder()
    {
        return $this->Folder;
    }
    /**
     * Set Folder value
     * @param string $folder
     * @return \App\Library\ExactTarget\StructType\Email
     */
    public function setFolder($folder = null)
    {
        // validation for constraint: string
        if (!is_null($folder) && !is_string($folder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($folder)), __LINE__);
        }
        $this->Folder = $folder;
        return $this;
    }
    /**
     * Get CategoryID value
     * @return int|null
     */
    public function getCategoryID()
    {
        return $this->CategoryID;
    }
    /**
     * Set CategoryID value
     * @param int $categoryID
     * @return \App\Library\ExactTarget\StructType\Email
     */
    public function setCategoryID($categoryID = null)
    {
        // validation for constraint: int
        if (!is_null($categoryID) && !is_numeric($categoryID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($categoryID)), __LINE__);
        }
        $this->CategoryID = $categoryID;
        return $this;
    }
    /**
     * Get HTMLBody value
     * @return string|null
     */
    public function getHTMLBody()
    {
        return $this->HTMLBody;
    }
    /**
     * Set HTMLBody value
     * @param string $hTMLBody
     * @return \App\Library\ExactTarget\StructType\Email
     */
    public function setHTMLBody($hTMLBody = null)
    {
        // validation for constraint: string
        if (!is_null($hTMLBody) && !is_string($hTMLBody)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hTMLBody)), __LINE__);
        }
        $this->HTMLBody = $hTMLBody;
        return $this;
    }
    /**
     * Get TextBody value
     * @return string|null
     */
    public function getTextBody()
    {
        return $this->TextBody;
    }
    /**
     * Set TextBody value
     * @param string $textBody
     * @return \App\Library\ExactTarget\StructType\Email
     */
    public function setTextBody($textBody = null)
    {
        // validation for constraint: string
        if (!is_null($textBody) && !is_string($textBody)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($textBody)), __LINE__);
        }
        $this->TextBody = $textBody;
        return $this;
    }
    /**
     * Get ContentAreas value
     * @return \App\Library\ExactTarget\StructType\ContentArea[]|null
     */
    public function getContentAreas()
    {
        return $this->ContentAreas;
    }
    /**
     * Set ContentAreas value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\ContentArea[] $contentAreas
     * @return \App\Library\ExactTarget\StructType\Email
     */
    public function setContentAreas(array $contentAreas = array())
    {
        foreach ($contentAreas as $emailContentAreasItem) {
            // validation for constraint: itemType
            if (!$emailContentAreasItem instanceof \App\Library\ExactTarget\StructType\ContentArea) {
                throw new \InvalidArgumentException(sprintf('The ContentAreas property can only contain items of \App\Library\ExactTarget\StructType\ContentArea, "%s" given', is_object($emailContentAreasItem) ? get_class($emailContentAreasItem) : gettype($emailContentAreasItem)), __LINE__);
            }
        }
        $this->ContentAreas = $contentAreas;
        return $this;
    }
    /**
     * Add item to ContentAreas value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\ContentArea $item
     * @return \App\Library\ExactTarget\StructType\Email
     */
    public function addToContentAreas(\App\Library\ExactTarget\StructType\ContentArea $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Library\ExactTarget\StructType\ContentArea) {
            throw new \InvalidArgumentException(sprintf('The ContentAreas property can only contain items of \App\Library\ExactTarget\StructType\ContentArea, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ContentAreas[] = $item;
        return $this;
    }
    /**
     * Get Subject value
     * @return string|null
     */
    public function getSubject()
    {
        return $this->Subject;
    }
    /**
     * Set Subject value
     * @param string $subject
     * @return \App\Library\ExactTarget\StructType\Email
     */
    public function setSubject($subject = null)
    {
        // validation for constraint: string
        if (!is_null($subject) && !is_string($subject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subject)), __LINE__);
        }
        $this->Subject = $subject;
        return $this;
    }
    /**
     * Get IsActive value
     * @return bool|null
     */
    public function getIsActive()
    {
        return $this->IsActive;
    }
    /**
     * Set IsActive value
     * @param bool $isActive
     * @return \App\Library\ExactTarget\StructType\Email
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isActive)), __LINE__);
        }
        $this->IsActive = $isActive;
        return $this;
    }
    /**
     * Get IsHTMLPaste value
     * @return bool|null
     */
    public function getIsHTMLPaste()
    {
        return $this->IsHTMLPaste;
    }
    /**
     * Set IsHTMLPaste value
     * @param bool $isHTMLPaste
     * @return \App\Library\ExactTarget\StructType\Email
     */
    public function setIsHTMLPaste($isHTMLPaste = null)
    {
        // validation for constraint: boolean
        if (!is_null($isHTMLPaste) && !is_bool($isHTMLPaste)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isHTMLPaste)), __LINE__);
        }
        $this->IsHTMLPaste = $isHTMLPaste;
        return $this;
    }
    /**
     * Get ClonedFromID value
     * @return int|null
     */
    public function getClonedFromID()
    {
        return $this->ClonedFromID;
    }
    /**
     * Set ClonedFromID value
     * @param int $clonedFromID
     * @return \App\Library\ExactTarget\StructType\Email
     */
    public function setClonedFromID($clonedFromID = null)
    {
        // validation for constraint: int
        if (!is_null($clonedFromID) && !is_numeric($clonedFromID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($clonedFromID)), __LINE__);
        }
        $this->ClonedFromID = $clonedFromID;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \App\Library\ExactTarget\StructType\Email
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get EmailType value
     * @return string|null
     */
    public function getEmailType()
    {
        return $this->EmailType;
    }
    /**
     * Set EmailType value
     * @param string $emailType
     * @return \App\Library\ExactTarget\StructType\Email
     */
    public function setEmailType($emailType = null)
    {
        // validation for constraint: string
        if (!is_null($emailType) && !is_string($emailType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($emailType)), __LINE__);
        }
        $this->EmailType = $emailType;
        return $this;
    }
    /**
     * Get CharacterSet value
     * @return string|null
     */
    public function getCharacterSet()
    {
        return $this->CharacterSet;
    }
    /**
     * Set CharacterSet value
     * @param string $characterSet
     * @return \App\Library\ExactTarget\StructType\Email
     */
    public function setCharacterSet($characterSet = null)
    {
        // validation for constraint: string
        if (!is_null($characterSet) && !is_string($characterSet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($characterSet)), __LINE__);
        }
        $this->CharacterSet = $characterSet;
        return $this;
    }
    /**
     * Get HasDynamicSubjectLine value
     * @return bool|null
     */
    public function getHasDynamicSubjectLine()
    {
        return $this->HasDynamicSubjectLine;
    }
    /**
     * Set HasDynamicSubjectLine value
     * @param bool $hasDynamicSubjectLine
     * @return \App\Library\ExactTarget\StructType\Email
     */
    public function setHasDynamicSubjectLine($hasDynamicSubjectLine = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasDynamicSubjectLine) && !is_bool($hasDynamicSubjectLine)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($hasDynamicSubjectLine)), __LINE__);
        }
        $this->HasDynamicSubjectLine = $hasDynamicSubjectLine;
        return $this;
    }
    /**
     * Get ContentCheckStatus value
     * @return string|null
     */
    public function getContentCheckStatus()
    {
        return $this->ContentCheckStatus;
    }
    /**
     * Set ContentCheckStatus value
     * @param string $contentCheckStatus
     * @return \App\Library\ExactTarget\StructType\Email
     */
    public function setContentCheckStatus($contentCheckStatus = null)
    {
        // validation for constraint: string
        if (!is_null($contentCheckStatus) && !is_string($contentCheckStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contentCheckStatus)), __LINE__);
        }
        $this->ContentCheckStatus = $contentCheckStatus;
        return $this;
    }
    /**
     * Get SyncTextWithHTML value
     * @return bool|null
     */
    public function getSyncTextWithHTML()
    {
        return $this->SyncTextWithHTML;
    }
    /**
     * Set SyncTextWithHTML value
     * @param bool $syncTextWithHTML
     * @return \App\Library\ExactTarget\StructType\Email
     */
    public function setSyncTextWithHTML($syncTextWithHTML = null)
    {
        // validation for constraint: boolean
        if (!is_null($syncTextWithHTML) && !is_bool($syncTextWithHTML)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($syncTextWithHTML)), __LINE__);
        }
        $this->SyncTextWithHTML = $syncTextWithHTML;
        return $this;
    }
    /**
     * Get PreHeader value
     * @return string|null
     */
    public function getPreHeader()
    {
        return $this->PreHeader;
    }
    /**
     * Set PreHeader value
     * @param string $preHeader
     * @return \App\Library\ExactTarget\StructType\Email
     */
    public function setPreHeader($preHeader = null)
    {
        // validation for constraint: string
        if (!is_null($preHeader) && !is_string($preHeader)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($preHeader)), __LINE__);
        }
        $this->PreHeader = $preHeader;
        return $this;
    }
    /**
     * Get IsApproved value
     * @return bool|null
     */
    public function getIsApproved()
    {
        return $this->IsApproved;
    }
    /**
     * Set IsApproved value
     * @param bool $isApproved
     * @return \App\Library\ExactTarget\StructType\Email
     */
    public function setIsApproved($isApproved = null)
    {
        // validation for constraint: boolean
        if (!is_null($isApproved) && !is_bool($isApproved)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isApproved)), __LINE__);
        }
        $this->IsApproved = $isApproved;
        return $this;
    }
    /**
     * Get __AdditionalEmailAttribute1 value
     * @return string|null
     */
    public function get__AdditionalEmailAttribute1()
    {
        return $this->__AdditionalEmailAttribute1;
    }
    /**
     * Set __AdditionalEmailAttribute1 value
     * @param string $__AdditionalEmailAttribute1
     * @return \App\Library\ExactTarget\StructType\Email
     */
    public function set__AdditionalEmailAttribute1($__AdditionalEmailAttribute1 = null)
    {
        // validation for constraint: string
        if (!is_null($__AdditionalEmailAttribute1) && !is_string($__AdditionalEmailAttribute1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($__AdditionalEmailAttribute1)), __LINE__);
        }
        $this->__AdditionalEmailAttribute1 = $__AdditionalEmailAttribute1;
        return $this;
    }
    /**
     * Get __AdditionalEmailAttribute2 value
     * @return string|null
     */
    public function get__AdditionalEmailAttribute2()
    {
        return $this->__AdditionalEmailAttribute2;
    }
    /**
     * Set __AdditionalEmailAttribute2 value
     * @param string $__AdditionalEmailAttribute2
     * @return \App\Library\ExactTarget\StructType\Email
     */
    public function set__AdditionalEmailAttribute2($__AdditionalEmailAttribute2 = null)
    {
        // validation for constraint: string
        if (!is_null($__AdditionalEmailAttribute2) && !is_string($__AdditionalEmailAttribute2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($__AdditionalEmailAttribute2)), __LINE__);
        }
        $this->__AdditionalEmailAttribute2 = $__AdditionalEmailAttribute2;
        return $this;
    }
    /**
     * Get __AdditionalEmailAttribute3 value
     * @return string|null
     */
    public function get__AdditionalEmailAttribute3()
    {
        return $this->__AdditionalEmailAttribute3;
    }
    /**
     * Set __AdditionalEmailAttribute3 value
     * @param string $__AdditionalEmailAttribute3
     * @return \App\Library\ExactTarget\StructType\Email
     */
    public function set__AdditionalEmailAttribute3($__AdditionalEmailAttribute3 = null)
    {
        // validation for constraint: string
        if (!is_null($__AdditionalEmailAttribute3) && !is_string($__AdditionalEmailAttribute3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($__AdditionalEmailAttribute3)), __LINE__);
        }
        $this->__AdditionalEmailAttribute3 = $__AdditionalEmailAttribute3;
        return $this;
    }
    /**
     * Get __AdditionalEmailAttribute4 value
     * @return string|null
     */
    public function get__AdditionalEmailAttribute4()
    {
        return $this->__AdditionalEmailAttribute4;
    }
    /**
     * Set __AdditionalEmailAttribute4 value
     * @param string $__AdditionalEmailAttribute4
     * @return \App\Library\ExactTarget\StructType\Email
     */
    public function set__AdditionalEmailAttribute4($__AdditionalEmailAttribute4 = null)
    {
        // validation for constraint: string
        if (!is_null($__AdditionalEmailAttribute4) && !is_string($__AdditionalEmailAttribute4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($__AdditionalEmailAttribute4)), __LINE__);
        }
        $this->__AdditionalEmailAttribute4 = $__AdditionalEmailAttribute4;
        return $this;
    }
    /**
     * Get __AdditionalEmailAttribute5 value
     * @return string|null
     */
    public function get__AdditionalEmailAttribute5()
    {
        return $this->__AdditionalEmailAttribute5;
    }
    /**
     * Set __AdditionalEmailAttribute5 value
     * @param string $__AdditionalEmailAttribute5
     * @return \App\Library\ExactTarget\StructType\Email
     */
    public function set__AdditionalEmailAttribute5($__AdditionalEmailAttribute5 = null)
    {
        // validation for constraint: string
        if (!is_null($__AdditionalEmailAttribute5) && !is_string($__AdditionalEmailAttribute5)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($__AdditionalEmailAttribute5)), __LINE__);
        }
        $this->__AdditionalEmailAttribute5 = $__AdditionalEmailAttribute5;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\Email
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
