<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DirectoryTenant StructType
 * @subpackage Structs
 */
class DirectoryTenant extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerId;
    /**
     * The TenantOrgId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TenantOrgId;
    /**
     * The TenantUri
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TenantUri;
    /**
     * The TenantType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TenantType;
    /**
     * The CustomDomain
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomDomain;
    /**
     * The TenantPublicKeysUri
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TenantPublicKeysUri;
    /**
     * The TenantName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TenantName;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The PublicKeys
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\JsonWebKey[]
     */
    public $PublicKeys;
    /**
     * Constructor method for DirectoryTenant
     * @uses DirectoryTenant::setCustomerId()
     * @uses DirectoryTenant::setTenantOrgId()
     * @uses DirectoryTenant::setTenantUri()
     * @uses DirectoryTenant::setTenantType()
     * @uses DirectoryTenant::setCustomDomain()
     * @uses DirectoryTenant::setTenantPublicKeysUri()
     * @uses DirectoryTenant::setTenantName()
     * @uses DirectoryTenant::setDescription()
     * @uses DirectoryTenant::setPublicKeys()
     * @param string $customerId
     * @param string $tenantOrgId
     * @param string $tenantUri
     * @param string $tenantType
     * @param string $customDomain
     * @param string $tenantPublicKeysUri
     * @param string $tenantName
     * @param string $description
     * @param \App\Library\ExactTarget\StructType\JsonWebKey[] $publicKeys
     */
    public function __construct($customerId = null, $tenantOrgId = null, $tenantUri = null, $tenantType = null, $customDomain = null, $tenantPublicKeysUri = null, $tenantName = null, $description = null, array $publicKeys = array())
    {
        $this
            ->setCustomerId($customerId)
            ->setTenantOrgId($tenantOrgId)
            ->setTenantUri($tenantUri)
            ->setTenantType($tenantType)
            ->setCustomDomain($customDomain)
            ->setTenantPublicKeysUri($tenantPublicKeysUri)
            ->setTenantName($tenantName)
            ->setDescription($description)
            ->setPublicKeys($publicKeys);
    }
    /**
     * Get CustomerId value
     * @return string|null
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param string $customerId
     * @return \App\Library\ExactTarget\StructType\DirectoryTenant
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: string
        if (!is_null($customerId) && !is_string($customerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get TenantOrgId value
     * @return string|null
     */
    public function getTenantOrgId()
    {
        return $this->TenantOrgId;
    }
    /**
     * Set TenantOrgId value
     * @param string $tenantOrgId
     * @return \App\Library\ExactTarget\StructType\DirectoryTenant
     */
    public function setTenantOrgId($tenantOrgId = null)
    {
        // validation for constraint: string
        if (!is_null($tenantOrgId) && !is_string($tenantOrgId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tenantOrgId)), __LINE__);
        }
        $this->TenantOrgId = $tenantOrgId;
        return $this;
    }
    /**
     * Get TenantUri value
     * @return string|null
     */
    public function getTenantUri()
    {
        return $this->TenantUri;
    }
    /**
     * Set TenantUri value
     * @param string $tenantUri
     * @return \App\Library\ExactTarget\StructType\DirectoryTenant
     */
    public function setTenantUri($tenantUri = null)
    {
        // validation for constraint: string
        if (!is_null($tenantUri) && !is_string($tenantUri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tenantUri)), __LINE__);
        }
        $this->TenantUri = $tenantUri;
        return $this;
    }
    /**
     * Get TenantType value
     * @return string|null
     */
    public function getTenantType()
    {
        return $this->TenantType;
    }
    /**
     * Set TenantType value
     * @param string $tenantType
     * @return \App\Library\ExactTarget\StructType\DirectoryTenant
     */
    public function setTenantType($tenantType = null)
    {
        // validation for constraint: string
        if (!is_null($tenantType) && !is_string($tenantType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tenantType)), __LINE__);
        }
        $this->TenantType = $tenantType;
        return $this;
    }
    /**
     * Get CustomDomain value
     * @return string|null
     */
    public function getCustomDomain()
    {
        return $this->CustomDomain;
    }
    /**
     * Set CustomDomain value
     * @param string $customDomain
     * @return \App\Library\ExactTarget\StructType\DirectoryTenant
     */
    public function setCustomDomain($customDomain = null)
    {
        // validation for constraint: string
        if (!is_null($customDomain) && !is_string($customDomain)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customDomain)), __LINE__);
        }
        $this->CustomDomain = $customDomain;
        return $this;
    }
    /**
     * Get TenantPublicKeysUri value
     * @return string|null
     */
    public function getTenantPublicKeysUri()
    {
        return $this->TenantPublicKeysUri;
    }
    /**
     * Set TenantPublicKeysUri value
     * @param string $tenantPublicKeysUri
     * @return \App\Library\ExactTarget\StructType\DirectoryTenant
     */
    public function setTenantPublicKeysUri($tenantPublicKeysUri = null)
    {
        // validation for constraint: string
        if (!is_null($tenantPublicKeysUri) && !is_string($tenantPublicKeysUri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tenantPublicKeysUri)), __LINE__);
        }
        $this->TenantPublicKeysUri = $tenantPublicKeysUri;
        return $this;
    }
    /**
     * Get TenantName value
     * @return string|null
     */
    public function getTenantName()
    {
        return $this->TenantName;
    }
    /**
     * Set TenantName value
     * @param string $tenantName
     * @return \App\Library\ExactTarget\StructType\DirectoryTenant
     */
    public function setTenantName($tenantName = null)
    {
        // validation for constraint: string
        if (!is_null($tenantName) && !is_string($tenantName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tenantName)), __LINE__);
        }
        $this->TenantName = $tenantName;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \App\Library\ExactTarget\StructType\DirectoryTenant
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get PublicKeys value
     * @return \App\Library\ExactTarget\StructType\JsonWebKey[]|null
     */
    public function getPublicKeys()
    {
        return $this->PublicKeys;
    }
    /**
     * Set PublicKeys value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\JsonWebKey[] $publicKeys
     * @return \App\Library\ExactTarget\StructType\DirectoryTenant
     */
    public function setPublicKeys(array $publicKeys = array())
    {
        foreach ($publicKeys as $directoryTenantPublicKeysItem) {
            // validation for constraint: itemType
            if (!$directoryTenantPublicKeysItem instanceof \App\Library\ExactTarget\StructType\JsonWebKey) {
                throw new \InvalidArgumentException(sprintf('The PublicKeys property can only contain items of \App\Library\ExactTarget\StructType\JsonWebKey, "%s" given', is_object($directoryTenantPublicKeysItem) ? get_class($directoryTenantPublicKeysItem) : gettype($directoryTenantPublicKeysItem)), __LINE__);
            }
        }
        $this->PublicKeys = $publicKeys;
        return $this;
    }
    /**
     * Add item to PublicKeys value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\JsonWebKey $item
     * @return \App\Library\ExactTarget\StructType\DirectoryTenant
     */
    public function addToPublicKeys(\App\Library\ExactTarget\StructType\JsonWebKey $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Library\ExactTarget\StructType\JsonWebKey) {
            throw new \InvalidArgumentException(sprintf('The PublicKeys property can only contain items of \App\Library\ExactTarget\StructType\JsonWebKey, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PublicKeys[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\DirectoryTenant
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
