<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeliveryProfile StructType
 * Meta informations extracted from the WSDL
 * - type: tns:DeliveryProfile
 * @subpackage Structs
 */
class DeliveryProfile extends APIObject
{
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The SourceAddressType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SourceAddressType;
    /**
     * The PrivateIP
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\PrivateIP
     */
    public $PrivateIP;
    /**
     * The DomainType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DomainType;
    /**
     * The PrivateDomain
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\PrivateDomain
     */
    public $PrivateDomain;
    /**
     * The HeaderSalutationSource
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $HeaderSalutationSource;
    /**
     * The HeaderContentArea
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\ContentArea
     */
    public $HeaderContentArea;
    /**
     * The FooterSalutationSource
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FooterSalutationSource;
    /**
     * The FooterContentArea
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\ContentArea
     */
    public $FooterContentArea;
    /**
     * The SubscriberLevelPrivateDomain
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $SubscriberLevelPrivateDomain;
    /**
     * The SMIMESignatureCertificate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\Certificate
     */
    public $SMIMESignatureCertificate;
    /**
     * The PrivateDomainSet
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\PrivateDomainSet
     */
    public $PrivateDomainSet;
    /**
     * Constructor method for DeliveryProfile
     * @uses DeliveryProfile::setName()
     * @uses DeliveryProfile::setDescription()
     * @uses DeliveryProfile::setSourceAddressType()
     * @uses DeliveryProfile::setPrivateIP()
     * @uses DeliveryProfile::setDomainType()
     * @uses DeliveryProfile::setPrivateDomain()
     * @uses DeliveryProfile::setHeaderSalutationSource()
     * @uses DeliveryProfile::setHeaderContentArea()
     * @uses DeliveryProfile::setFooterSalutationSource()
     * @uses DeliveryProfile::setFooterContentArea()
     * @uses DeliveryProfile::setSubscriberLevelPrivateDomain()
     * @uses DeliveryProfile::setSMIMESignatureCertificate()
     * @uses DeliveryProfile::setPrivateDomainSet()
     * @param string $name
     * @param string $description
     * @param string $sourceAddressType
     * @param \App\Library\ExactTarget\StructType\PrivateIP $privateIP
     * @param string $domainType
     * @param \App\Library\ExactTarget\StructType\PrivateDomain $privateDomain
     * @param string $headerSalutationSource
     * @param \App\Library\ExactTarget\StructType\ContentArea $headerContentArea
     * @param string $footerSalutationSource
     * @param \App\Library\ExactTarget\StructType\ContentArea $footerContentArea
     * @param bool $subscriberLevelPrivateDomain
     * @param \App\Library\ExactTarget\StructType\Certificate $sMIMESignatureCertificate
     * @param \App\Library\ExactTarget\StructType\PrivateDomainSet $privateDomainSet
     */
    public function __construct($name = null, $description = null, $sourceAddressType = null, \App\Library\ExactTarget\StructType\PrivateIP $privateIP = null, $domainType = null, \App\Library\ExactTarget\StructType\PrivateDomain $privateDomain = null, $headerSalutationSource = null, \App\Library\ExactTarget\StructType\ContentArea $headerContentArea = null, $footerSalutationSource = null, \App\Library\ExactTarget\StructType\ContentArea $footerContentArea = null, $subscriberLevelPrivateDomain = null, \App\Library\ExactTarget\StructType\Certificate $sMIMESignatureCertificate = null, \App\Library\ExactTarget\StructType\PrivateDomainSet $privateDomainSet = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setSourceAddressType($sourceAddressType)
            ->setPrivateIP($privateIP)
            ->setDomainType($domainType)
            ->setPrivateDomain($privateDomain)
            ->setHeaderSalutationSource($headerSalutationSource)
            ->setHeaderContentArea($headerContentArea)
            ->setFooterSalutationSource($footerSalutationSource)
            ->setFooterContentArea($footerContentArea)
            ->setSubscriberLevelPrivateDomain($subscriberLevelPrivateDomain)
            ->setSMIMESignatureCertificate($sMIMESignatureCertificate)
            ->setPrivateDomainSet($privateDomainSet);
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \App\Library\ExactTarget\StructType\DeliveryProfile
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \App\Library\ExactTarget\StructType\DeliveryProfile
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get SourceAddressType value
     * @return string|null
     */
    public function getSourceAddressType()
    {
        return $this->SourceAddressType;
    }
    /**
     * Set SourceAddressType value
     * @uses \App\Library\ExactTarget\EnumType\DeliveryProfileSourceAddressTypeEnum::valueIsValid()
     * @uses \App\Library\ExactTarget\EnumType\DeliveryProfileSourceAddressTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sourceAddressType
     * @return \App\Library\ExactTarget\StructType\DeliveryProfile
     */
    public function setSourceAddressType($sourceAddressType = null)
    {
        // validation for constraint: enumeration
        if (!\App\Library\ExactTarget\EnumType\DeliveryProfileSourceAddressTypeEnum::valueIsValid($sourceAddressType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $sourceAddressType, implode(', ', \App\Library\ExactTarget\EnumType\DeliveryProfileSourceAddressTypeEnum::getValidValues())), __LINE__);
        }
        $this->SourceAddressType = $sourceAddressType;
        return $this;
    }
    /**
     * Get PrivateIP value
     * @return \App\Library\ExactTarget\StructType\PrivateIP|null
     */
    public function getPrivateIP()
    {
        return $this->PrivateIP;
    }
    /**
     * Set PrivateIP value
     * @param \App\Library\ExactTarget\StructType\PrivateIP $privateIP
     * @return \App\Library\ExactTarget\StructType\DeliveryProfile
     */
    public function setPrivateIP(\App\Library\ExactTarget\StructType\PrivateIP $privateIP = null)
    {
        $this->PrivateIP = $privateIP;
        return $this;
    }
    /**
     * Get DomainType value
     * @return string|null
     */
    public function getDomainType()
    {
        return $this->DomainType;
    }
    /**
     * Set DomainType value
     * @uses \App\Library\ExactTarget\EnumType\DeliveryProfileDomainTypeEnum::valueIsValid()
     * @uses \App\Library\ExactTarget\EnumType\DeliveryProfileDomainTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $domainType
     * @return \App\Library\ExactTarget\StructType\DeliveryProfile
     */
    public function setDomainType($domainType = null)
    {
        // validation for constraint: enumeration
        if (!\App\Library\ExactTarget\EnumType\DeliveryProfileDomainTypeEnum::valueIsValid($domainType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $domainType, implode(', ', \App\Library\ExactTarget\EnumType\DeliveryProfileDomainTypeEnum::getValidValues())), __LINE__);
        }
        $this->DomainType = $domainType;
        return $this;
    }
    /**
     * Get PrivateDomain value
     * @return \App\Library\ExactTarget\StructType\PrivateDomain|null
     */
    public function getPrivateDomain()
    {
        return $this->PrivateDomain;
    }
    /**
     * Set PrivateDomain value
     * @param \App\Library\ExactTarget\StructType\PrivateDomain $privateDomain
     * @return \App\Library\ExactTarget\StructType\DeliveryProfile
     */
    public function setPrivateDomain(\App\Library\ExactTarget\StructType\PrivateDomain $privateDomain = null)
    {
        $this->PrivateDomain = $privateDomain;
        return $this;
    }
    /**
     * Get HeaderSalutationSource value
     * @return string|null
     */
    public function getHeaderSalutationSource()
    {
        return $this->HeaderSalutationSource;
    }
    /**
     * Set HeaderSalutationSource value
     * @uses \App\Library\ExactTarget\EnumType\SalutationSourceEnum::valueIsValid()
     * @uses \App\Library\ExactTarget\EnumType\SalutationSourceEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $headerSalutationSource
     * @return \App\Library\ExactTarget\StructType\DeliveryProfile
     */
    public function setHeaderSalutationSource($headerSalutationSource = null)
    {
        // validation for constraint: enumeration
        if (!\App\Library\ExactTarget\EnumType\SalutationSourceEnum::valueIsValid($headerSalutationSource)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $headerSalutationSource, implode(', ', \App\Library\ExactTarget\EnumType\SalutationSourceEnum::getValidValues())), __LINE__);
        }
        $this->HeaderSalutationSource = $headerSalutationSource;
        return $this;
    }
    /**
     * Get HeaderContentArea value
     * @return \App\Library\ExactTarget\StructType\ContentArea|null
     */
    public function getHeaderContentArea()
    {
        return $this->HeaderContentArea;
    }
    /**
     * Set HeaderContentArea value
     * @param \App\Library\ExactTarget\StructType\ContentArea $headerContentArea
     * @return \App\Library\ExactTarget\StructType\DeliveryProfile
     */
    public function setHeaderContentArea(\App\Library\ExactTarget\StructType\ContentArea $headerContentArea = null)
    {
        $this->HeaderContentArea = $headerContentArea;
        return $this;
    }
    /**
     * Get FooterSalutationSource value
     * @return string|null
     */
    public function getFooterSalutationSource()
    {
        return $this->FooterSalutationSource;
    }
    /**
     * Set FooterSalutationSource value
     * @uses \App\Library\ExactTarget\EnumType\SalutationSourceEnum::valueIsValid()
     * @uses \App\Library\ExactTarget\EnumType\SalutationSourceEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $footerSalutationSource
     * @return \App\Library\ExactTarget\StructType\DeliveryProfile
     */
    public function setFooterSalutationSource($footerSalutationSource = null)
    {
        // validation for constraint: enumeration
        if (!\App\Library\ExactTarget\EnumType\SalutationSourceEnum::valueIsValid($footerSalutationSource)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $footerSalutationSource, implode(', ', \App\Library\ExactTarget\EnumType\SalutationSourceEnum::getValidValues())), __LINE__);
        }
        $this->FooterSalutationSource = $footerSalutationSource;
        return $this;
    }
    /**
     * Get FooterContentArea value
     * @return \App\Library\ExactTarget\StructType\ContentArea|null
     */
    public function getFooterContentArea()
    {
        return $this->FooterContentArea;
    }
    /**
     * Set FooterContentArea value
     * @param \App\Library\ExactTarget\StructType\ContentArea $footerContentArea
     * @return \App\Library\ExactTarget\StructType\DeliveryProfile
     */
    public function setFooterContentArea(\App\Library\ExactTarget\StructType\ContentArea $footerContentArea = null)
    {
        $this->FooterContentArea = $footerContentArea;
        return $this;
    }
    /**
     * Get SubscriberLevelPrivateDomain value
     * @return bool|null
     */
    public function getSubscriberLevelPrivateDomain()
    {
        return $this->SubscriberLevelPrivateDomain;
    }
    /**
     * Set SubscriberLevelPrivateDomain value
     * @param bool $subscriberLevelPrivateDomain
     * @return \App\Library\ExactTarget\StructType\DeliveryProfile
     */
    public function setSubscriberLevelPrivateDomain($subscriberLevelPrivateDomain = null)
    {
        // validation for constraint: boolean
        if (!is_null($subscriberLevelPrivateDomain) && !is_bool($subscriberLevelPrivateDomain)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($subscriberLevelPrivateDomain)), __LINE__);
        }
        $this->SubscriberLevelPrivateDomain = $subscriberLevelPrivateDomain;
        return $this;
    }
    /**
     * Get SMIMESignatureCertificate value
     * @return \App\Library\ExactTarget\StructType\Certificate|null
     */
    public function getSMIMESignatureCertificate()
    {
        return $this->SMIMESignatureCertificate;
    }
    /**
     * Set SMIMESignatureCertificate value
     * @param \App\Library\ExactTarget\StructType\Certificate $sMIMESignatureCertificate
     * @return \App\Library\ExactTarget\StructType\DeliveryProfile
     */
    public function setSMIMESignatureCertificate(\App\Library\ExactTarget\StructType\Certificate $sMIMESignatureCertificate = null)
    {
        $this->SMIMESignatureCertificate = $sMIMESignatureCertificate;
        return $this;
    }
    /**
     * Get PrivateDomainSet value
     * @return \App\Library\ExactTarget\StructType\PrivateDomainSet|null
     */
    public function getPrivateDomainSet()
    {
        return $this->PrivateDomainSet;
    }
    /**
     * Set PrivateDomainSet value
     * @param \App\Library\ExactTarget\StructType\PrivateDomainSet $privateDomainSet
     * @return \App\Library\ExactTarget\StructType\DeliveryProfile
     */
    public function setPrivateDomainSet(\App\Library\ExactTarget\StructType\PrivateDomainSet $privateDomainSet = null)
    {
        $this->PrivateDomainSet = $privateDomainSet;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\DeliveryProfile
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
