<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeleteRequest StructType
 * @subpackage Structs
 */
class DeleteRequest extends AbstractStructBase
{
    /**
     * The Options
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \App\Library\ExactTarget\StructType\DeleteOptions
     */
    public $Options;
    /**
     * The Objects
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \App\Library\ExactTarget\StructType\APIObject[]
     */
    public $Objects;
    /**
     * Constructor method for DeleteRequest
     * @uses DeleteRequest::setOptions()
     * @uses DeleteRequest::setObjects()
     * @param \App\Library\ExactTarget\StructType\DeleteOptions $options
     * @param \App\Library\ExactTarget\StructType\APIObject[] $objects
     */
    public function __construct(\App\Library\ExactTarget\StructType\DeleteOptions $options = null, array $objects = array())
    {
        $this
            ->setOptions($options)
            ->setObjects($objects);
    }
    /**
     * Get Options value
     * @return \App\Library\ExactTarget\StructType\DeleteOptions
     */
    public function getOptions()
    {
        return $this->Options;
    }
    /**
     * Set Options value
     * @param \App\Library\ExactTarget\StructType\DeleteOptions $options
     * @return \App\Library\ExactTarget\StructType\DeleteRequest
     */
    public function setOptions(\App\Library\ExactTarget\StructType\DeleteOptions $options = null)
    {
        $this->Options = $options;
        return $this;
    }
    /**
     * Get Objects value
     * @return \App\Library\ExactTarget\StructType\APIObject[]
     */
    public function getObjects()
    {
        return $this->Objects;
    }
    /**
     * Set Objects value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\APIObject[] $objects
     * @return \App\Library\ExactTarget\StructType\DeleteRequest
     */
    public function setObjects(array $objects = array())
    {
        foreach ($objects as $deleteRequestObjectsItem) {
            // validation for constraint: itemType
            if (!$deleteRequestObjectsItem instanceof \App\Library\ExactTarget\StructType\APIObject) {
                throw new \InvalidArgumentException(sprintf('The Objects property can only contain items of \App\Library\ExactTarget\StructType\APIObject, "%s" given', is_object($deleteRequestObjectsItem) ? get_class($deleteRequestObjectsItem) : gettype($deleteRequestObjectsItem)), __LINE__);
            }
        }
        $this->Objects = $objects;
        return $this;
    }
    /**
     * Add item to Objects value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\APIObject $item
     * @return \App\Library\ExactTarget\StructType\DeleteRequest
     */
    public function addToObjects(\App\Library\ExactTarget\StructType\APIObject $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Library\ExactTarget\StructType\APIObject) {
            throw new \InvalidArgumentException(sprintf('The Objects property can only contain items of \App\Library\ExactTarget\StructType\APIObject, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Objects[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\DeleteRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
