<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DataExtensionObject StructType
 * @subpackage Structs
 */
class DataExtensionObject extends ObjectExtension
{
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Keys
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\Keys
     */
    public $Keys;
    /**
     * Constructor method for DataExtensionObject
     * @uses DataExtensionObject::setName()
     * @uses DataExtensionObject::setKeys()
     * @param string $name
     * @param \App\Library\ExactTarget\StructType\Keys $keys
     */
    public function __construct($name = null, \App\Library\ExactTarget\StructType\Keys $keys = null)
    {
        $this
            ->setName($name)
            ->setKeys($keys);
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \App\Library\ExactTarget\StructType\DataExtensionObject
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Keys value
     * @return \App\Library\ExactTarget\StructType\Keys|null
     */
    public function getKeys()
    {
        return $this->Keys;
    }
    /**
     * Set Keys value
     * @param \App\Library\ExactTarget\StructType\Keys $keys
     * @return \App\Library\ExactTarget\StructType\DataExtensionObject
     */
    public function setKeys(\App\Library\ExactTarget\StructType\Keys $keys = null)
    {
        $this->Keys = $keys;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\DataExtensionObject
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
