<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DataExtension StructType
 * @subpackage Structs
 */
class DataExtension extends APIObject
{
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The IsSendable
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IsSendable;
    /**
     * The IsTestable
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IsTestable;
    /**
     * The SendableDataExtensionField
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\DataExtensionField
     */
    public $SendableDataExtensionField;
    /**
     * The SendableSubscriberField
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\Attribute
     */
    public $SendableSubscriberField;
    /**
     * The Template
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\DataExtensionTemplate
     */
    public $Template;
    /**
     * The DataRetentionPeriodLength
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $DataRetentionPeriodLength;
    /**
     * The DataRetentionPeriodUnitOfMeasure
     * Meta informations extracted from the WSDL
     * - documentation: Deprecated. Use DataRetentionPeriod instead.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $DataRetentionPeriodUnitOfMeasure;
    /**
     * The RowBasedRetention
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $RowBasedRetention;
    /**
     * The ResetRetentionPeriodOnImport
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $ResetRetentionPeriodOnImport;
    /**
     * The DeleteAtEndOfRetentionPeriod
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $DeleteAtEndOfRetentionPeriod;
    /**
     * The RetainUntil
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RetainUntil;
    /**
     * The Fields
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\Fields
     */
    public $Fields;
    /**
     * The DataRetentionPeriod
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DataRetentionPeriod;
    /**
     * The CategoryID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $CategoryID;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * Constructor method for DataExtension
     * @uses DataExtension::setName()
     * @uses DataExtension::setDescription()
     * @uses DataExtension::setIsSendable()
     * @uses DataExtension::setIsTestable()
     * @uses DataExtension::setSendableDataExtensionField()
     * @uses DataExtension::setSendableSubscriberField()
     * @uses DataExtension::setTemplate()
     * @uses DataExtension::setDataRetentionPeriodLength()
     * @uses DataExtension::setDataRetentionPeriodUnitOfMeasure()
     * @uses DataExtension::setRowBasedRetention()
     * @uses DataExtension::setResetRetentionPeriodOnImport()
     * @uses DataExtension::setDeleteAtEndOfRetentionPeriod()
     * @uses DataExtension::setRetainUntil()
     * @uses DataExtension::setFields()
     * @uses DataExtension::setDataRetentionPeriod()
     * @uses DataExtension::setCategoryID()
     * @uses DataExtension::setStatus()
     * @param string $name
     * @param string $description
     * @param bool $isSendable
     * @param bool $isTestable
     * @param \App\Library\ExactTarget\StructType\DataExtensionField $sendableDataExtensionField
     * @param \App\Library\ExactTarget\StructType\Attribute $sendableSubscriberField
     * @param \App\Library\ExactTarget\StructType\DataExtensionTemplate $template
     * @param int $dataRetentionPeriodLength
     * @param int $dataRetentionPeriodUnitOfMeasure
     * @param bool $rowBasedRetention
     * @param bool $resetRetentionPeriodOnImport
     * @param bool $deleteAtEndOfRetentionPeriod
     * @param string $retainUntil
     * @param \App\Library\ExactTarget\StructType\Fields $fields
     * @param string $dataRetentionPeriod
     * @param int $categoryID
     * @param string $status
     */
    public function __construct($name = null, $description = null, $isSendable = null, $isTestable = null, \App\Library\ExactTarget\StructType\DataExtensionField $sendableDataExtensionField = null, \App\Library\ExactTarget\StructType\Attribute $sendableSubscriberField = null, \App\Library\ExactTarget\StructType\DataExtensionTemplate $template = null, $dataRetentionPeriodLength = null, $dataRetentionPeriodUnitOfMeasure = null, $rowBasedRetention = null, $resetRetentionPeriodOnImport = null, $deleteAtEndOfRetentionPeriod = null, $retainUntil = null, \App\Library\ExactTarget\StructType\Fields $fields = null, $dataRetentionPeriod = null, $categoryID = null, $status = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setIsSendable($isSendable)
            ->setIsTestable($isTestable)
            ->setSendableDataExtensionField($sendableDataExtensionField)
            ->setSendableSubscriberField($sendableSubscriberField)
            ->setTemplate($template)
            ->setDataRetentionPeriodLength($dataRetentionPeriodLength)
            ->setDataRetentionPeriodUnitOfMeasure($dataRetentionPeriodUnitOfMeasure)
            ->setRowBasedRetention($rowBasedRetention)
            ->setResetRetentionPeriodOnImport($resetRetentionPeriodOnImport)
            ->setDeleteAtEndOfRetentionPeriod($deleteAtEndOfRetentionPeriod)
            ->setRetainUntil($retainUntil)
            ->setFields($fields)
            ->setDataRetentionPeriod($dataRetentionPeriod)
            ->setCategoryID($categoryID)
            ->setStatus($status);
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \App\Library\ExactTarget\StructType\DataExtension
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \App\Library\ExactTarget\StructType\DataExtension
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get IsSendable value
     * @return bool|null
     */
    public function getIsSendable()
    {
        return $this->IsSendable;
    }
    /**
     * Set IsSendable value
     * @param bool $isSendable
     * @return \App\Library\ExactTarget\StructType\DataExtension
     */
    public function setIsSendable($isSendable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSendable) && !is_bool($isSendable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isSendable)), __LINE__);
        }
        $this->IsSendable = $isSendable;
        return $this;
    }
    /**
     * Get IsTestable value
     * @return bool|null
     */
    public function getIsTestable()
    {
        return $this->IsTestable;
    }
    /**
     * Set IsTestable value
     * @param bool $isTestable
     * @return \App\Library\ExactTarget\StructType\DataExtension
     */
    public function setIsTestable($isTestable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTestable) && !is_bool($isTestable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isTestable)), __LINE__);
        }
        $this->IsTestable = $isTestable;
        return $this;
    }
    /**
     * Get SendableDataExtensionField value
     * @return \App\Library\ExactTarget\StructType\DataExtensionField|null
     */
    public function getSendableDataExtensionField()
    {
        return $this->SendableDataExtensionField;
    }
    /**
     * Set SendableDataExtensionField value
     * @param \App\Library\ExactTarget\StructType\DataExtensionField $sendableDataExtensionField
     * @return \App\Library\ExactTarget\StructType\DataExtension
     */
    public function setSendableDataExtensionField(\App\Library\ExactTarget\StructType\DataExtensionField $sendableDataExtensionField = null)
    {
        $this->SendableDataExtensionField = $sendableDataExtensionField;
        return $this;
    }
    /**
     * Get SendableSubscriberField value
     * @return \App\Library\ExactTarget\StructType\Attribute|null
     */
    public function getSendableSubscriberField()
    {
        return $this->SendableSubscriberField;
    }
    /**
     * Set SendableSubscriberField value
     * @param \App\Library\ExactTarget\StructType\Attribute $sendableSubscriberField
     * @return \App\Library\ExactTarget\StructType\DataExtension
     */
    public function setSendableSubscriberField(\App\Library\ExactTarget\StructType\Attribute $sendableSubscriberField = null)
    {
        $this->SendableSubscriberField = $sendableSubscriberField;
        return $this;
    }
    /**
     * Get Template value
     * @return \App\Library\ExactTarget\StructType\DataExtensionTemplate|null
     */
    public function getTemplate()
    {
        return $this->Template;
    }
    /**
     * Set Template value
     * @param \App\Library\ExactTarget\StructType\DataExtensionTemplate $template
     * @return \App\Library\ExactTarget\StructType\DataExtension
     */
    public function setTemplate(\App\Library\ExactTarget\StructType\DataExtensionTemplate $template = null)
    {
        $this->Template = $template;
        return $this;
    }
    /**
     * Get DataRetentionPeriodLength value
     * @return int|null
     */
    public function getDataRetentionPeriodLength()
    {
        return $this->DataRetentionPeriodLength;
    }
    /**
     * Set DataRetentionPeriodLength value
     * @param int $dataRetentionPeriodLength
     * @return \App\Library\ExactTarget\StructType\DataExtension
     */
    public function setDataRetentionPeriodLength($dataRetentionPeriodLength = null)
    {
        // validation for constraint: int
        if (!is_null($dataRetentionPeriodLength) && !is_numeric($dataRetentionPeriodLength)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($dataRetentionPeriodLength)), __LINE__);
        }
        $this->DataRetentionPeriodLength = $dataRetentionPeriodLength;
        return $this;
    }
    /**
     * Get DataRetentionPeriodUnitOfMeasure value
     * @return int|null
     */
    public function getDataRetentionPeriodUnitOfMeasure()
    {
        return $this->DataRetentionPeriodUnitOfMeasure;
    }
    /**
     * Set DataRetentionPeriodUnitOfMeasure value
     * @param int $dataRetentionPeriodUnitOfMeasure
     * @return \App\Library\ExactTarget\StructType\DataExtension
     */
    public function setDataRetentionPeriodUnitOfMeasure($dataRetentionPeriodUnitOfMeasure = null)
    {
        // validation for constraint: int
        if (!is_null($dataRetentionPeriodUnitOfMeasure) && !is_numeric($dataRetentionPeriodUnitOfMeasure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($dataRetentionPeriodUnitOfMeasure)), __LINE__);
        }
        $this->DataRetentionPeriodUnitOfMeasure = $dataRetentionPeriodUnitOfMeasure;
        return $this;
    }
    /**
     * Get RowBasedRetention value
     * @return bool|null
     */
    public function getRowBasedRetention()
    {
        return $this->RowBasedRetention;
    }
    /**
     * Set RowBasedRetention value
     * @param bool $rowBasedRetention
     * @return \App\Library\ExactTarget\StructType\DataExtension
     */
    public function setRowBasedRetention($rowBasedRetention = null)
    {
        // validation for constraint: boolean
        if (!is_null($rowBasedRetention) && !is_bool($rowBasedRetention)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($rowBasedRetention)), __LINE__);
        }
        $this->RowBasedRetention = $rowBasedRetention;
        return $this;
    }
    /**
     * Get ResetRetentionPeriodOnImport value
     * @return bool|null
     */
    public function getResetRetentionPeriodOnImport()
    {
        return $this->ResetRetentionPeriodOnImport;
    }
    /**
     * Set ResetRetentionPeriodOnImport value
     * @param bool $resetRetentionPeriodOnImport
     * @return \App\Library\ExactTarget\StructType\DataExtension
     */
    public function setResetRetentionPeriodOnImport($resetRetentionPeriodOnImport = null)
    {
        // validation for constraint: boolean
        if (!is_null($resetRetentionPeriodOnImport) && !is_bool($resetRetentionPeriodOnImport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($resetRetentionPeriodOnImport)), __LINE__);
        }
        $this->ResetRetentionPeriodOnImport = $resetRetentionPeriodOnImport;
        return $this;
    }
    /**
     * Get DeleteAtEndOfRetentionPeriod value
     * @return bool|null
     */
    public function getDeleteAtEndOfRetentionPeriod()
    {
        return $this->DeleteAtEndOfRetentionPeriod;
    }
    /**
     * Set DeleteAtEndOfRetentionPeriod value
     * @param bool $deleteAtEndOfRetentionPeriod
     * @return \App\Library\ExactTarget\StructType\DataExtension
     */
    public function setDeleteAtEndOfRetentionPeriod($deleteAtEndOfRetentionPeriod = null)
    {
        // validation for constraint: boolean
        if (!is_null($deleteAtEndOfRetentionPeriod) && !is_bool($deleteAtEndOfRetentionPeriod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($deleteAtEndOfRetentionPeriod)), __LINE__);
        }
        $this->DeleteAtEndOfRetentionPeriod = $deleteAtEndOfRetentionPeriod;
        return $this;
    }
    /**
     * Get RetainUntil value
     * @return string|null
     */
    public function getRetainUntil()
    {
        return $this->RetainUntil;
    }
    /**
     * Set RetainUntil value
     * @param string $retainUntil
     * @return \App\Library\ExactTarget\StructType\DataExtension
     */
    public function setRetainUntil($retainUntil = null)
    {
        // validation for constraint: string
        if (!is_null($retainUntil) && !is_string($retainUntil)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($retainUntil)), __LINE__);
        }
        $this->RetainUntil = $retainUntil;
        return $this;
    }
    /**
     * Get Fields value
     * @return \App\Library\ExactTarget\StructType\Fields|null
     */
    public function getFields()
    {
        return $this->Fields;
    }
    /**
     * Set Fields value
     * @param \App\Library\ExactTarget\StructType\Fields $fields
     * @return \App\Library\ExactTarget\StructType\DataExtension
     */
    public function setFields(\App\Library\ExactTarget\StructType\Fields $fields = null)
    {
        $this->Fields = $fields;
        return $this;
    }
    /**
     * Get DataRetentionPeriod value
     * @return string|null
     */
    public function getDataRetentionPeriod()
    {
        return $this->DataRetentionPeriod;
    }
    /**
     * Set DataRetentionPeriod value
     * @uses \App\Library\ExactTarget\EnumType\DateTimeUnitOfMeasure::valueIsValid()
     * @uses \App\Library\ExactTarget\EnumType\DateTimeUnitOfMeasure::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dataRetentionPeriod
     * @return \App\Library\ExactTarget\StructType\DataExtension
     */
    public function setDataRetentionPeriod($dataRetentionPeriod = null)
    {
        // validation for constraint: enumeration
        if (!\App\Library\ExactTarget\EnumType\DateTimeUnitOfMeasure::valueIsValid($dataRetentionPeriod)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $dataRetentionPeriod, implode(', ', \App\Library\ExactTarget\EnumType\DateTimeUnitOfMeasure::getValidValues())), __LINE__);
        }
        $this->DataRetentionPeriod = $dataRetentionPeriod;
        return $this;
    }
    /**
     * Get CategoryID value
     * @return int|null
     */
    public function getCategoryID()
    {
        return $this->CategoryID;
    }
    /**
     * Set CategoryID value
     * @param int $categoryID
     * @return \App\Library\ExactTarget\StructType\DataExtension
     */
    public function setCategoryID($categoryID = null)
    {
        // validation for constraint: int
        if (!is_null($categoryID) && !is_numeric($categoryID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($categoryID)), __LINE__);
        }
        $this->CategoryID = $categoryID;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \App\Library\ExactTarget\StructType\DataExtension
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\DataExtension
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
