<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Data StructType
 * @subpackage Structs
 */
class Data extends AbstractStructBase
{
    /**
     * The AttributeSet
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\AttributeSet[]
     */
    public $AttributeSet;
    /**
     * Constructor method for Data
     * @uses Data::setAttributeSet()
     * @param \App\Library\ExactTarget\StructType\AttributeSet[] $attributeSet
     */
    public function __construct(array $attributeSet = array())
    {
        $this
            ->setAttributeSet($attributeSet);
    }
    /**
     * Get AttributeSet value
     * @return \App\Library\ExactTarget\StructType\AttributeSet[]|null
     */
    public function getAttributeSet()
    {
        return $this->AttributeSet;
    }
    /**
     * Set AttributeSet value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\AttributeSet[] $attributeSet
     * @return \App\Library\ExactTarget\StructType\Data
     */
    public function setAttributeSet(array $attributeSet = array())
    {
        foreach ($attributeSet as $dataAttributeSetItem) {
            // validation for constraint: itemType
            if (!$dataAttributeSetItem instanceof \App\Library\ExactTarget\StructType\AttributeSet) {
                throw new \InvalidArgumentException(sprintf('The AttributeSet property can only contain items of \App\Library\ExactTarget\StructType\AttributeSet, "%s" given', is_object($dataAttributeSetItem) ? get_class($dataAttributeSetItem) : gettype($dataAttributeSetItem)), __LINE__);
            }
        }
        $this->AttributeSet = $attributeSet;
        return $this;
    }
    /**
     * Add item to AttributeSet value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\AttributeSet $item
     * @return \App\Library\ExactTarget\StructType\Data
     */
    public function addToAttributeSet(\App\Library\ExactTarget\StructType\AttributeSet $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Library\ExactTarget\StructType\AttributeSet) {
            throw new \InvalidArgumentException(sprintf('The AttributeSet property can only contain items of \App\Library\ExactTarget\StructType\AttributeSet, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AttributeSet[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\Data
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
