<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DailyRecurrence StructType
 * Meta informations extracted from the WSDL
 * - type: tns:DailyRecurrence
 * @subpackage Structs
 */
class DailyRecurrence extends Recurrence
{
    /**
     * The DailyRecurrencePatternType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DailyRecurrencePatternType;
    /**
     * The DayInterval
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $DayInterval;
    /**
     * Constructor method for DailyRecurrence
     * @uses DailyRecurrence::setDailyRecurrencePatternType()
     * @uses DailyRecurrence::setDayInterval()
     * @param string $dailyRecurrencePatternType
     * @param int $dayInterval
     */
    public function __construct($dailyRecurrencePatternType = null, $dayInterval = null)
    {
        $this
            ->setDailyRecurrencePatternType($dailyRecurrencePatternType)
            ->setDayInterval($dayInterval);
    }
    /**
     * Get DailyRecurrencePatternType value
     * @return string|null
     */
    public function getDailyRecurrencePatternType()
    {
        return $this->DailyRecurrencePatternType;
    }
    /**
     * Set DailyRecurrencePatternType value
     * @uses \App\Library\ExactTarget\EnumType\DailyRecurrencePatternTypeEnum::valueIsValid()
     * @uses \App\Library\ExactTarget\EnumType\DailyRecurrencePatternTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dailyRecurrencePatternType
     * @return \App\Library\ExactTarget\StructType\DailyRecurrence
     */
    public function setDailyRecurrencePatternType($dailyRecurrencePatternType = null)
    {
        // validation for constraint: enumeration
        if (!\App\Library\ExactTarget\EnumType\DailyRecurrencePatternTypeEnum::valueIsValid($dailyRecurrencePatternType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $dailyRecurrencePatternType, implode(', ', \App\Library\ExactTarget\EnumType\DailyRecurrencePatternTypeEnum::getValidValues())), __LINE__);
        }
        $this->DailyRecurrencePatternType = $dailyRecurrencePatternType;
        return $this;
    }
    /**
     * Get DayInterval value
     * @return int|null
     */
    public function getDayInterval()
    {
        return $this->DayInterval;
    }
    /**
     * Set DayInterval value
     * @param int $dayInterval
     * @return \App\Library\ExactTarget\StructType\DailyRecurrence
     */
    public function setDayInterval($dayInterval = null)
    {
        // validation for constraint: int
        if (!is_null($dayInterval) && !is_numeric($dayInterval)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($dayInterval)), __LINE__);
        }
        $this->DayInterval = $dayInterval;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\DailyRecurrence
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
