<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateResult StructType
 * @subpackage Structs
 */
class CreateResult extends Result
{
    /**
     * The NewID
     * @var int
     */
    public $NewID;
    /**
     * The NewObjectID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NewObjectID;
    /**
     * The PartnerKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PartnerKey;
    /**
     * The Object
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\APIObject
     */
    public $Object;
    /**
     * The CreateResults
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\CreateResult[]
     */
    public $CreateResults;
    /**
     * The ParentPropertyName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ParentPropertyName;
    /**
     * Constructor method for CreateResult
     * @uses CreateResult::setNewID()
     * @uses CreateResult::setNewObjectID()
     * @uses CreateResult::setPartnerKey()
     * @uses CreateResult::setObject()
     * @uses CreateResult::setCreateResults()
     * @uses CreateResult::setParentPropertyName()
     * @param int $newID
     * @param string $newObjectID
     * @param string $partnerKey
     * @param \App\Library\ExactTarget\StructType\APIObject $object
     * @param \App\Library\ExactTarget\StructType\CreateResult[] $createResults
     * @param string $parentPropertyName
     */
    public function __construct($newID = null, $newObjectID = null, $partnerKey = null, \App\Library\ExactTarget\StructType\APIObject $object = null, array $createResults = array(), $parentPropertyName = null)
    {
        $this
            ->setNewID($newID)
            ->setNewObjectID($newObjectID)
            ->setPartnerKey($partnerKey)
            ->setObject($object)
            ->setCreateResults($createResults)
            ->setParentPropertyName($parentPropertyName);
    }
    /**
     * Get NewID value
     * @return int|null
     */
    public function getNewID()
    {
        return $this->NewID;
    }
    /**
     * Set NewID value
     * @param int $newID
     * @return \App\Library\ExactTarget\StructType\CreateResult
     */
    public function setNewID($newID = null)
    {
        // validation for constraint: int
        if (!is_null($newID) && !is_numeric($newID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($newID)), __LINE__);
        }
        $this->NewID = $newID;
        return $this;
    }
    /**
     * Get NewObjectID value
     * @return string|null
     */
    public function getNewObjectID()
    {
        return $this->NewObjectID;
    }
    /**
     * Set NewObjectID value
     * @param string $newObjectID
     * @return \App\Library\ExactTarget\StructType\CreateResult
     */
    public function setNewObjectID($newObjectID = null)
    {
        // validation for constraint: string
        if (!is_null($newObjectID) && !is_string($newObjectID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newObjectID)), __LINE__);
        }
        $this->NewObjectID = $newObjectID;
        return $this;
    }
    /**
     * Get PartnerKey value
     * @return string|null
     */
    public function getPartnerKey()
    {
        return $this->PartnerKey;
    }
    /**
     * Set PartnerKey value
     * @param string $partnerKey
     * @return \App\Library\ExactTarget\StructType\CreateResult
     */
    public function setPartnerKey($partnerKey = null)
    {
        // validation for constraint: string
        if (!is_null($partnerKey) && !is_string($partnerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($partnerKey)), __LINE__);
        }
        $this->PartnerKey = $partnerKey;
        return $this;
    }
    /**
     * Get Object value
     * @return \App\Library\ExactTarget\StructType\APIObject|null
     */
    public function getObject()
    {
        return $this->Object;
    }
    /**
     * Set Object value
     * @param \App\Library\ExactTarget\StructType\APIObject $object
     * @return \App\Library\ExactTarget\StructType\CreateResult
     */
    public function setObject(\App\Library\ExactTarget\StructType\APIObject $object = null)
    {
        $this->Object = $object;
        return $this;
    }
    /**
     * Get CreateResults value
     * @return \App\Library\ExactTarget\StructType\CreateResult[]|null
     */
    public function getCreateResults()
    {
        return $this->CreateResults;
    }
    /**
     * Set CreateResults value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\CreateResult[] $createResults
     * @return \App\Library\ExactTarget\StructType\CreateResult
     */
    public function setCreateResults(array $createResults = array())
    {
        foreach ($createResults as $createResultCreateResultsItem) {
            // validation for constraint: itemType
            if (!$createResultCreateResultsItem instanceof \App\Library\ExactTarget\StructType\CreateResult) {
                throw new \InvalidArgumentException(sprintf('The CreateResults property can only contain items of \App\Library\ExactTarget\StructType\CreateResult, "%s" given', is_object($createResultCreateResultsItem) ? get_class($createResultCreateResultsItem) : gettype($createResultCreateResultsItem)), __LINE__);
            }
        }
        $this->CreateResults = $createResults;
        return $this;
    }
    /**
     * Add item to CreateResults value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\CreateResult $item
     * @return \App\Library\ExactTarget\StructType\CreateResult
     */
    public function addToCreateResults(\App\Library\ExactTarget\StructType\CreateResult $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Library\ExactTarget\StructType\CreateResult) {
            throw new \InvalidArgumentException(sprintf('The CreateResults property can only contain items of \App\Library\ExactTarget\StructType\CreateResult, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CreateResults[] = $item;
        return $this;
    }
    /**
     * Get ParentPropertyName value
     * @return string|null
     */
    public function getParentPropertyName()
    {
        return $this->ParentPropertyName;
    }
    /**
     * Set ParentPropertyName value
     * @param string $parentPropertyName
     * @return \App\Library\ExactTarget\StructType\CreateResult
     */
    public function setParentPropertyName($parentPropertyName = null)
    {
        // validation for constraint: string
        if (!is_null($parentPropertyName) && !is_string($parentPropertyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($parentPropertyName)), __LINE__);
        }
        $this->ParentPropertyName = $parentPropertyName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\CreateResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
