<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateResponse StructType
 * @subpackage Structs
 */
class CreateResponse extends AbstractStructBase
{
    /**
     * The Results
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \App\Library\ExactTarget\StructType\CreateResult[]
     */
    public $Results;
    /**
     * The OverallStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OverallStatus;
    /**
     * The RequestID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RequestID;
    /**
     * Constructor method for CreateResponse
     * @uses CreateResponse::setResults()
     * @uses CreateResponse::setOverallStatus()
     * @uses CreateResponse::setRequestID()
     * @param \App\Library\ExactTarget\StructType\CreateResult[] $results
     * @param string $overallStatus
     * @param string $requestID
     */
    public function __construct(array $results = array(), $overallStatus = null, $requestID = null)
    {
        $this
            ->setResults($results)
            ->setOverallStatus($overallStatus)
            ->setRequestID($requestID);
    }
    /**
     * Get Results value
     * @return \App\Library\ExactTarget\StructType\CreateResult[]
     */
    public function getResults()
    {
        return $this->Results;
    }
    /**
     * Set Results value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\CreateResult[] $results
     * @return \App\Library\ExactTarget\StructType\CreateResponse
     */
    public function setResults(array $results = array())
    {
        foreach ($results as $createResponseResultsItem) {
            // validation for constraint: itemType
            if (!$createResponseResultsItem instanceof \App\Library\ExactTarget\StructType\CreateResult) {
                throw new \InvalidArgumentException(sprintf('The Results property can only contain items of \App\Library\ExactTarget\StructType\CreateResult, "%s" given', is_object($createResponseResultsItem) ? get_class($createResponseResultsItem) : gettype($createResponseResultsItem)), __LINE__);
            }
        }
        $this->Results = $results;
        return $this;
    }
    /**
     * Add item to Results value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\CreateResult $item
     * @return \App\Library\ExactTarget\StructType\CreateResponse
     */
    public function addToResults(\App\Library\ExactTarget\StructType\CreateResult $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Library\ExactTarget\StructType\CreateResult) {
            throw new \InvalidArgumentException(sprintf('The Results property can only contain items of \App\Library\ExactTarget\StructType\CreateResult, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Results[] = $item;
        return $this;
    }
    /**
     * Get OverallStatus value
     * @return string
     */
    public function getOverallStatus()
    {
        return $this->OverallStatus;
    }
    /**
     * Set OverallStatus value
     * @param string $overallStatus
     * @return \App\Library\ExactTarget\StructType\CreateResponse
     */
    public function setOverallStatus($overallStatus = null)
    {
        // validation for constraint: string
        if (!is_null($overallStatus) && !is_string($overallStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($overallStatus)), __LINE__);
        }
        $this->OverallStatus = $overallStatus;
        return $this;
    }
    /**
     * Get RequestID value
     * @return string|null
     */
    public function getRequestID()
    {
        return $this->RequestID;
    }
    /**
     * Set RequestID value
     * @param string $requestID
     * @return \App\Library\ExactTarget\StructType\CreateResponse
     */
    public function setRequestID($requestID = null)
    {
        // validation for constraint: string
        if (!is_null($requestID) && !is_string($requestID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestID)), __LINE__);
        }
        $this->RequestID = $requestID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\CreateResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
